/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.blockentity;

import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import dev.smolinacadena.refinedcooking.RefinedCookingBlockEntities;
import dev.smolinacadena.refinedcooking.RefinedCookingBlocks;
import dev.smolinacadena.refinedcooking.api.cookingforblockheads.capability.KitchenItemProvider;
import dev.smolinacadena.refinedcooking.block.KitchenStationBlock;
import dev.smolinacadena.refinedcooking.network.KitchenStationNetworkNode;
import javax.annotation.Nonnull;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.forge.provider.ForgeBalmProviders;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitchenStationBlockEntity
extends NetworkNodeBlockEntity<KitchenStationNetworkNode> {
    private Capability<IKitchenItemProvider> kitchenCapability;
    private final LazyOptional<KitchenItemProvider> itemProvider = LazyOptional.of(() -> new KitchenItemProvider(this));
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).build();

    public KitchenStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RefinedCookingBlockEntities.KITCHEN_STATION.get(), pos, state, SPEC);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.kitchenCapability == null) {
            ForgeBalmProviders forgeProviders = (ForgeBalmProviders)Balm.getProviders();
            this.kitchenCapability = forgeProviders.getCapability(IKitchenItemProvider.class);
        }
        return cap == this.kitchenCapability ? this.itemProvider.cast() : super.getCapability(cap, side);
    }

    @Nonnull
    public KitchenStationNetworkNode createNode(Level level, BlockPos pos) {
        return new KitchenStationNetworkNode(level, pos);
    }

    public void setConnected(boolean connected) {
        this.f_58857_.m_7696_(this.f_58858_, (Block)RefinedCookingBlocks.KITCHEN_STATION.get(), 0, 0);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)KitchenStationBlock.CONNECTED, (Comparable)Boolean.valueOf(connected)));
        this.m_6596_();
    }
}

