/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.util;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;

public final class UnintuitiveApiHelper {
    private UnintuitiveApiHelper() {
    }

    public static Set<IRecipeCategory<?>> getHiddenRecipeCategories(IRecipeManager manager) {
        Set all = manager.createRecipeCategoryLookup().includeHidden().get().collect(Collectors.toSet());
        Set visible = manager.createRecipeCategoryLookup().get().collect(Collectors.toSet());
        return Sets.difference(all, visible);
    }

    public static <T> ResourceLocation getRecipeCategoryId(IRecipeCategory<T> category) {
        return category.getRecipeType().getUid();
    }

    public static <T> void hideCategory(IRecipeCategory<T> category, IRecipeManager manager) {
        manager.hideRecipeCategory(category.getRecipeType());
    }

    public static <T> void hideRecipeWithinCategory(IRecipeCategory<T> category, T recipe, IRecipeManager manager) {
        manager.hideRecipes(category.getRecipeType(), List.of(recipe));
    }
}

