/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.util;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class JeiCategoriesState {
    private static final Supplier<JeiCategoriesState> INSTANCE = Suppliers.memoize(JeiCategoriesState::new);
    private final ReloadableLazyCategoryStateSortedSet states = new ReloadableLazyCategoryStateSortedSet(new TreeSet<JeiCategoryState>());

    private JeiCategoriesState() {
    }

    public static JeiCategoriesState get() {
        return INSTANCE.get();
    }

    public void registerStatesProvider(BiFunction<JeiCategoryState.Creator, JeiCategoryState.Creator, Set<JeiCategoryState>> states) {
        this.states.updateState(() -> (Set)states.apply(JeiCategoryStateProvider::ofVisible, JeiCategoryStateProvider::ofHidden));
    }

    public Stream<JeiCategoryState> knownCategoryStates() {
        return this.states.stream();
    }

    private static final class ReloadableLazyCategoryStateSortedSet
    implements SortedSet<JeiCategoryState> {
        private final SortedSet<JeiCategoryState> backend;
        private final @UnmodifiableView SortedSet<JeiCategoryState> exposedView;
        private final AtomicReference<Supplier<Set<JeiCategoryState>>> updatedStateSupplier;

        ReloadableLazyCategoryStateSortedSet(SortedSet<JeiCategoryState> backend) {
            this.backend = backend;
            this.exposedView = Collections.unmodifiableSortedSet(this.backend);
            this.updatedStateSupplier = new AtomicReference<Object>(null);
        }

        void updateState(Supplier<Set<JeiCategoryState>> state) {
            this.updatedStateSupplier.set(Objects.requireNonNull(state, "updater"));
        }

        private void verifyUpdateState() {
            Supplier updatedState = this.updatedStateSupplier.getAndSet(null);
            if (updatedState != null) {
                this.backend.clear();
                this.backend.addAll((Collection)updatedState.get());
            }
        }

        @Override
        @Nullable
        public Comparator<? super JeiCategoryState> comparator() {
            return this.exposedView.comparator();
        }

        @Override
        @NotNull
        public SortedSet<JeiCategoryState> subSet(JeiCategoryState fromElement, JeiCategoryState toElement) {
            this.verifyUpdateState();
            return this.exposedView.subSet(fromElement, toElement);
        }

        @Override
        @NotNull
        public SortedSet<JeiCategoryState> headSet(JeiCategoryState toElement) {
            this.verifyUpdateState();
            return this.exposedView.headSet(toElement);
        }

        @Override
        @NotNull
        public SortedSet<JeiCategoryState> tailSet(JeiCategoryState fromElement) {
            this.verifyUpdateState();
            return this.exposedView.tailSet(fromElement);
        }

        @Override
        public JeiCategoryState first() {
            this.verifyUpdateState();
            return this.exposedView.first();
        }

        @Override
        public JeiCategoryState last() {
            this.verifyUpdateState();
            return this.exposedView.last();
        }

        @Override
        public Spliterator<JeiCategoryState> spliterator() {
            this.verifyUpdateState();
            return this.exposedView.spliterator();
        }

        @Override
        public int size() {
            this.verifyUpdateState();
            return this.exposedView.size();
        }

        @Override
        public boolean isEmpty() {
            this.verifyUpdateState();
            return this.exposedView.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            this.verifyUpdateState();
            return this.exposedView.contains(o);
        }

        @Override
        @NotNull
        public Iterator<JeiCategoryState> iterator() {
            this.verifyUpdateState();
            return this.exposedView.iterator();
        }

        @Override
        @NotNull
        public @NotNull Object @NotNull [] toArray() {
            this.verifyUpdateState();
            return this.exposedView.toArray();
        }

        @Override
        @NotNull
        public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
            this.verifyUpdateState();
            return this.exposedView.toArray(a);
        }

        @Override
        public boolean add(JeiCategoryState jeiCategoryState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            this.verifyUpdateState();
            return this.exposedView.containsAll(c);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends JeiCategoryState> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            this.verifyUpdateState();
            return this.exposedView.toArray(generator);
        }

        @Override
        public boolean removeIf(Predicate<? super JeiCategoryState> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<JeiCategoryState> stream() {
            this.verifyUpdateState();
            return this.exposedView.stream();
        }

        @Override
        public Stream<JeiCategoryState> parallelStream() {
            this.verifyUpdateState();
            return this.exposedView.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super JeiCategoryState> action) {
            this.verifyUpdateState();
            this.exposedView.forEach(action);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReloadableLazyCategoryStateSortedSet)) {
                return false;
            }
            ReloadableLazyCategoryStateSortedSet set = (ReloadableLazyCategoryStateSortedSet)obj;
            this.verifyUpdateState();
            set.verifyUpdateState();
            return this.backend.equals(set.backend);
        }

        @Override
        public int hashCode() {
            this.verifyUpdateState();
            return this.backend.hashCode();
        }

        public String toString() {
            this.verifyUpdateState();
            return this.backend.toString();
        }
    }

    public static interface JeiCategoryState
    extends Comparable<JeiCategoryState> {
        public ResourceLocation id();

        public Visibility visibility();

        public String toString();

        @FunctionalInterface
        public static interface Creator
        extends Function<ResourceLocation, JeiCategoryState> {
        }

        public static enum Visibility {
            VISIBLE("visible"),
            HIDDEN("hidden");

            private final String friendlyName;

            private Visibility(String friendlyName) {
                this.friendlyName = friendlyName;
            }

            public String toString() {
                return this.friendlyName;
            }
        }
    }

    private static final class JeiCategoryStateProvider
    implements JeiCategoryState {
        private static final Comparator<JeiCategoryState> COMPARATOR = Comparator.comparing(JeiCategoryState::visibility).thenComparing(JeiCategoryState::id, Comparator.comparing(ResourceLocation::m_135827_).thenComparing(ResourceLocation::m_135815_));
        private final ResourceLocation id;
        private final JeiCategoryState.Visibility visibility;

        private JeiCategoryStateProvider(ResourceLocation id, JeiCategoryState.Visibility visibility) {
            this.id = id;
            this.visibility = visibility;
        }

        static JeiCategoryState ofVisible(ResourceLocation id) {
            return JeiCategoryStateProvider.of(id, JeiCategoryState.Visibility.VISIBLE);
        }

        static JeiCategoryState ofHidden(ResourceLocation id) {
            return JeiCategoryStateProvider.of(id, JeiCategoryState.Visibility.HIDDEN);
        }

        private static JeiCategoryState of(ResourceLocation id, JeiCategoryState.Visibility visibility) {
            return new JeiCategoryStateProvider(Objects.requireNonNull(id, "id"), visibility);
        }

        @Override
        public ResourceLocation id() {
            return this.id;
        }

        @Override
        public JeiCategoryState.Visibility visibility() {
            return this.visibility;
        }

        @Override
        public int compareTo(@NotNull JeiCategoryState o) {
            return COMPARATOR.compare(this, o);
        }

        @Override
        public String toString() {
            return "<resource:%s> (%s)".formatted(new Object[]{this.id(), this.visibility()});
        }
    }
}

