/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.ingredient;

import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientCreator;
import com.blamejared.jeitweaker.common.ingredient.BothJeiIngredient;
import com.blamejared.jeitweaker.common.ingredient.JeiOnlyJeiIngredient;
import com.blamejared.jeitweaker.common.ingredient.ZenOnlyJeiIngredient;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class SimpleJeiIngredientCreator
implements JeiIngredientCreator {
    private static final Supplier<JeiIngredientCreator> INSTANCE = Suppliers.memoize(SimpleJeiIngredientCreator::new);
    private final FromZen fromZen = new FromZen();
    private final FromJei fromJei = new FromJei();
    private final FromBoth fromBoth = new FromBoth();

    private SimpleJeiIngredientCreator() {
    }

    public static JeiIngredientCreator get() {
        return INSTANCE.get();
    }

    @Override
    public JeiIngredientCreator.FromZen fromZen() {
        return this.fromZen;
    }

    @Override
    public JeiIngredientCreator.FromJei fromJei() {
        return this.fromJei;
    }

    @Override
    public JeiIngredientCreator.FromBoth fromBoth() {
        return this.fromBoth;
    }

    private static final class FromZen
    implements JeiIngredientCreator.FromZen {
        FromZen() {
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(Z zenContent) {
            return type -> ZenOnlyJeiIngredient.of(type, zenContent);
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(Z zenContent, UnaryOperator<Z> copier) {
            return type -> ZenOnlyJeiIngredient.of(type, zenContent, copier);
        }
    }

    private static final class FromJei
    implements JeiIngredientCreator.FromJei {
        FromJei() {
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(J jeiContent) {
            return type -> JeiOnlyJeiIngredient.of(type, jeiContent);
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(J jeiContent, UnaryOperator<J> copier) {
            return type -> JeiOnlyJeiIngredient.of(type, jeiContent, copier);
        }
    }

    private static final class FromBoth
    implements JeiIngredientCreator.FromBoth {
        FromBoth() {
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(J jeiContent, Z zenContent) {
            return type -> BothJeiIngredient.of(type, jeiContent, zenContent);
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(J jeiContent, UnaryOperator<J> jeiCopier, Z zenContent) {
            return type -> BothJeiIngredient.of(type, jeiContent, jeiCopier, zenContent);
        }

        @Override
        public <J, Z> JeiIngredientCreator.Creator<J, Z> of(J jeiContent, UnaryOperator<J> jeiCopier, Z zenContent, UnaryOperator<Z> zenCopier) {
            return type -> BothJeiIngredient.of(type, jeiContent, jeiCopier == null ? UnaryOperator.identity() : jeiCopier, zenContent, zenCopier);
        }
    }
}

