/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.command;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.jeitweaker.common.JeiTweakerInitializer;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandExecutor;
import com.blamejared.jeitweaker.common.api.command.JeiCommandType;
import com.blamejared.jeitweaker.common.platform.PlatformBridge;
import java.util.Objects;
import java.util.function.UnaryOperator;

final class SafeJeiCommandManager {
    private static final SafeWrapper<?> WRAPPER = PlatformBridge.INSTANCE.isDevEnv() ? SafeJeiCommandManager::passThrough : SafeJeiCommandManager::makeSafe;

    private SafeJeiCommandManager() {
    }

    public static <T> JeiCommand<T> safeOf(JeiCommand<T> command) {
        return (JeiCommand)GenericUtil.uncheck(WRAPPER.wrap((JeiCommand)GenericUtil.uncheck(Objects.requireNonNull(command, "command"))));
    }

    private static <T> JeiCommand<T> makeSafe(JeiCommand<T> command) {
        JeiCommandType<T> type = command.type();
        return JeiCommand.of(type, new SafeExecutor<Object>(command::execute, type));
    }

    private static <T> JeiCommand<T> passThrough(JeiCommand<T> command) {
        return command;
    }

    @FunctionalInterface
    private static interface SafeWrapper<T>
    extends UnaryOperator<JeiCommand<T>> {
        default public JeiCommand<T> wrap(JeiCommand<T> t) {
            return (JeiCommand)this.apply(t);
        }
    }

    private static final class SafeExecutor<T>
    implements JeiCommandExecutor<T> {
        private final JeiCommandExecutor<T> delegate;
        private final JeiCommandType<T> type;

        SafeExecutor(JeiCommandExecutor<T> delegate, JeiCommandType<T> type) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Override
        public void execute(T argument) {
            try {
                this.delegate.execute(argument);
            }
            catch (Throwable t) {
                String message = "An error occurred during execution of the command %s of type %s".formatted(this.delegate, this.type);
                JeiTweakerInitializer.get().jeiTweakerLogger().error(message, t);
            }
        }
    }
}

