/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.command;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;

final class CommandGeneration {
    private final AtomicInteger generation = new AtomicInteger(0);
    private final Queue<IntConsumer> reproductionManagers = Collections.checkedQueue(new ArrayDeque(), IntConsumer.class);

    private CommandGeneration() {
    }

    static CommandGeneration of() {
        return new CommandGeneration();
    }

    int currentGeneration() {
        return this.generation.get();
    }

    void awaitingReproduction(IntConsumer consumer) {
        this.reproductionManagers.offer(consumer);
    }

    void reproduce() {
        IntConsumer consumer;
        int newGeneration = this.generation.incrementAndGet();
        while ((consumer = this.reproductionManagers.poll()) != null) {
            consumer.accept(newGeneration);
        }
        assert (this.reproductionManagers.isEmpty());
    }

    public String toString() {
        return "Generation " + this.currentGeneration() + ", " + this.reproductionManagers.size() + " awaiting for reproduction";
    }
}

