/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.action;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.jeitweaker.common.JeiTweakerInitializer;
import com.blamejared.jeitweaker.common.api.action.JeiTweakerAction;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.blamejared.jeitweaker.common.util.UnintuitiveApiHelper;
import java.util.Objects;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;

public final class HideRecipeAction
extends JeiTweakerAction {
    private final ResourceLocation categoryId;
    private final ResourceLocation recipeId;

    private HideRecipeAction(ResourceLocation categoryId, ResourceLocation recipeId) {
        this.categoryId = categoryId;
        this.recipeId = recipeId;
    }

    public static HideRecipeAction of(ResourceLocation categoryId, ResourceLocation recipeId) {
        Objects.requireNonNull(categoryId, "categoryId");
        Objects.requireNonNull(recipeId, "recipeId");
        return new HideRecipeAction(categoryId, recipeId);
    }

    public void apply() {
        this.enqueueCommand(JeiCommand.of(JeiCommandTypes.GENERAL, this::hide));
    }

    public String describe() {
        return "Hiding recipe '%s' from JEI category with id '%s'".formatted(this.recipeId, this.categoryId);
    }

    private void hide(IJeiRuntime runtime) {
        IRecipeManager manager = runtime.getRecipeManager();
        manager.createRecipeCategoryLookup().includeHidden().get().filter(it -> this.categoryId.equals((Object)UnintuitiveApiHelper.getRecipeCategoryId(it))).findAny().ifPresentOrElse(it -> this.hide(manager, (IRecipeCategory)it), this::warnCategory);
    }

    private <T> void hide(IRecipeManager manager, IRecipeCategory<T> category) {
        CraftTweakerAPI.getAccessibleElementsProvider().recipeManager().m_44043_(this.recipeId).ifPresentOrElse(it -> this.hide(manager, category, it), this::warnRecipe);
    }

    private <T, U> void hide(IRecipeManager manager, IRecipeCategory<T> category, U recipe) {
        try {
            UnintuitiveApiHelper.hideRecipeWithinCategory(category, GenericUtil.uncheck(recipe), manager);
        }
        catch (IllegalArgumentException e) {
            JeiTweakerInitializer.get().jeiTweakerLogger().error(() -> "Unable to hide target recipe '" + this.recipeId + "' within category '" + this.categoryId + "' due to an error; maybe the recipe is not removable?", (Throwable)e);
        }
    }

    private void warnCategory() {
        JeiTweakerInitializer.get().jeiTweakerLogger().warn("No JEI category with ID '{}' was found for hiding: command skipped", (Object)this.categoryId);
    }

    private void warnRecipe() {
        JeiTweakerInitializer.get().jeiTweakerLogger().warn("No recipe with ID '{}' was found for hiding: command skipped; note that this does not imply the recipe does not exist within JEI", (Object)this.recipeId);
    }
}

