/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.action;

import com.blamejared.jeitweaker.common.api.action.JeiTweakerAction;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientTypes;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredients;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;

public final class HideIngredientsByRegexAction
extends JeiTweakerAction {
    private final Pattern regex;

    private HideIngredientsByRegexAction(Pattern regex) {
        this.regex = regex;
    }

    public static HideIngredientsByRegexAction of(String pattern) {
        return new HideIngredientsByRegexAction(Pattern.compile(Objects.requireNonNull(pattern, "pattern")));
    }

    public void apply() {
        this.enqueueCommand(JeiCommand.of(JeiCommandTypes.GENERAL, this::hide));
    }

    public String describe() {
        return "Hiding all ingredients matching regex '%s' from JEI".formatted(this.regex.pattern());
    }

    private void hide(IJeiRuntime runtime) {
        IIngredientManager manager = runtime.getIngredientManager();
        Predicate<String> matcher = this.regex.asMatchPredicate();
        manager.getRegisteredIngredientTypes().stream().flatMap(type -> this.ingredientsOfType(manager, (IIngredientType)type)).filter(ingredient -> matcher.test(JeiIngredients.toRegistryName(ingredient).toString())).collect(Collectors.groupingBy(JeiIngredients::jeiIngredientTypeOf, Collectors.mapping(JeiIngredient::jeiContent, Collectors.toList()))).forEach((type, ingredient) -> this.doHide(manager, (IIngredientType)type, (List)ingredient));
    }

    private <J, Z> Stream<JeiIngredient<J, Z>> ingredientsOfType(IIngredientManager manager, IIngredientType<J> ingredientType) {
        return Stream.ofNullable(JeiIngredientTypes.fromJeiTypeOrNull(ingredientType)).flatMap(type -> manager.getAllIngredients(ingredientType).stream().map(it -> JeiIngredient.ofJei(type, it)));
    }

    private <J> void doHide(IIngredientManager manager, IIngredientType<J> type, List<J> ingredients) {
        if (ingredients.isEmpty()) {
            return;
        }
        manager.removeIngredientsAtRuntime(type, ingredients);
    }
}

