/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.common;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ServerPackProvider
extends DynServerResourcesGenerator {
    public static final ServerPackProvider INSTANCE = new ServerPackProvider();

    public ServerPackProvider() {
        super(new DynamicDataPack(SuppSquared.res("generated_pack"), Pack.Position.BOTTOM, true, true));
        ((DynamicDataPack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.dynamicPack).addNamespaces(new String[]{"supplementaries"});
    }

    public Logger getLogger() {
        return SuppSquared.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        super.regenerateDynamicAssets(executor);
        executor.accept((manager, sink) -> {
            SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)SuppSquared.res("item_shelves"));
            SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                builder.addEntry(sign);
                if (wood != VanillaWoodTypes.OAK) {
                    sink.addSimpleBlockLootTable(sign);
                }
            });
            sink.addTag(builder, Registries.f_256747_);
            sink.addTag(builder, Registries.f_256913_);
            this.addItemShelfRecipes(manager, sink);
        });
    }

    private void addItemShelfRecipes(ResourceManager manager, ResourceSink sink) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(SuppSquared.res("item_shelf_oak")));
        SuppSquared.ITEM_SHELVES.forEach((w, b) -> {
            if (w != VanillaWoodTypes.OAK) {
                FinishedRecipe newR = template.createSimilar((BlockType)VanillaWoodTypes.OAK, (BlockType)w, w.mainChild().m_5456_());
                if (newR == null) {
                    return;
                }
                newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                sink.addJson(SuppSquared.res(Utils.getID((Block)b).m_135815_()), (JsonElement)newR.m_125966_(), ResType.RECIPES);
                ResourceLocation advancementId = newR.m_6448_();
                if (advancementId != null) {
                    sink.addJson(newR.m_6448_(), (JsonElement)newR.m_5860_(), ResType.ADVANCEMENTS);
                }
            }
        });
    }
}

