/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.forge.mixin;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import uk.co.dotcode.asb.ModUtils;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    public int asbTickCount = 0;

    @Inject(at={@At(value="HEAD")}, method={"tickEffects"}, cancellable=true)
    public void tickEffects(CallbackInfo ci) {
        ++this.asbTickCount;
        if (this.asbTickCount >= 10) {
            LivingEntity livingEntity = (LivingEntity)this;
            ModUtils.checkAndApplyBonusesTo(livingEntity, livingEntity, "self");
            ModUtils.checkAndApplyImmunitiesTo(livingEntity, livingEntity);
            this.asbTickCount = 0;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canBeAffected"}, cancellable=true)
    public void canBeAffected(MobEffectInstance mobEffectInstance, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            boolean isImmune = ModUtils.isImmuneToEffect(mobEffectInstance, (LivingEntity)this);
            cir.setReturnValue((Object)(!isImmune ? 1 : 0));
        }
    }
}

