/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.AdditionalSetPiece;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.SetPiece;
import uk.co.dotcode.asb.config.forge.ArmorSetImpl;

public class ArmorSet {
    public String armorSetName;
    public boolean performanceMode = true;
    public SetPiece head;
    public SetPiece chest;
    public SetPiece legs;
    public SetPiece boots;
    public SetPiece mainHand;
    public SetPiece offHand;
    public AdditionalSetPiece[] additionalSetPieces;
    public Integer partialBonusRequiredAmount;
    public Bonus[] partialSetBonuses;
    public Bonus[] fullSetBonuses;
    public boolean hideGeneratedTooltip = false;
    public String[] customTooltips;
    public transient Integer armorSetCount;

    public ArmorSet(String setName, String head, String chest, String legs, String boots) {
        this.armorSetName = setName;
        this.head = new SetPiece(head);
        this.chest = new SetPiece(chest);
        this.legs = new SetPiece(legs);
        this.boots = new SetPiece(boots);
    }

    public ArmorSet(String setName, SetPiece head, SetPiece chest, SetPiece legs, SetPiece boots) {
        this.armorSetName = setName;
        this.head = head;
        this.chest = chest;
        this.legs = legs;
        this.boots = boots;
    }

    public boolean armorSetMatch(LivingEntity entity) {
        Object object;
        this.armorSetCount = 0;
        boolean head = this.head == null;
        boolean chest = this.chest == null;
        boolean legs = this.legs == null;
        boolean feet = this.boots == null;
        boolean mainHand = this.mainHand == null;
        boolean offHand = this.offHand == null;
        boolean additionalSetPieces = this.additionalSetPieces == null;
        for (ItemStack i : entity.m_6168_()) {
            Integer n;
            String itemRegName = ModUtils.getRegistryNameItem(i.m_41720_()).toString();
            if (this.head != null && this.head.matches(i, itemRegName)) {
                head = true;
                n = this.armorSetCount;
                this.armorSetCount = this.armorSetCount + 1;
                continue;
            }
            if (this.chest != null && this.chest.matches(i, itemRegName)) {
                chest = true;
                n = this.armorSetCount;
                this.armorSetCount = this.armorSetCount + 1;
                continue;
            }
            if (this.legs != null && this.legs.matches(i, itemRegName)) {
                legs = true;
                n = this.armorSetCount;
                this.armorSetCount = this.armorSetCount + 1;
                continue;
            }
            if (this.boots == null || !this.boots.matches(i, itemRegName)) continue;
            feet = true;
            n = this.armorSetCount;
            this.armorSetCount = this.armorSetCount + 1;
        }
        if (this.mainHand != null && this.mainHand.matches(entity.m_21205_(), ModUtils.getRegistryNameItem(entity.m_21205_().m_41720_()).toString())) {
            mainHand = true;
            object = this.armorSetCount;
            this.armorSetCount = this.armorSetCount + 1;
        }
        if (this.offHand != null && this.offHand.matches(entity.m_21206_(), ModUtils.getRegistryNameItem(entity.m_21206_().m_41720_()).toString())) {
            offHand = true;
            object = this.armorSetCount;
            this.armorSetCount = this.armorSetCount + 1;
        }
        additionalSetPieces = ArmorSet.armorSetMatchAdditional(entity, this.additionalSetPieces);
        this.armorSetCount = this.armorSetCount + ArmorSet.armorSetCountAdditional(entity, this.additionalSetPieces);
        return head && chest && legs && feet && mainHand && offHand && additionalSetPieces;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean armorSetMatchAdditional(LivingEntity entity, AdditionalSetPiece[] additionalSetPieces) {
        void var1_1;
        return ArmorSetImpl.armorSetMatchAdditional(entity, (AdditionalSetPiece[])var1_1);
    }

    public int armorSetCount(LivingEntity entity) {
        return this.armorSetCount != null ? this.armorSetCount : 0;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int armorSetCountAdditional(LivingEntity entity, AdditionalSetPiece[] additionalSetPieces) {
        void var1_1;
        return ArmorSetImpl.armorSetCountAdditional(entity, (AdditionalSetPiece[])var1_1);
    }

    public boolean isPartOfSet(String item) {
        if (this.head != null && this.head.matchesSimple(item)) {
            return true;
        }
        if (this.chest != null && this.chest.matchesSimple(item)) {
            return true;
        }
        if (this.legs != null && this.legs.matchesSimple(item)) {
            return true;
        }
        if (this.boots != null && this.boots.matchesSimple(item)) {
            return true;
        }
        if (this.mainHand != null && this.mainHand.matchesSimple(item)) {
            return true;
        }
        if (this.offHand != null && this.offHand.matchesSimple(item)) {
            return true;
        }
        return ArmorSet.isPartOfSetAdditional(item, this.additionalSetPieces);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isPartOfSetAdditional(String item, AdditionalSetPiece[] additionalSetPieces) {
        void var1_1;
        return ArmorSetImpl.isPartOfSetAdditional(item, (AdditionalSetPiece[])var1_1);
    }

    public boolean isValid() {
        boolean isBonusValid;
        boolean valid = true;
        if (this.armorSetName == null || this.armorSetName.isEmpty()) {
            ModLogger.warn("Failed to add custom armorset: It is unnamed!");
            valid = false;
        }
        if (this.head != null && !this.head.verify(this.armorSetName, "head")) {
            valid = false;
        }
        if (this.chest != null && !this.chest.verify(this.armorSetName, "chest")) {
            valid = false;
        }
        if (this.legs != null && !this.legs.verify(this.armorSetName, "legs")) {
            valid = false;
        }
        if (this.boots != null && !this.boots.verify(this.armorSetName, "boots")) {
            valid = false;
        }
        if (this.mainHand != null && !this.mainHand.verify(this.armorSetName, "mainHand")) {
            valid = false;
        }
        if (this.offHand != null && !this.offHand.verify(this.armorSetName, "offHand")) {
            valid = false;
        }
        if (!ArmorSet.verifyAdditional(this.armorSetName, this.additionalSetPieces)) {
            valid = false;
        }
        if (this.partialSetBonuses != null && this.partialSetBonuses.length > 0) {
            if (this.partialBonusRequiredAmount != null) {
                if (this.partialBonusRequiredAmount < 1 || this.partialBonusRequiredAmount > 5) {
                    ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' is limited to the values 2-5 (inclusive).");
                    valid = false;
                } else if (this.partialBonusRequiredAmount >= this.getPieceCount()) {
                    ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' is equal to or higher than the total of " + this.getPieceCount() + " armor pieces. Make sure that it is less than this number.");
                    valid = false;
                }
            } else {
                ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' must be defined because you have added partial bonuses.");
                valid = false;
            }
            for (Bonus b : this.partialSetBonuses) {
                isBonusValid = b.isValid(this.armorSetName);
                if (isBonusValid) continue;
                ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". Check reasons logged above.");
                valid = false;
            }
        }
        if (this.partialBonusRequiredAmount != null && this.partialBonusRequiredAmount > 0 && (this.partialSetBonuses == null || this.partialSetBonuses.length <= 0)) {
            ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". You have defined 'partialBonusRequiredAmount', but there are no 'partialSetBonuses' defined");
            valid = false;
        }
        if (this.fullSetBonuses != null) {
            if (this.fullSetBonuses.length <= 0) {
                ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
                valid = false;
            } else {
                for (Bonus b : this.fullSetBonuses) {
                    isBonusValid = b.isValid(this.armorSetName);
                    if (isBonusValid) continue;
                    ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". Check reasons logged above.");
                    valid = false;
                }
            }
        } else {
            ModLogger.warn("Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
            valid = false;
        }
        return valid;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isAdditionalValid(AdditionalSetPiece[] additionalSetPieces) {
        return ArmorSetImpl.isAdditionalValid(additionalSetPieces);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean verifyAdditional(String armorSetName, AdditionalSetPiece[] additionalSetPieces) {
        void var1_1;
        return ArmorSetImpl.verifyAdditional(armorSetName, (AdditionalSetPiece[])var1_1);
    }

    public int getPieceCount() {
        int count = 0;
        if (this.head != null) {
            ++count;
        }
        if (this.chest != null) {
            ++count;
        }
        if (this.legs != null) {
            ++count;
        }
        if (this.boots != null) {
            ++count;
        }
        if (this.mainHand != null) {
            ++count;
        }
        if (this.offHand != null) {
            ++count;
        }
        return count += ArmorSet.getAdditionalPieceCount(this.additionalSetPieces);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getAdditionalPieceCount(AdditionalSetPiece[] additionalSetPieces) {
        return ArmorSetImpl.getAdditionalPieceCount(additionalSetPieces);
    }
}

