/*
 * Decompiled with CFR 0.152.
 */
package velizarbg.suggestion_tweaker.mixins;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.SharedSuggestionProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import velizarbg.suggestion_tweaker.Constants;

@Mixin(value={ClientSuggestionProvider.class})
public class ClientCommandSourceMixin {
    private String currentInput;
    private static final char[] SPECIAL_CUTOFF_CHARS = new char[]{'[', '=', ','};

    @Redirect(method={"getCompletions"}, at=@At(target="Lcom/mojang/brigadier/context/CommandContext;getInput()Ljava/lang/String;", value="INVOKE"))
    private String processInput(CommandContext<?> context) {
        String input = context.getInput();
        int cutoffIndex = input.lastIndexOf(32);
        for (char c : SPECIAL_CUTOFF_CHARS) {
            int index = input.lastIndexOf(c);
            if (index <= cutoffIndex) continue;
            cutoffIndex = index;
        }
        this.currentInput = input.substring(cutoffIndex + 1);
        return input.substring(0, cutoffIndex + 1);
    }

    @ModifyVariable(method={"onCommandSuggestions"}, at=@At(target="Ljava/util/concurrent/CompletableFuture;complete(Ljava/lang/Object;)Z", value="INVOKE", shift=At.Shift.BEFORE), index=2, argsOnly=true)
    private Suggestions filterSuggestions(Suggestions suggestions) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        ArrayList<Suggestion> suggestionList = new ArrayList<Suggestion>();
        for (Suggestion suggestion : suggestions.getList()) {
            if (!(Constants.config.isCaseSensitive ? SharedSuggestionProvider.m_82949_((String)this.currentInput, (String)suggestion.getText()) : SharedSuggestionProvider.m_82949_((String)this.currentInput.toLowerCase(Locale.ROOT), (String)suggestion.getText().toLowerCase(Locale.ROOT)))) continue;
            suggestionList.add(new Suggestion(new StringRange(suggestion.getRange().getStart(), suggestion.getRange().getEnd() + this.currentInput.length()), suggestion.getText(), suggestion.getTooltip()));
            start = Math.min(suggestion.getRange().getStart(), start);
            end = Math.max(suggestion.getRange().getEnd(), end);
        }
        return new Suggestions(new StringRange(start, end), suggestionList);
    }
}

