/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player.display;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ParticleIndicators;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class ClaimDisplay {
    private boolean initialDisplay;
    private int displayTime;
    private final int height;
    private final DisplayBox display;
    public final EnumDisplayType type;
    private int[][] corners;
    private int[][] middlePoss;
    private DisplayBox.Box prevDims;
    private final DustParticleOptions corner;
    private final DustParticleOptions middle;
    private final Block displayBlock;

    public ClaimDisplay(Claim claim, EnumDisplayType type, int y) {
        this(claim.display(), (Level)claim.getWorld(), type, y);
    }

    public ClaimDisplay(DisplayBox display, Level level, EnumDisplayType type, int y) {
        this.display = display;
        this.displayTime = ConfigHandler.CONFIG.claimDisplayTime;
        this.prevDims = display.box();
        this.type = type;
        this.height = Math.max(1 + level.m_141937_(), y);
        switch (type) {
            case SUB: {
                this.corner = ParticleIndicators.SUBCLAIMCORNER;
                this.middle = ParticleIndicators.SUBCLAIMMIDDLE;
                this.displayBlock = Blocks.f_50075_;
                break;
            }
            case CONFLICT: {
                this.corner = ParticleIndicators.OVERLAPCLAIM;
                this.middle = ParticleIndicators.OVERLAPCLAIM;
                this.displayBlock = Blocks.f_50330_;
                break;
            }
            case EDIT: {
                this.corner = ParticleIndicators.EDITCLAIMCORNER;
                this.middle = ParticleIndicators.EDITCLAIMMIDDLE;
                this.displayBlock = Blocks.f_50060_;
                break;
            }
            default: {
                this.corner = ParticleIndicators.CLAIMCORNER;
                this.middle = ParticleIndicators.CLAIMMIDDLE;
                this.displayBlock = Blocks.f_50074_;
            }
        }
    }

    public boolean display(ServerPlayer player, boolean remove) {
        if (--this.displayTime % 2 == 0) {
            return this.display.isRemoved();
        }
        DisplayBox.Box dims = this.display.box();
        if (this.corners == null || this.changed(dims)) {
            this.onRemoved(player);
            HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap<ChunkPos, LevelChunk>();
            this.middlePoss = ClaimDisplay.calculateDisplayPos(player.m_284548_(), dims, this.height, this.display.excludedSides(), chunkCache);
            this.corners = this.calculateCorners(player.m_284548_(), dims, chunkCache);
            this.initialDisplay = false;
        }
        if (ConfigHandler.CONFIG.particleDisplay) {
            for (int[] pos : this.corners) {
                if (pos[1] != pos[2]) {
                    player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.corner, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                }
                player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.corner, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    if (pos[1] != pos[2]) {
                        player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.middle, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                    }
                    player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.middle, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                }
            }
        } else if (!this.initialDisplay) {
            BlockPos blockPos;
            for (int[] pos : this.corners) {
                blockPos = new BlockPos(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(blockPos.m_7495_(), this.displayBlock.m_49966_()));
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    blockPos = new BlockPos(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(blockPos.m_7495_(), this.displayBlock.m_49966_()));
                }
            }
        }
        this.prevDims = dims;
        if (!this.initialDisplay) {
            this.initialDisplay = true;
        }
        return this.display.isRemoved() || remove && this.displayTime < 0;
    }

    public void onRemoved(ServerPlayer player) {
        if (!ConfigHandler.CONFIG.particleDisplay) {
            BlockPos blockPos;
            if (this.corners != null) {
                for (int[] pos : this.corners) {
                    blockPos = new BlockPos(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    blockPos = blockPos.m_7495_();
                    player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(blockPos, player.m_9236_().m_8055_(blockPos)));
                }
            }
            if (this.middlePoss != null) {
                for (int[] pos : this.middlePoss) {
                    blockPos = new BlockPos(pos[0], pos[1] != pos[2] ? pos[2] : pos[1], pos[3]);
                    blockPos = blockPos.m_7495_();
                    player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(blockPos, player.m_9236_().m_8055_(blockPos)));
                }
            }
        }
    }

    private int[][] calculateCorners(ServerLevel level, DisplayBox.Box from, Map<ChunkPos, LevelChunk> chunkCache) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        int[] pos = ClaimDisplay.getPosFrom(level, from.minX(), from.minZ(), this.height, chunkCache);
        if (pos != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.maxX(), from.minZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.minX(), from.maxZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        if ((pos = ClaimDisplay.getPosFrom(level, from.maxX(), from.maxZ(), this.height, chunkCache)) != null) {
            l.add(pos);
        }
        return (int[][])l.toArray((T[])new int[0][]);
    }

    private boolean changed(DisplayBox.Box dims) {
        return !this.prevDims.equals(dims);
    }

    public static int[][] calculateDisplayPos(ServerLevel level, DisplayBox.Box from, int height, Set<Direction> exclude, Map<ChunkPos, LevelChunk> chunkCache) {
        int[] pos;
        ArrayList<int[]> l = new ArrayList<int[]>();
        HashSet<Integer> xs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minX(), from.maxX(), 10, xs);
        xs.add(from.minX() + 1);
        xs.add(from.maxX() - 1);
        HashSet<Integer> zs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minZ(), from.maxZ(), 10, zs);
        zs.add(from.minZ() + 1);
        zs.add(from.maxZ() - 1);
        Iterator iterator = xs.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (!exclude.contains(Direction.NORTH) && (pos = ClaimDisplay.getPosFrom(level, x, from.minZ(), height, chunkCache)) != null) {
                l.add(pos);
            }
            if (exclude.contains(Direction.SOUTH) || (pos = ClaimDisplay.getPosFrom(level, x, from.maxZ(), height, chunkCache)) == null) continue;
            l.add(pos);
        }
        iterator = zs.iterator();
        while (iterator.hasNext()) {
            int z = (Integer)iterator.next();
            if (!exclude.contains(Direction.WEST) && (pos = ClaimDisplay.getPosFrom(level, from.minX(), z, height, chunkCache)) != null) {
                l.add(pos);
            }
            if (exclude.contains(Direction.EAST) || (pos = ClaimDisplay.getPosFrom(level, from.maxX(), z, height, chunkCache)) == null) continue;
            l.add(pos);
        }
        return (int[][])l.toArray((T[])new int[0][]);
    }

    private static void addEvenly(int min, int max, int step, Set<Integer> l) {
        if ((double)(max - min) < (double)step * 1.5) {
            return;
        }
        if (max - min > 0 && (double)(max - min) <= (double)step * 0.5) {
            l.add(max - step + 1);
            l.add(min + step - 1);
            return;
        }
        l.add(max - step);
        l.add(min + step);
        ClaimDisplay.addEvenly(min + step, max - step, step, l);
    }

    public static int[] getPosFrom(ServerLevel level, int x, int z, int maxY, Map<ChunkPos, LevelChunk> chunkCache) {
        ChunkPos pos = new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
        LevelChunk chunk = chunkCache.computeIfAbsent(pos, k -> {
            if (!level.m_7232_(pos.f_45578_, pos.f_45579_)) {
                return null;
            }
            return level.m_6325_(pos.f_45578_, pos.f_45579_);
        });
        if (chunk == null) {
            return null;
        }
        int[] y = ClaimDisplay.nextAirAndWaterBlockFrom(chunk, x, maxY, z);
        return new int[]{x, y[0], y[1], z};
    }

    private static int[] nextAirAndWaterBlockFrom(LevelChunk chunk, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (state.m_247087_()) {
            boolean startedInLiquid = state.m_278721_();
            boolean liquidCheck = false;
            int liquidHeight = pos.m_123342_();
            while (state.m_247087_() && !chunk.m_151570_((BlockPos)pos)) {
                pos.m_122184_(0, -1, 0);
                state = chunk.m_8055_((BlockPos)pos);
                if (startedInLiquid || liquidCheck || !state.m_278721_()) continue;
                liquidCheck = true;
                liquidHeight = pos.m_123342_();
            }
            int[] yRet = new int[]{pos.m_123342_() + 1, (liquidCheck ? liquidHeight : pos.m_123342_()) + 1};
            if (startedInLiquid) {
                pos.m_122178_(pos.m_123341_(), liquidHeight + 1, pos.m_123343_());
                state = chunk.m_8055_((BlockPos)pos);
                while (state.m_278721_() && !chunk.m_151570_((BlockPos)pos)) {
                    pos.m_122184_(0, 1, 0);
                    state = chunk.m_8055_((BlockPos)pos);
                }
                if (state.m_247087_()) {
                    yRet[1] = pos.m_123342_();
                }
            }
            return yRet;
        }
        while (!state.m_247087_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            state = chunk.m_8055_((BlockPos)pos);
        }
        int[] yRet = new int[]{pos.m_123342_(), pos.m_123342_()};
        while (state.m_278721_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            state = chunk.m_8055_((BlockPos)pos);
        }
        if (state.m_247087_()) {
            yRet[1] = pos.m_123342_();
        }
        return yRet;
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimDisplay) {
            return this.display.equals(((ClaimDisplay)obj).display);
        }
        return false;
    }
}

