/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimGroup;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class GroupPlayerScreenHandler
extends ServerOnlyScreenHandler<ClaimGroup> {
    private final Claim claim;
    private final String group;
    private boolean removeMode;

    private GroupPlayerScreenHandler(int syncId, Inventory playerInventory, final Claim claim, final String group) {
        super(syncId, playerInventory, 6, new ClaimGroup(){

            @Override
            public Claim getClaim() {
                return claim;
            }

            @Override
            public String getGroup() {
                return group;
            }
        });
        this.claim = claim;
        this.group = group;
    }

    public static void openPlayerGroupMenu(Player player, final Claim claim, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new GroupPlayerScreenHandler(syncId, inv, claim, group);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("screenGroupPlayers"), group), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, ClaimGroup additionalData) {
        Claim claim = additionalData.getClaim();
        List<String> players = claim.playersFromGroup(player.m_20194_(), additionalData.getGroup());
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 3) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenAdd"), ChatFormatting.DARK_GREEN));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= players.size()) continue;
            ItemStack group = new ItemStack((ItemLike)Items.f_42680_);
            GameProfile gameProfile = new GameProfile(null, players.get(id));
            SkullBlockEntity.m_155738_((GameProfile)gameProfile, prof -> group.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)prof)));
            inv.updateStack(i, group);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                boolean fl = player.m_20194_().m_129927_().m_10996_(s).map(prof -> this.claim.setPlayerGroup(prof.getId(), this.group, false)).orElse(true);
                player.m_6915_();
                player.m_20194_().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, this.claim, this.group));
                if (fl) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
                } else {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("playerGroupAddFail"), ChatFormatting.RED), false);
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                }
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, this.claim, this.group));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            CompoundTag tag = stack.m_41698_("SkullOwner");
            if (this.removeMode && tag.m_128441_("Id")) {
                this.claim.setPlayerGroup(tag.m_128342_("Id"), null, false);
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

