/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CustomInteractListScreenHandler
extends ServerOnlyScreenHandler<Data> {
    private final Claim claim;
    private final Type type;
    private boolean removeMode;

    private CustomInteractListScreenHandler(int syncId, Inventory playerInventory, Data data) {
        super(syncId, playerInventory, 6, data);
        this.claim = data.claim;
        this.type = data.type;
    }

    public static void openMenu(Player player, final Type type, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new CustomInteractListScreenHandler(syncId, inv, new Data(claim, type));
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get(type.translationKey), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Data data) {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                stack = new ItemStack((ItemLike)Items.f_41996_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 3) {
                stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenAdd"), ChatFormatting.DARK_GREEN));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            List<ItemStack> stacks = switch (data.type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> data.claim.allowedItems.asStacks();
                case 1 -> data.claim.allowedBreakBlocks.asStacks();
                case 2 -> data.claim.allowedUseBlocks.asStacks();
                case 3 -> data.claim.allowedEntityAttack.asStacks();
                case 4 -> data.claim.allowedEntityUse.asStacks();
            };
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= stacks.size()) continue;
            ItemStack stack2 = stacks.get(id);
            stack2.m_41784_().m_128405_("Index", id);
            inv.updateStack(i, stack2);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                switch (this.type.ordinal()) {
                    case 0: {
                        if (s.startsWith("#")) {
                            this.claim.allowedItems.addAllowedItem((Either<Item, TagKey<Item>>)Either.right((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(s.substring(1)))));
                            break;
                        }
                        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s));
                        if (item == Items.f_41852_) break;
                        this.claim.allowedItems.addAllowedItem((Either<Item, TagKey<Item>>)Either.left((Object)item));
                        break;
                    }
                    case 1: {
                        if (s.startsWith("#")) {
                            this.claim.allowedBreakBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.right((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256975_.m_123023_(), (ResourceLocation)new ResourceLocation(s.substring(1)))));
                            break;
                        }
                        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(s));
                        if (block == Blocks.f_50016_) break;
                        this.claim.allowedBreakBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.left((Object)block));
                        break;
                    }
                    case 2: {
                        if (s.startsWith("#")) {
                            this.claim.allowedUseBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.right((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256975_.m_123023_(), (ResourceLocation)new ResourceLocation(s.substring(1)))));
                            break;
                        }
                        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(s));
                        if (block == Blocks.f_50016_) break;
                        this.claim.allowedUseBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.left((Object)block));
                        break;
                    }
                    case 3: {
                        if (s.startsWith("#")) {
                            this.claim.allowedEntityAttack.addAllowedItem(Either.right((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256780_.m_123023_(), (ResourceLocation)new ResourceLocation(s.substring(1)))));
                            break;
                        }
                        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(s));
                        if (entityType == EntityType.f_20510_ && !s.equals("minecraft:pig")) break;
                        this.claim.allowedEntityAttack.addAllowedItem(Either.left((Object)entityType));
                        break;
                    }
                    case 4: {
                        if (s.startsWith("#")) {
                            this.claim.allowedEntityUse.addAllowedItem(Either.right((Object)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256780_.m_123023_(), (ResourceLocation)new ResourceLocation(s.substring(1)))));
                            break;
                        }
                        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(s));
                        if (entityType == EntityType.f_20510_ && !s.equals("minecraft:pig")) break;
                        this.claim.allowedEntityUse.addAllowedItem(Either.left((Object)entityType));
                    }
                }
                player.m_6915_();
                player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, this.type, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, this.type, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            int idx;
            CompoundTag nbt = stack.m_41783_();
            int n = idx = nbt != null ? nbt.m_128451_("Index") : 0;
            if (this.removeMode) {
                switch (this.type.ordinal()) {
                    case 0: {
                        this.claim.allowedItems.removeAllowedItem(idx);
                        break;
                    }
                    case 1: {
                        this.claim.allowedBreakBlocks.removeAllowedItem(idx);
                        break;
                    }
                    case 2: {
                        this.claim.allowedUseBlocks.removeAllowedItem(idx);
                    }
                }
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            }
        }
        return false;
    }

    public record Data(Claim claim, Type type) {
    }

    public static enum Type {
        ITEM("screenMenuItemUse", "item"),
        BLOCKBREAK("screenMenuBlockBreak", "block_break"),
        BLOCKUSE("screenMenuBlockUse", "block_use"),
        ENTITYATTACK("screenMenuEntityAttack", "entity_attack"),
        ENTITYUSE("screenMenuEntityUse", "entity_use");

        public final String translationKey;
        public final String commandKey;

        private Type(String translationKey, String commandKey) {
            this.translationKey = translationKey;
            this.commandKey = commandKey;
        }
    }
}

