/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.IHungerAccessor;
import io.github.flemmli97.flan.mixin.IPersistentProjectileVars;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IOwnedItem;
import io.github.flemmli97.flan.utils.TeleportUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityInteractEvents {
    private static ResourceLocation TATERZEN = new ResourceLocation("taterzen", "npc");

    public static InteractionResult attackEntity(Player player, Level world, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        return EntityInteractEvents.attackSimple(player, entity, true);
    }

    public static InteractionResult useAtEntity(Player player, Level world, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        BlockPos pos;
        ServerPlayer serverPlayer;
        block10: {
            block9: {
                if (!(player instanceof ServerPlayer)) break block9;
                serverPlayer = (ServerPlayer)player;
                if (!player.m_5833_() && !EntityInteractEvents.canInteract(entity)) break block10;
            }
            return InteractionResult.PASS;
        }
        if (entity instanceof Enemy) {
            return InteractionResult.PASS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.m_20183_());
        if (claim != null) {
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canInteractWithEntity(entity)) {
                return InteractionResult.PASS;
            }
            ResourceLocation perm = ObjectToPermissionMap.getFromEntity(entity.m_6095_());
            if (perm != null) {
                return claim.canInteract(serverPlayer, perm, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof ArmorStand && !claim.canInteract(serverPlayer, BuiltinPermission.ARMORSTAND, pos, true)) {
                return InteractionResult.FAIL;
            }
            if (entity instanceof Mob) {
                return claim.canInteract(serverPlayer, BuiltinPermission.ANIMALINTERACT, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useEntity(Player p, Level world, InteractionHand hand, Entity entity) {
        BlockPos pos;
        ServerPlayer player;
        block14: {
            block13: {
                if (!(p instanceof ServerPlayer)) break block13;
                player = (ServerPlayer)p;
                if (!p.m_5833_() && !EntityInteractEvents.canInteract(entity)) break block14;
            }
            return InteractionResult.PASS;
        }
        if (entity instanceof Enemy) {
            return InteractionResult.PASS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.m_20183_());
        if (claim != null) {
            OwnableEntity tame;
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canInteractWithEntity(entity)) {
                return InteractionResult.PASS;
            }
            ResourceLocation perm = ObjectToPermissionMap.getFromEntity(entity.m_6095_());
            if (perm != null) {
                return claim.canInteract(player, perm, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof Boat) {
                return claim.canInteract(player, BuiltinPermission.BOAT, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof AbstractMinecart) {
                if (entity instanceof AbstractMinecartContainer) {
                    return claim.canInteract(player, BuiltinPermission.OPENCONTAINER, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
                }
                return claim.canInteract(player, BuiltinPermission.MINECART, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof AbstractVillager || CrossPlatformStuff.INSTANCE.registryEntities().getIDFrom(entity.m_6095_()).equals((Object)TATERZEN)) {
                return claim.canInteract(player, BuiltinPermission.TRADING, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof ItemFrame) {
                return claim.canInteract(player, BuiltinPermission.ITEMFRAMEROTATE, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof OwnableEntity && (tame = (OwnableEntity)entity).m_21805_() != null && tame.m_21805_().equals(player.m_20148_())) {
                return InteractionResult.PASS;
            }
            return claim.canInteract(player, BuiltinPermission.ANIMALINTERACT, pos, true) ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canInteract(Entity entity) {
        ResourceLocation id = CrossPlatformStuff.INSTANCE.registryEntities().getIDFrom(entity.m_6095_());
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.m_135827_())) return true;
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.toString())) return true;
        if (!entity.m_19880_().stream().anyMatch(ConfigHandler.CONFIG.entityTagIgnore::contains)) return false;
        return true;
    }

    public static boolean projectileHit(Projectile proj, HitResult res) {
        if (proj.m_9236_().f_46443_) {
            return false;
        }
        Entity owner = proj.m_19749_();
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            if (res.m_6662_() == HitResult.Type.BLOCK) {
                boolean flag;
                BlockHitResult blockRes = (BlockHitResult)res;
                BlockPos pos = blockRes.m_82425_();
                BlockState state = proj.m_9236_().m_8055_(pos);
                ResourceLocation perm = proj instanceof ThrownEnderpearl ? BuiltinPermission.ENDERPEARL : (proj instanceof ThrownEgg || proj instanceof ThrownPotion ? BuiltinPermission.PROJECTILES : ObjectToPermissionMap.getFromBlock(state.m_60734_()));
                if (perm != BuiltinPermission.ENDERPEARL && perm != BuiltinPermission.TARGETBLOCK && perm != BuiltinPermission.PROJECTILES) {
                    return false;
                }
                ClaimStorage storage = ClaimStorage.get((ServerLevel)proj.m_9236_());
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                boolean bl = flag = !claim.canInteract(player, perm, pos, true);
                if (flag) {
                    if (proj instanceof AbstractArrow) {
                        AbstractArrow pers = (AbstractArrow)proj;
                        ((IPersistentProjectileVars)pers).setInBlockState(pers.m_9236_().m_8055_(pos));
                        Vec3 vec3d = blockRes.m_82450_().m_82492_(pers.m_20185_(), pers.m_20186_(), pers.m_20189_());
                        pers.m_20256_(vec3d);
                        Vec3 vec3d2 = vec3d.m_82541_().m_82490_((double)0.05f);
                        pers.m_20343_(pers.m_20185_() - vec3d2.f_82479_, pers.m_20186_() - vec3d2.f_82480_, pers.m_20189_() - vec3d2.f_82481_);
                        pers.m_5496_(((IPersistentProjectileVars)pers).getSoundEvent(), 1.0f, 1.2f / (pers.m_9236_().f_46441_.m_188501_() * 0.2f + 0.9f));
                        ((IPersistentProjectileVars)pers).setInGround(true);
                        pers.f_36706_ = 7;
                        pers.m_36762_(false);
                        pers.m_36767_((byte)0);
                        pers.m_36740_(SoundEvents.f_11685_);
                        pers.m_36793_(false);
                        ((IPersistentProjectileVars)pers).resetPiercingStatus();
                    }
                    if (proj instanceof ThrownEnderpearl) {
                        proj.m_142687_(Entity.RemovalReason.KILLED);
                    }
                }
                return flag;
            }
            if (res.m_6662_() == HitResult.Type.ENTITY) {
                boolean fail;
                if (proj instanceof ThrownEnderpearl) {
                    ClaimStorage storage = ClaimStorage.get((ServerLevel)proj.m_9236_());
                    IPermissionContainer claim = storage.getForPermissionCheck(proj.m_20183_());
                    return claim.canInteract(player, BuiltinPermission.ENDERPEARL, proj.m_20183_(), true);
                }
                Entity hit = ((EntityHitResult)res).m_82443_();
                boolean bl = fail = EntityInteractEvents.attackSimple((Player)player, hit, true) != InteractionResult.PASS;
                if (fail && proj instanceof AbstractArrow) {
                    AbstractArrow pers = (AbstractArrow)proj;
                    if (((AbstractArrow)proj).m_36796_() > 0) {
                        IntOpenHashSet pierced = ((IPersistentProjectileVars)pers).getPiercedEntities();
                        if (pierced == null) {
                            pierced = new IntOpenHashSet(5);
                        }
                        pierced.add(hit.m_19879_());
                        ((IPersistentProjectileVars)pers).setPiercedEntities(pierced);
                        pers.m_36767_((byte)(pers.m_36796_() + 1));
                    }
                }
                return fail;
            }
        }
        return false;
    }

    public static boolean preventDamage(Entity entity, DamageSource source) {
        if (source.m_7639_() instanceof ServerPlayer) {
            return EntityInteractEvents.attackSimple((Player)((ServerPlayer)source.m_7639_()), entity, true) != InteractionResult.PASS;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_) && !entity.m_9236_().f_46443_ && !(entity instanceof ServerPlayer) && !(entity instanceof Enemy)) {
            IPermissionContainer claim = ClaimStorage.get((ServerLevel)entity.m_9236_()).getForPermissionCheck(entity.m_20183_());
            return claim != null && !claim.canInteract(null, BuiltinPermission.EXPLOSIONS, entity.m_20183_());
        }
        return false;
    }

    public static InteractionResult attackSimple(Player p, Entity entity, boolean message) {
        BlockPos pos;
        ServerPlayer player;
        block10: {
            block9: {
                if (!(p instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)p;
                if (!p.m_5833_() && !EntityInteractEvents.canInteract(entity)) break block10;
            }
            return InteractionResult.PASS;
        }
        if (entity instanceof Enemy) {
            return InteractionResult.PASS;
        }
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.m_20183_());
        if (claim != null) {
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canAttackEntity(entity)) {
                return InteractionResult.PASS;
            }
            if (entity instanceof ArmorStand || !(entity instanceof LivingEntity)) {
                return claim.canInteract(player, BuiltinPermission.BREAKNONLIVING, pos, message) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity instanceof Player) {
                return claim.canInteract(player, BuiltinPermission.HURTPLAYER, pos, message) ? InteractionResult.PASS : InteractionResult.FAIL;
            }
            if (entity.m_8077_() && !claim.canInteract(player, BuiltinPermission.HURTNAMED, pos, message)) {
                return InteractionResult.FAIL;
            }
            return claim.canInteract(player, BuiltinPermission.HURTANIMAL, pos, message) ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static boolean xpAbsorb(Player player) {
        BlockPos pos;
        ClaimStorage storage;
        IPermissionContainer claim;
        if (player instanceof ServerPlayer && (claim = (storage = ClaimStorage.get((ServerLevel)player.m_9236_())).getForPermissionCheck(pos = player.m_20183_())) != null) {
            return !claim.canInteract((ServerPlayer)player, BuiltinPermission.XP, pos, false);
        }
        return false;
    }

    public static boolean canCollideWith(Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            if (entity instanceof ItemEntity) {
                BlockPos pos;
                IOwnedItem ownedItem = (IOwnedItem)entity;
                if (ownedItem.getDeathPlayer() != null) {
                    ServerPlayer other = sPlayer.m_20194_().m_6846_().m_11259_(ownedItem.getDeathPlayer());
                    if (other == null) {
                        return false;
                    }
                    return ownedItem.getDeathPlayer().equals(player.m_20148_()) || PlayerClaimData.get(other).deathItemsUnlocked();
                }
                if (sPlayer.m_20148_().equals(ownedItem.getPlayerOrigin())) {
                    return true;
                }
                ClaimStorage storage = ClaimStorage.get(sPlayer.m_284548_());
                IPermissionContainer claim = storage.getForPermissionCheck(pos = sPlayer.m_20183_());
                if (claim != null) {
                    return claim.canInteract(sPlayer, BuiltinPermission.PICKUP, pos, false);
                }
            }
        }
        return true;
    }

    public static boolean canDropItem(Player player, ItemStack stack) {
        if (!player.m_21224_() && player instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)player.m_9236_());
            BlockPos pos = player.m_20183_();
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            boolean allow = true;
            if (claim != null) {
                allow = claim.canInteract((ServerPlayer)player, BuiltinPermission.DROP, pos, false);
            }
            if (!allow) {
                player.m_150109_().m_36054_(stack);
                NonNullList stacks = NonNullList.m_122779_();
                for (int j = 0; j < player.f_36096_.f_38839_.size(); ++j) {
                    ItemStack itemStack2 = ((Slot)player.f_36096_.f_38839_.get(j)).m_7993_();
                    stacks.add((Object)(itemStack2.m_41619_() ? ItemStack.f_41583_ : itemStack2));
                }
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetContentPacket(player.f_36096_.f_38840_, 0, stacks, player.f_36095_.m_142621_()));
            }
            return allow;
        }
        return true;
    }

    public static boolean witherCanDestroy(WitherBoss wither) {
        if (wither.m_9236_().f_46443_) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)wither.m_9236_());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                pos.m_122154_((Vec3i)wither.m_20183_(), x, 3, z);
                IPermissionContainer claim = storage.getForPermissionCheck((BlockPos)pos);
                if (claim.canInteract(null, BuiltinPermission.WITHER, (BlockPos)pos, false)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canEndermanInteract(EnderMan enderman, BlockPos pos) {
        if (enderman.m_9236_().f_46443_) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)enderman.m_9236_());
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        return claim.canInteract(null, BuiltinPermission.ENDERMAN, pos, false);
    }

    public static boolean canSnowGolemInteract(SnowGolem snowgolem) {
        if (snowgolem.m_9236_().f_46443_) {
            return true;
        }
        for (int l = 0; l < 4; ++l) {
            int x = Mth.m_14107_((double)(snowgolem.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            int y = Mth.m_14107_((double)snowgolem.m_20186_());
            int z = Mth.m_14107_((double)(snowgolem.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
            BlockPos pos = new BlockPos(x, y, z);
            IPermissionContainer claim = ClaimStorage.get((ServerLevel)snowgolem.m_9236_()).getForPermissionCheck(pos);
            if (claim.canInteract(null, BuiltinPermission.SNOWGOLEM, pos, false)) continue;
            return false;
        }
        return true;
    }

    public static void updateDroppedItem(Player player, ItemEntity entity) {
        ((IOwnedItem)entity).setOriginPlayer(player);
    }

    public static void updateClaim(ServerPlayer player, Claim currentClaim, Consumer<Claim> cons) {
        Vec3 pos = player.m_20182_();
        BlockPos rounded = TeleportUtils.roundedBlockPos(pos.m_82520_(0.0, (double)player.m_6431_(player.m_20089_(), player.m_6972_(player.m_20089_())), 0.0));
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        if (currentClaim != null) {
            if (!currentClaim.intersects(player.m_20191_())) {
                Claim claim2;
                boolean isSub = currentClaim.parentClaim() != null;
                Claim claim3 = claim2 = isSub ? storage.getClaimAt(rounded) : currentClaim.parentClaim();
                if (claim2 == null) {
                    currentClaim.displayLeaveTitle(player);
                } else {
                    Claim sub = claim2.getSubClaim(rounded);
                    boolean display = true;
                    if (sub != null) {
                        claim2 = sub;
                    } else {
                        boolean bl = display = currentClaim.enterTitle != null;
                        if (claim2.enterTitle == null) {
                            currentClaim.displayLeaveTitle(player);
                        }
                    }
                    if (display) {
                        claim2.displayEnterTitle(player);
                    }
                }
                cons.accept(claim2);
            } else {
                Claim sub;
                if (currentClaim.parentClaim() == null && (sub = currentClaim.getSubClaim(rounded)) != null) {
                    currentClaim = sub;
                    currentClaim.displayEnterTitle(player);
                    cons.accept(currentClaim);
                }
                if (!player.m_5833_()) {
                    BlockPos.MutableBlockPos bPos = rounded.m_122032_();
                    boolean isSub = currentClaim.parentClaim() != null;
                    Claim mainClaim = isSub ? currentClaim.parentClaim() : currentClaim;
                    Entity passenger = player.m_20202_();
                    if (!mainClaim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)bPos, true) || passenger instanceof Boat && !mainClaim.canInteract(player, BuiltinPermission.BOAT, (BlockPos)bPos, true)) {
                        Claim sub2 = isSub ? currentClaim : null;
                        Vec3 tp = TeleportUtils.getTeleportPos(player, pos, storage, sub2 != null ? sub2.getDimensions() : mainClaim.getDimensions(), true, bPos, (claim, nPos) -> claim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)nPos, false));
                        if (passenger != null) {
                            player.m_8127_();
                            passenger.m_20324_(tp.m_7096_(), tp.m_7098_(), tp.m_7094_());
                        }
                        player.m_20324_(tp.m_7096_(), tp.m_7098_(), tp.m_7094_());
                    }
                    if (player.m_150110_().f_35935_ && !player.m_7500_() && !mainClaim.canInteract(player, BuiltinPermission.FLIGHT, rounded, true)) {
                        player.m_150110_().f_35935_ = false;
                        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                    }
                    if (player.m_36324_().m_38722_() < 2.0f && mainClaim.canInteract(player, BuiltinPermission.NOHUNGER, (BlockPos)bPos, false)) {
                        ((IHungerAccessor)player.m_36324_()).setSaturation(2.0f);
                    }
                    currentClaim.applyEffects(player);
                }
            }
        } else if (player.f_19797_ % 3 == 0) {
            Claim sub;
            Claim claim4 = storage.getClaimAt(rounded);
            Claim claim5 = sub = claim4 != null ? claim4.getSubClaim(rounded) : null;
            if (sub != null) {
                claim4 = sub;
            }
            if (claim4 != null) {
                claim4.displayEnterTitle(player);
            }
            cons.accept(claim4);
        }
    }

    public static boolean canFrostwalkerFreeze(ServerLevel world, BlockPos pos, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            IPermissionContainer claim = ClaimStorage.get(world).getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)entity, BuiltinPermission.FROSTWALKER, pos, false);
        }
        return true;
    }

    public static boolean preventLightningConvert(Entity entity) {
        if (entity.m_9236_().f_46443_ || entity instanceof Enemy) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)entity.m_9236_());
        IPermissionContainer claim = storage.getForPermissionCheck(entity.m_20183_());
        return !claim.canInteract(null, BuiltinPermission.LIGHTNING, entity.m_20183_(), false);
    }
}

