/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class BuySellHandler {
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private final List<BuyIngredient> buyIngredients = new ArrayList<BuyIngredient>();
    private float sellAmount = -1.0f;
    private Ingredient sellIngredient = Ingredient.f_43901_;

    public boolean buy(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.buyAmount == -1.0f && this.buyType != Type.ITEM) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("buyDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.CONFIG.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.CONFIG.maxBuyBlocks) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("buyLimit"), ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.buyType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case 1: {
                if (this.buyIngredients.isEmpty()) {
                    message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("buyDisabled"), ChatFormatting.DARK_RED));
                    return false;
                }
                float payed = 0.0f;
                ArrayList<Pair> matching = new ArrayList<Pair>();
                block5: for (BuyIngredient ing : this.buyIngredients) {
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        if (!ing.ingredient().test(stack) || stack.m_41763_() && stack.m_41773_() != 0 || !this.isJustRenamedItem(stack)) continue;
                        float toPay = (float)blocks - payed;
                        int count = Math.min(stack.m_41613_(), Mth.m_14167_((float)(toPay / ing.amount())));
                        float amount = (float)count * ing.amount();
                        payed += amount;
                        matching.add(Pair.of((Object)stack, (Object)count));
                        if (!(payed >= (float)blocks)) continue;
                        break block5;
                    }
                }
                if (payed < (float)blocks) {
                    message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("buyFailItem"), ChatFormatting.DARK_RED));
                    return false;
                }
                int count = 0;
                for (Pair stack : matching) {
                    ((ItemStack)stack.getFirst()).m_41774_(((Integer)stack.getSecond()).intValue());
                    count += ((Integer)stack.getSecond()).intValue();
                }
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("buySuccessItem"), blocks, count), new ChatFormatting[0]));
                return true;
            }
            case 2: {
                int deduct = Mth.m_14167_((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.f_36078_) + player.f_36080_ * (float)BuySellHandler.xpForLevel(player.f_36078_ + 1)) {
                    player.m_6756_(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("buySuccessXP"), blocks, deduct), new ChatFormatting[0]));
                    return true;
                }
                message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("buyFailXP"), ChatFormatting.DARK_RED));
                return false;
            }
        }
        return false;
    }

    public boolean sell(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.sellAmount == -1.0f) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("sellDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("sellFail"), ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.sellType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case 1: {
                ItemStack[] stacks = this.sellIngredient.m_43908_();
                if (this.sellIngredient.m_43947_()) {
                    return false;
                }
                int amount = Mth.m_14143_((float)((float)blocks * this.sellAmount));
                ItemStack stack = stacks[0];
                while (amount > 0) {
                    ItemEntity itemEntity;
                    boolean bl;
                    ItemStack toGive = stack.m_41777_();
                    if (amount > 64) {
                        toGive.m_41764_(64);
                        amount -= 64;
                    } else {
                        toGive.m_41764_(amount);
                        amount = 0;
                    }
                    if ((bl = player.m_150109_().m_36054_(toGive)) && toGive.m_41619_() || (itemEntity = player.m_36176_(toGive, false)) == null) continue;
                    itemEntity.m_32061_();
                    itemEntity.m_266426_(player.m_20148_());
                }
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get("sellSuccessItem"), (Object[])new Object[]{blocks, amount, Component.m_237115_((String)stack.m_41778_()).m_130940_(ChatFormatting.AQUA)}));
                return true;
            }
            case 2: {
                int amount = Mth.m_14143_((float)((float)blocks * this.buyAmount));
                player.m_6756_(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("sellSuccessXP"), blocks, amount), new ChatFormatting[0]));
                return false;
            }
        }
        return false;
    }

    private boolean isJustRenamedItem(ItemStack stack) {
        if (!stack.m_41782_()) {
            return true;
        }
        if (stack.m_41783_().m_128431_().stream().allMatch(s -> s.equals("Damage") || s.equals("RepairCost") || s.equals("display"))) {
            CompoundTag tag = stack.m_41783_().m_128469_("display");
            return tag.m_128441_("Name") && tag.m_128440_() == 1;
        }
        return true;
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        JsonArray buyArr = new JsonArray();
        this.buyIngredients.forEach(b -> {
            JsonObject buyObj = new JsonObject();
            buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
            buyObj.add("ingredient", b.ingredient().m_43942_());
            buyArr.add((JsonElement)buyObj);
        });
        obj.add("buyIngredients", (JsonElement)buyArr);
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        obj.add("sellIngredient", this.sellIngredient.m_43942_());
        return obj;
    }

    public void fromJson(JsonObject object) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.buyIngredients.clear();
        JsonArray obj = ConfigHandler.arryFromJson(object, "buyIngredients");
        obj.forEach(k -> {
            JsonObject o = k.getAsJsonObject();
            try {
                Ingredient ingredient;
                Ingredient ingredient2 = ingredient = o.has("ingredient") ? Ingredient.m_43917_((JsonElement)o.get("ingredient")) : Ingredient.f_43901_;
                if (ingredient != Ingredient.f_43901_) {
                    float amount = o.get("amount").getAsFloat();
                    this.buyIngredients.add(new BuyIngredient(amount, ingredient));
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        });
        this.buyIngredients.sort(BuyIngredient::compareTo);
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        try {
            Ingredient legacy = object.has("ingredient") ? Ingredient.m_43917_((JsonElement)object.get("ingredient")) : Ingredient.f_43901_;
            this.sellIngredient = object.has("sellIngredient") ? Ingredient.m_43917_((JsonElement)object.get("sellIngredient")) : legacy;
        }
        catch (JsonParseException e) {
            this.sellIngredient = Ingredient.f_43901_;
        }
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }

    record BuyIngredient(float amount, Ingredient ingredient) implements Comparable<BuyIngredient>
    {
        @Override
        public int compareTo(@NotNull BuyIngredient buyIngredient) {
            return Float.compare(buyIngredient.amount, this.amount);
        }
    }
}

