/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CommandHelp {
    public static int helpMessage(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return CommandHelp.helpMessage(context, page, nodes);
    }

    public static int helpMessage(CommandContext<CommandSourceStack> context, int pageC, Collection<CommandNode<CommandSourceStack>> nodes) {
        List<String> subCommands = CommandHelp.registeredCommands(context, nodes);
        subCommands.remove("?");
        int max = subCommands.size() / 8;
        int page = Math.min(pageC, max);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("helpHeader"), page), ChatFormatting.GOLD), false);
        for (int i = 8 * page; i < 8 * (page + 1); ++i) {
            if (i >= subCommands.size()) continue;
            String sub = subCommands.get(i);
            MutableComponent cmdText = PermHelper.simpleColoredText("- " + sub, ChatFormatting.GRAY);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> cmdText.m_130948_(cmdText.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help cmd " + sub))), false);
        }
        MutableComponent txt = PermHelper.simpleColoredText((page > 0 ? "  " : "") + " ", ChatFormatting.DARK_GREEN);
        if (page > 0) {
            MutableComponent pageTextBack = PermHelper.simpleColoredText("<<", ChatFormatting.DARK_GREEN);
            pageTextBack.m_130948_(pageTextBack.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page - 1))));
            txt = pageTextBack.m_7220_((Component)txt);
        }
        if (page < max) {
            MutableComponent pageTextNext = PermHelper.simpleColoredText(">>", new ChatFormatting[0]);
            pageTextNext.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page + 1))));
            txt = txt.m_7220_((Component)pageTextNext);
        }
        MutableComponent pageText = txt;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> pageText, false);
        return 1;
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context) {
        String command = StringArgumentType.getString(context, (String)"command");
        return CommandHelp.helpCmd(context, command);
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context, String command) {
        String[] cmdHelp = ConfigHandler.LANG_MANAGER.getArray("command." + command);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("helpCmdHeader"), ChatFormatting.DARK_GREEN), false);
        for (int i = 0; i < cmdHelp.length; ++i) {
            String cmp;
            if (i == 0) {
                cmp = cmdHelp[i];
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("helpCmdSyntax"), cmp), ChatFormatting.GOLD), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText("", new ChatFormatting[0]), false);
                continue;
            }
            cmp = cmdHelp[i];
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(cmp, ChatFormatting.GOLD), false);
        }
        if (command.equals("help")) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("wiki"), ChatFormatting.GOLD), false);
            MutableComponent wiki = PermHelper.simpleColoredText("https://github.com/Flemmli97/Flan/wiki", ChatFormatting.GREEN);
            wiki.m_6270_(wiki.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Flemmli97/Flan/wiki")));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> wiki, false);
        }
        return 1;
    }

    public static List<String> registeredCommands(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        return nodes.stream().filter(node -> node.canUse((Object)((CommandSourceStack)context.getSource()))).map(CommandNode::getName).collect(Collectors.toList());
    }
}

