/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ClaimPermission
implements Comparable<ClaimPermission> {
    private final ItemStack guiItem;
    public final List<String> desc;
    private final ResourceLocation id;
    public final boolean defaultVal;
    public final boolean global;
    public final int order;

    private ClaimPermission(ResourceLocation id, ItemStack guiItem, boolean defaultVal, boolean global, int order, List<String> defaultDescription) {
        this.id = id;
        this.guiItem = guiItem;
        this.order = order;
        this.desc = defaultDescription;
        this.defaultVal = defaultVal;
        this.global = global;
    }

    public ItemStack getItem() {
        return this.guiItem.m_41777_();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String translationKey() {
        return String.format("%s", this.id);
    }

    public String translationKeyDescription() {
        return String.format("%s.desc", this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimPermission) {
            return this.id.equals((Object)((ClaimPermission)obj).id);
        }
        return false;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public int compareTo(@NotNull ClaimPermission other) {
        if (this.order == other.order) {
            return this.id.compareTo(other.id);
        }
        return Integer.compare(this.order, other.order);
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("order").forGetter(d -> d.order), (App)Codec.STRING.listOf().fieldOf("defaultDescription").forGetter(d -> d.desc), (App)Codec.STRING.optionalFieldOf("requiredMod").forGetter(d -> Optional.ofNullable(d.requiredMod)), (App)ItemStackHolder.CODEC.fieldOf("guiItem").forGetter(d -> d.guiItem), (App)Codec.BOOL.fieldOf("defaultVal").forGetter(d -> d.defaultVal), (App)Codec.BOOL.fieldOf("global").forGetter(d -> d.global)).apply((Applicative)instance, (order, desc, requiredMod, item, val, global) -> new Builder((ItemStackHolder)item, (boolean)val, (boolean)global, (int)order, requiredMod.orElse(null), (List<String>)desc)));
        private final ItemStackHolder guiItem;
        private final List<String> desc;
        private final boolean defaultVal;
        private final boolean global;
        private final String requiredMod;
        private final int order;

        public Builder(ItemStack guiItem, boolean defaultVal, boolean global, int order, List<String> desc) {
            this(new ItemStackHolder(guiItem), defaultVal, global, order, desc);
        }

        public Builder(ItemStackHolder guiItem, boolean defaultVal, boolean global, int order, List<String> desc) {
            this(guiItem, defaultVal, global, order, null, desc);
        }

        public Builder(ItemStackHolder guiItem, boolean defaultVal, boolean global, int order, String requiredMod, List<String> desc) {
            this.guiItem = guiItem;
            this.desc = desc;
            this.defaultVal = defaultVal;
            this.global = global;
            this.order = order;
            this.requiredMod = requiredMod;
        }

        public boolean verify() {
            return !this.guiItem.toStack().m_41619_() && (this.requiredMod == null || CrossPlatformStuff.INSTANCE.isModLoaded(this.requiredMod));
        }

        public ClaimPermission build(ResourceLocation id) {
            return new ClaimPermission(id, this.guiItem.toStack(), this.defaultVal, this.global, this.order, this.desc);
        }

        public record ItemStackHolder(ResourceLocation item, int count, CompoundTag tag) {
            public static final Codec<ItemStackHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(ItemStackHolder::item), (App)Codec.INT.optionalFieldOf("Count").forGetter(stack -> stack.count() == 1 ? Optional.empty() : Optional.of(stack.count())), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.tag()))).apply((Applicative)instance, (item, count, tag) -> new ItemStackHolder((ResourceLocation)item, count.orElse(1), tag.orElse(null))));

            public ItemStackHolder(ResourceLocation item) {
                this(item, 1, null);
            }

            public ItemStackHolder(ItemStack item) {
                this(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()), item.m_41613_(), item.m_41783_());
            }

            private ItemStack toStack() {
                ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(this.item), this.count);
                stack.m_41751_(this.tag);
                return stack;
            }
        }
    }
}

