/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import roe.weapons.config.RoeWeaponsClientConfig;
import roe.weapons.config.RoeWeaponsConfig;
import roe.weapons.entity.KunaiProjectileEntity;

public class BaseKunaiItem
extends Item {
    private final String weaponId;
    private final int durability;
    private final Rarity rarity;

    public BaseKunaiItem(String weaponId, int durability, Rarity rarity) {
        super(new Item.Properties().m_41503_(durability).m_41497_(rarity));
        this.weaponId = weaponId;
        this.durability = durability;
        this.rarity = rarity;
    }

    public int m_6473_() {
        return 1;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 3.2, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.0, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean m_8096_(BlockState blockState) {
        if (blockState.m_60713_(Blocks.f_50033_)) {
            return true;
        }
        return super.m_8096_(blockState);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        if (((Boolean)RoeWeaponsClientConfig.DISABLE_KUNAI_RIGHT_CLICK.get()).booleanValue()) {
            return InteractionResultHolder.m_19100_((Object)entity.m_21120_(hand));
        }
        ItemStack itemstack = entity.m_21120_(hand);
        if (!world.m_5776_()) {
            int cooldownTicks = (Integer)RoeWeaponsConfig.KUNAI_COOLDOWN.get();
            if (entity.m_36335_().m_41519_((Item)this)) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            entity.m_36335_().m_41524_((Item)this, cooldownTicks);
            KunaiProjectileEntity.shoot(world, (LivingEntity)entity, RandomSource.m_216327_(), 1.5f, 3.2, 0);
            if (!entity.m_150110_().f_35937_) {
                itemstack.m_41622_(1, (LivingEntity)entity, p -> p.m_21190_(hand));
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
    }
}

