/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.item;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import roe.weapons.RoeWeaponsMod;
import roe.weapons.config.RoeWeaponsConfig;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class BaseCrossbowItem
extends CrossbowItem {
    protected final String crossbowId;
    protected final int durability;
    protected final Rarity rarity;
    protected ItemStack lastQuiver = ItemStack.f_41583_;
    protected boolean startSoundPlayed = false;
    protected boolean midLoadSoundPlayed = false;
    protected static final boolean SUPPLEMENTARIES_LOADED = ModList.get().isLoaded("supplementaries");
    protected static final boolean CURIOS_LOADED = ModList.get().isLoaded("curios");
    protected boolean cachedChargedState = false;
    protected long lastChargedStateSync = 0L;
    protected static final long SYNC_INTERVAL = 10L;

    public BaseCrossbowItem(String crossbowId, int durability, Rarity rarity) {
        super(new Item.Properties().m_41487_(1).m_41503_(durability).m_41497_(rarity));
        this.crossbowId = crossbowId;
        this.durability = durability;
        this.rarity = rarity;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return BaseCrossbowItem.m_40932_((ItemStack)stack) ? UseAnim.CROSSBOW : UseAnim.BOW;
    }

    public int m_6615_() {
        return 16;
    }

    public int m_8105_(ItemStack stack) {
        return BaseCrossbowItem.m_40932_((ItemStack)stack) ? 72000 : 25;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        long currentTick;
        if (!world.f_46443_ && (currentTick = world.m_46467_()) - this.lastChargedStateSync >= 10L) {
            if (this.cachedChargedState) {
                CompoundTag compoundtag = stack.m_41784_();
                compoundtag.m_128379_("Charged", true);
            }
            this.lastChargedStateSync = currentTick;
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.equals(newStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (BaseCrossbowItem.m_40932_((ItemStack)stack)) {
            if (player instanceof ServerPlayer) {
                int lagCompensation = (Integer)RoeWeaponsConfig.CROSSBOW_LAG_COMPENSATION.get();
                if (world.f_46443_) {
                    this.playCrossbowShootSound(player);
                }
            }
            this.performShoot(world, player, hand, stack, 1.0f, 1.0f);
            BaseCrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
            this.cachedChargedState = false;
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (player.m_150110_().f_35937_ || !this.findAmmo(player).m_41619_()) {
            if (!BaseCrossbowItem.m_40932_((ItemStack)stack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    protected void playCrossbowShootSound(Player player) {
        player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }

    public void m_5929_(Level world, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!world.f_46443_) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent soundevent = this.m_40851_(quickChargeLevel);
            SoundEvent soundevent1 = quickChargeLevel == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(stack.m_41779_() - remainingUseDuration) / (float)BaseCrossbowItem.m_40939_(stack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        float f = BaseCrossbowItem.getChargingProgress(this.m_8105_(stack) - timeLeft, stack);
        if (f >= 1.0f && !BaseCrossbowItem.m_40932_((ItemStack)stack) && (!(entity instanceof Player) || this.hasAmmo((Player)entity))) {
            BaseCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            this.cachedChargedState = true;
            SoundSource soundsource = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    protected SoundEvent m_40851_(int quickChargeLevel) {
        switch (quickChargeLevel) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    protected static float getChargingProgress(int useTicks, ItemStack stack) {
        float f = (float)useTicks / (float)BaseCrossbowItem.m_40939_(stack);
        return Math.min(f, 1.0f);
    }

    public static int m_40939_(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return quickChargeLevel == 0 ? 25 : 25 - 5 * quickChargeLevel;
    }

    protected boolean hasAmmo(Player player) {
        return player.m_150110_().f_35937_ || !this.findAmmo(player).m_41619_();
    }

    protected ItemStack findAmmo(Player player) {
        Object stack3;
        int i;
        for (i = 0; i < 9; ++i) {
            stack3 = player.m_150109_().m_8020_(i);
            if (stack3.m_41720_() != Items.f_42412_ && stack3.m_41720_() != Items.f_42738_ && stack3.m_41720_() != Items.f_42737_) continue;
            this.lastQuiver = ItemStack.f_41583_;
            return stack3;
        }
        if (SUPPLEMENTARIES_LOADED) {
            try {
                Class<?> quiverClass = Class.forName("net.mehvahdjukaar.supplementaries.common.items.QuiverItem");
                for (ItemStack stack2 : player.m_150109_().f_35974_) {
                    ItemStack selected;
                    Object data;
                    if (!quiverClass.isInstance(stack2.m_41720_()) || (data = quiverClass.getMethod("getQuiverData", ItemStack.class).invoke(null, stack2)) == null || (selected = (ItemStack)data.getClass().getMethod("getSelected", new Class[0]).invoke(data, new Object[0])).m_41619_() || !this.isValidAmmo(selected)) continue;
                    this.lastQuiver = stack2;
                    return selected;
                }
            }
            catch (Exception e) {
                this.lastQuiver = ItemStack.f_41583_;
            }
        }
        if (CURIOS_LOADED) {
            ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                for (Map.Entry entry : handler.getCurios().entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        if (stack.m_41720_().getClass().getSimpleName().toLowerCase().contains("quiver")) {
                            try {
                                ItemStack selected;
                                Object data;
                                Class<?> quiverClass = Class.forName("net.mehvahdjukaar.supplementaries.common.items.QuiverItem");
                                if (quiverClass.isInstance(stack.m_41720_()) && (data = quiverClass.getMethod("getQuiverData", ItemStack.class).invoke(null, stack)) != null && !(selected = (ItemStack)data.getClass().getMethod("getSelected", new Class[0]).invoke(data, new Object[0])).m_41619_() && this.isValidAmmo(selected)) {
                                    this.lastQuiver = stack;
                                    result[0] = selected;
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!this.isValidAmmo(stack)) continue;
                        this.lastQuiver = ItemStack.f_41583_;
                        result[0] = stack;
                        return;
                    }
                }
            });
            if (!result[0].m_41619_()) {
                return result[0];
            }
        }
        for (i = 9; i < player.m_150109_().f_35974_.size(); ++i) {
            stack3 = player.m_150109_().m_8020_(i);
            if (stack3.m_41720_() != Items.f_42412_ && stack3.m_41720_() != Items.f_42738_ && stack3.m_41720_() != Items.f_42737_) continue;
            this.lastQuiver = ItemStack.f_41583_;
            return stack3;
        }
        for (Object stack3 : player.m_150109_().f_35974_) {
            if (!this.isValidAmmo((ItemStack)stack3) || !(stack3.m_41720_() instanceof ArrowItem)) continue;
            this.lastQuiver = ItemStack.f_41583_;
            return stack3;
        }
        this.lastQuiver = ItemStack.f_41583_;
        return ItemStack.f_41583_;
    }

    protected boolean isValidAmmo(ItemStack stack) {
        return stack.m_41720_() instanceof ArrowItem;
    }

    protected void performShoot(Level world, Player player, InteractionHand hand, ItemStack stack, float velocity, float inaccuracy) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RoeWeaponsConfig.WeaponSettings settings = RoeWeaponsConfig.WEAPON_SETTINGS.get(this.crossbowId);
            if (settings == null) {
                RoeWeaponsMod.LOGGER.error("No settings found for crossbow ID: " + this.crossbowId);
                return;
            }
            int lagCompensation = (Integer)RoeWeaponsConfig.CROSSBOW_LAG_COMPENSATION.get();
            this.processShot(world, serverPlayer, hand, stack, velocity, inaccuracy, settings);
        }
    }

    protected void processShot(Level world, ServerPlayer player, InteractionHand hand, ItemStack stack, float velocity, float inaccuracy, RoeWeaponsConfig.WeaponSettings settings) {
        ResourceLocation helmetId;
        boolean fromQuiver;
        int multishotLevel = (Boolean)RoeWeaponsConfig.ALLOW_CROSSBOW_MULTISHOT.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) : 0;
        int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        int powerLevel = (Boolean)RoeWeaponsConfig.ALLOW_CROSSBOW_POWER.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) : 0;
        int arrowCount = this.calculateArrowCount((Player)player, multishotLevel, settings);
        ItemStack ammoStack = this.getAmmoStack((Player)player);
        boolean bl = fromQuiver = !this.lastQuiver.m_41619_() && SUPPLEMENTARIES_LOADED;
        if (ammoStack.m_41619_()) {
            return;
        }
        int helmetBonusArrows = 0;
        ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmetStack.m_41619_() && (helmetId = ForgeRegistries.ITEMS.getKey((Object)helmetStack.m_41720_())) != null && helmetId.toString().equals("mutantmonsters:mutant_skeleton_skull")) {
            helmetBonusArrows = 2;
        }
        float velocityMultiplier = ((Double)settings.velocityMultiplier.get()).floatValue();
        float spreadAngle = ((Double)settings.spreadAngle.get()).floatValue();
        this.fireProjectileBatch(world, (Player)player, hand, stack, ammoStack, arrowCount, velocity, inaccuracy, pierceLevel, powerLevel, helmetBonusArrows, multishotLevel, velocityMultiplier, spreadAngle);
        this.consumeAmmo((Player)player, ammoStack, multishotLevel, settings, fromQuiver);
        this.postShoot(world, (Player)player);
    }

    protected int calculateArrowCount(Player player, int multishotLevel, RoeWeaponsConfig.WeaponSettings settings) {
        ResourceLocation helmetId;
        int arrowCount = multishotLevel > 0 ? (Integer)settings.multishotArrowCount.get() : (Integer)settings.baseArrowCount.get();
        ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmetStack.m_41619_() && (helmetId = ForgeRegistries.ITEMS.getKey((Object)helmetStack.m_41720_())) != null && helmetId.toString().equals("mutantmonsters:mutant_skeleton_skull")) {
            arrowCount += 2;
        }
        return arrowCount;
    }

    protected ItemStack getAmmoStack(Player player) {
        return player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : this.findAmmo(player);
    }

    protected void fireProjectileBatch(Level world, Player player, InteractionHand hand, ItemStack crossbow, ItemStack ammo, int arrowCount, float velocity, float inaccuracy, int pierceLevel, int powerLevel, int helmetBonusArrows, int multishotLevel, float velocityMultiplier, float spreadAngle) {
        if (!world.f_46443_) {
            for (int i = 0; i < arrowCount; ++i) {
                float angle = ((float)i - (float)(arrowCount - 1) / 2.0f) * spreadAngle;
                AbstractArrow arrow = this.createArrow(world, (LivingEntity)player, crossbow, ammo);
                if (player.m_150110_().f_35937_) {
                    arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (multishotLevel > 0 && i > 0) {
                    arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                } else if (helmetBonusArrows > 0 && i >= arrowCount - helmetBonusArrows) {
                    arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                } else {
                    this.setupArrow(arrow, player, powerLevel, pierceLevel);
                }
                crossbow.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.launchArrow(arrow, player, velocity, inaccuracy, angle, velocityMultiplier);
                world.m_7967_((Entity)arrow);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void setupArrow(AbstractArrow arrow, Player player, int powerLevel, int pierceLevel) {
        if (player.m_150110_().f_35937_ || powerLevel > 0) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if (pierceLevel > 0) {
            arrow.m_36767_((byte)pierceLevel);
        }
        arrow.m_36762_(true);
        arrow.m_36740_(SoundEvents.f_11840_);
        arrow.m_36793_(true);
    }

    protected void launchArrow(AbstractArrow arrow, Player player, float velocity, float inaccuracy, float spreadAngle, float velocityMultiplier) {
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + spreadAngle, 0.0f, velocity * velocityMultiplier, inaccuracy);
    }

    /*
     * Unable to fully structure code
     */
    protected void consumeAmmo(Player player, ItemStack ammoStack, int multishotLevel, RoeWeaponsConfig.WeaponSettings settings, boolean fromQuiver) {
        if (!player.m_150110_().f_35937_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)player.m_21205_()) == 0) {
            consumption = multishotLevel > 0 ? (Integer)settings.multishotArrowConsumption.get() : (Integer)settings.baseArrowConsumption.get();
            if (fromQuiver && BaseCrossbowItem.SUPPLEMENTARIES_LOADED) {
                try {
                    data = Class.forName("net.mehvahdjukaar.supplementaries.common.items.QuiverItem").getMethod("getQuiverData", new Class[]{ItemStack.class}).invoke(null, new Object[]{this.lastQuiver});
                    if (data == null) ** GOTO lbl20
                    for (i = 0; i < consumption; ++i) {
                        data.getClass().getMethod("consumeSelected", new Class[0]).invoke(data, new Object[0]);
                    }
                }
                catch (Exception e) {
                    ammoStack.m_41774_(consumption);
                    if (!ammoStack.m_41619_()) ** GOTO lbl20
                    player.m_150109_().m_36057_(ammoStack);
                }
            } else {
                ammoStack.m_41774_(consumption);
                if (ammoStack.m_41619_()) {
                    player.m_150109_().m_36057_(ammoStack);
                }
            }
lbl20:
            // 7 sources

            this.lastQuiver = ItemStack.f_41583_;
        }
    }

    protected AbstractArrow createArrow(Level world, LivingEntity shooter, ItemStack crossbow, ItemStack ammo) {
        ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
        return arrowitem.m_6394_(world, ammo, shooter);
    }

    protected void postShoot(Level world, Player player) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44988_ && (Boolean)RoeWeaponsConfig.ALLOW_CROSSBOW_POWER.get() != false || enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44959_ && (Boolean)RoeWeaponsConfig.ALLOW_CROSSBOW_MULTISHOT.get() != false || enchantment == Enchantments.f_44960_ && (Boolean)RoeWeaponsConfig.ALLOW_CROSSBOW_QUICK_CHARGE.get() != false || enchantment == Enchantments.f_44952_ || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }
}

