/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.item;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import roe.weapons.RoeWeaponsMod;
import roe.weapons.config.RoeWeaponsConfig;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class BaseBowItem
extends BowItem {
    protected final String bowId;
    protected final int durability;
    protected final Rarity rarity;
    protected ItemStack lastQuiver = ItemStack.f_41583_;
    protected static final boolean SUPPLEMENTARIES_LOADED = ModList.get().isLoaded("supplementaries");
    protected static final boolean CURIOS_LOADED = ModList.get().isLoaded("curios");

    public BaseBowItem(String bowId, int durability, Rarity rarity) {
        super(new Item.Properties().m_41487_(1).m_41503_(durability).m_41497_(rarity));
        this.bowId = bowId;
        this.durability = durability;
        this.rarity = rarity;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_6615_() {
        return 14;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_150110_().f_35937_ || !this.findAmmo(player).m_41619_()) {
            SoundEvent pullSound;
            player.m_6672_(hand);
            if (!world.f_46443_ && (pullSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("roe_weapons:bow_pulling"))) != null) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), pullSound, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity target, LivingEntity attacker) {
        itemstack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public void m_5551_(ItemStack itemstack, Level world, LivingEntity shooter, int timeLeft) {
        if (!world.f_46443_ && shooter instanceof ServerPlayer) {
            block33: {
                ResourceLocation helmetId;
                int multishotLevel;
                boolean infinite;
                float pullingPower;
                boolean fromQuiver;
                ServerPlayer player = (ServerPlayer)shooter;
                RoeWeaponsConfig.WeaponSettings settings = RoeWeaponsConfig.WEAPON_SETTINGS.get(this.bowId);
                if (settings == null) {
                    RoeWeaponsMod.LOGGER.error("No settings found for bow ID: " + this.bowId);
                    return;
                }
                int useDuration = this.m_8105_(itemstack);
                int charge = useDuration - timeLeft;
                boolean bl = fromQuiver = !this.lastQuiver.m_41619_() && SUPPLEMENTARIES_LOADED;
                if (((Boolean)RoeWeaponsConfig.ALLOW_BOW_QUICK_CHARGE.get()).booleanValue()) {
                    int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemstack);
                    float quickChargeMultiplier = 1.0f / (1.0f + (float)quickChargeLevel * 0.5f);
                    charge = (int)((float)charge / quickChargeMultiplier);
                }
                if ((pullingPower = BaseBowItem.m_40661_((int)charge)) < 0.1f) {
                    this.lastQuiver = ItemStack.f_41583_;
                    return;
                }
                ItemStack ammoStack = this.findAmmo((Player)player);
                int infinityLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack);
                boolean infinityAllowed = true;
                if (!((Boolean)RoeWeaponsConfig.ALLOW_BOW_INFINITY.get()).booleanValue()) {
                    infinityAllowed = false;
                } else if (ammoStack.m_41720_() == Items.f_42738_ && !((Boolean)RoeWeaponsConfig.ALLOW_TIPPED_INFINITY.get()).booleanValue()) {
                    infinityAllowed = false;
                } else if (ammoStack.m_41720_() == Items.f_42737_ && !((Boolean)RoeWeaponsConfig.ALLOW_SPECTRAL_INFINITY.get()).booleanValue()) {
                    infinityAllowed = false;
                } else if (ammoStack.m_41720_() instanceof ArrowItem && ammoStack.m_41720_() != Items.f_42412_ && ammoStack.m_41720_() != Items.f_42738_ && ammoStack.m_41720_() != Items.f_42737_ && !((Boolean)RoeWeaponsConfig.ALLOW_MODDED_INFINITY.get()).booleanValue()) {
                    infinityAllowed = false;
                }
                boolean bl2 = infinite = infinityLevel > 0 && infinityAllowed || player.m_150110_().f_35937_;
                if (ammoStack.m_41619_() && !infinite) {
                    this.lastQuiver = ItemStack.f_41583_;
                    return;
                }
                if (ammoStack.m_41619_() && player.m_150110_().f_35937_) {
                    ammoStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                itemstack.m_41622_(1, shooter, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("roe_weapons:bow_fire"));
                if (shootSound != null) {
                    world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), shootSound, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                int arrowCount = (multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack)) > 0 && (Boolean)RoeWeaponsConfig.ALLOW_BOW_MULTISHOT.get() != false ? (Integer)settings.multishotArrowCount.get() : (Integer)settings.baseArrowCount.get();
                int helmetBonusArrows = 0;
                ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
                if (!helmetStack.m_41619_() && (helmetId = ForgeRegistries.ITEMS.getKey((Object)helmetStack.m_41720_())) != null && helmetId.toString().equals("mutantmonsters:mutant_skeleton_skull")) {
                    helmetBonusArrows = 2;
                    arrowCount += helmetBonusArrows;
                }
                float spreadAngle = ((Double)settings.spreadAngle.get()).floatValue();
                int powerLevel = (Boolean)RoeWeaponsConfig.ALLOW_BOW_POWER.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemstack) : 0;
                int punchLevel = (Boolean)RoeWeaponsConfig.ALLOW_BOW_PUNCH.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemstack) : 0;
                int flameLevel = (Boolean)RoeWeaponsConfig.ALLOW_BOW_FLAME.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemstack) : 0;
                int piercingLevel = (Boolean)RoeWeaponsConfig.ALLOW_BOW_PIERCING.get() != false ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemstack) : 0;
                float velocityMultiplier = ((Double)settings.velocityMultiplier.get()).floatValue();
                for (int i = 0; i < arrowCount; ++i) {
                    AbstractArrow arrow = this.createArrow(world, shooter, ammoStack);
                    float basePitch = shooter.m_146909_();
                    float baseYaw = shooter.m_146908_();
                    float yawOffset = 0.0f;
                    if (arrowCount > 1) {
                        yawOffset = ((float)i - (float)(arrowCount - 1) / 2.0f) * spreadAngle;
                    }
                    arrow.m_37251_((Entity)shooter, basePitch, baseYaw + yawOffset, 0.0f, pullingPower * velocityMultiplier, 1.0f);
                    if (powerLevel > 0) {
                        arrow.m_36781_(arrow.m_36789_() + ((double)powerLevel * 0.5 + 0.5));
                    }
                    if (punchLevel > 0) {
                        arrow.m_36735_(punchLevel);
                    }
                    if (flameLevel > 0) {
                        arrow.m_20254_(100);
                    }
                    if (piercingLevel > 0) {
                        arrow.m_36767_((byte)piercingLevel);
                    }
                    if (infinite) {
                        arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else if (multishotLevel > 0 && i > 0) {
                        arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    } else if (helmetBonusArrows > 0 && i >= arrowCount - helmetBonusArrows) {
                        arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                    }
                    world.m_7967_((Entity)arrow);
                }
                if (!infinite && !player.m_150110_().f_35937_) {
                    int arrowConsumption;
                    if (fromQuiver && SUPPLEMENTARIES_LOADED) {
                        try {
                            arrowConsumption = multishotLevel > 0 ? (Integer)settings.multishotArrowConsumption.get() : (Integer)settings.baseArrowConsumption.get();
                            ammoStack.m_41774_(arrowConsumption);
                            if (ammoStack.m_41619_()) {
                                player.m_150109_().m_36057_(ammoStack);
                            }
                            break block33;
                        }
                        catch (Exception e2) {
                            int arrowConsumption2 = multishotLevel > 0 ? (Integer)settings.multishotArrowConsumption.get() : (Integer)settings.baseArrowConsumption.get();
                            ammoStack.m_41774_(arrowConsumption2);
                            if (ammoStack.m_41619_()) {
                                player.m_150109_().m_36057_(ammoStack);
                            }
                            break block33;
                        }
                    }
                    arrowConsumption = multishotLevel > 0 ? (Integer)settings.multishotArrowConsumption.get() : (Integer)settings.baseArrowConsumption.get();
                    ammoStack.m_41774_(arrowConsumption);
                    if (ammoStack.m_41619_()) {
                        player.m_150109_().m_36057_(ammoStack);
                    }
                }
            }
            this.lastQuiver = ItemStack.f_41583_;
        }
    }

    protected AbstractArrow createArrow(Level world, LivingEntity shooter, ItemStack ammoStack) {
        Item item = ammoStack.m_41720_();
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            return arrowItem.m_6394_(world, ammoStack, shooter);
        }
        return new Arrow(world, shooter);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44988_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_POWER.get() != false || enchantment == Enchantments.f_44989_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_PUNCH.get() != false || enchantment == Enchantments.f_44990_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_FLAME.get() != false || enchantment == Enchantments.f_44952_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_INFINITY.get() != false || enchantment == Enchantments.f_44959_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_MULTISHOT.get() != false || enchantment == Enchantments.f_44960_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_QUICK_CHARGE.get() != false || enchantment == Enchantments.f_44961_ && (Boolean)RoeWeaponsConfig.ALLOW_BOW_PIERCING.get() != false || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }

    protected ItemStack findAmmo(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof ArrowItem)) continue;
            this.lastQuiver = ItemStack.f_41583_;
            return stack;
        }
        if (SUPPLEMENTARIES_LOADED) {
            try {
                Class<?> quiverClass = Class.forName("net.mehvahdjukaar.supplementaries.common.items.QuiverItem");
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    ItemStack selected;
                    Object data;
                    if (!quiverClass.isInstance(stack.m_41720_()) || (data = quiverClass.getMethod("getQuiverData", ItemStack.class).invoke(null, stack)) == null || (selected = (ItemStack)data.getClass().getMethod("getSelected", new Class[0]).invoke(data, new Object[0])).m_41619_()) continue;
                    this.lastQuiver = stack;
                    return selected;
                }
            }
            catch (Exception e) {
                this.lastQuiver = ItemStack.f_41583_;
            }
        }
        if (CURIOS_LOADED) {
            ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                for (Map.Entry entry : handler.getCurios().entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        if (stack.m_41720_().getClass().getSimpleName().toLowerCase().contains("quiver")) {
                            try {
                                ItemStack selected;
                                Object data;
                                Class<?> quiverClass = Class.forName("net.mehvahdjukaar.supplementaries.common.items.QuiverItem");
                                if (quiverClass.isInstance(stack.m_41720_()) && (data = quiverClass.getMethod("getQuiverData", ItemStack.class).invoke(null, stack)) != null && !(selected = (ItemStack)data.getClass().getMethod("getSelected", new Class[0]).invoke(data, new Object[0])).m_41619_()) {
                                    this.lastQuiver = stack;
                                    result[0] = selected;
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!(stack.m_41720_() instanceof ArrowItem)) continue;
                        this.lastQuiver = ItemStack.f_41583_;
                        result[0] = stack;
                        return;
                    }
                }
            });
            if (!result[0].m_41619_()) {
                return result[0];
            }
        }
        this.lastQuiver = ItemStack.f_41583_;
        return ItemStack.f_41583_;
    }
}

