/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import roe.weapons.config.EnchantmentConfig;
import roe.weapons.init.RoeWeaponsModEnchantments;

@Mod.EventBusSubscriber(modid="roe_weapons")
public class LightningStrikeHandler {
    private static final Map<UUID, Long> lastLightningStrike = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            long lastStrike;
            double chance;
            Player player = (Player)entity;
            ItemStack weapon = player.m_21205_();
            if (weapon.m_41619_()) {
                return;
            }
            int lightningLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)RoeWeaponsModEnchantments.LIGHTNING_STRIKE.get()), (ItemStack)weapon);
            if (lightningLevel <= 0) {
                return;
            }
            if (!((Boolean)EnchantmentConfig.LIGHTNING_STRIKE_ENABLED.get()).booleanValue()) {
                return;
            }
            switch (lightningLevel) {
                case 1: {
                    double d = (Double)EnchantmentConfig.LIGHTNING_STRIKE_CHANCE_LEVEL_1.get();
                    break;
                }
                case 2: {
                    double d = (Double)EnchantmentConfig.LIGHTNING_STRIKE_CHANCE_LEVEL_2.get();
                    break;
                }
                case 3: {
                    double d = (Double)EnchantmentConfig.LIGHTNING_STRIKE_CHANCE_LEVEL_3.get();
                    break;
                }
                default: {
                    double d = chance = 0.0;
                }
            }
            if (Math.random() > chance) {
                return;
            }
            UUID playerId = player.m_20148_();
            long currentTime = System.currentTimeMillis();
            long cooldownMs = 1000L;
            if (lastLightningStrike.containsKey(playerId) && currentTime - (lastStrike = lastLightningStrike.get(playerId).longValue()) < cooldownMs) {
                return;
            }
            LivingEntity target = event.getEntity();
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos strikePos = target.m_20183_();
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
                if (lightning != null) {
                    lightning.m_6027_((double)strikePos.m_123341_() + 0.5, (double)strikePos.m_123342_(), (double)strikePos.m_123343_() + 0.5);
                    lightning.m_20874_(true);
                    serverLevel.m_7967_((Entity)lightning);
                    int baseDuration = (Integer)EnchantmentConfig.LIGHTNING_STRIKE_FIRE_DURATION_BASE.get();
                    int perLevel = (Integer)EnchantmentConfig.LIGHTNING_STRIKE_FIRE_DURATION_PER_LEVEL.get();
                    int fireDuration = baseDuration + lightningLevel * perLevel;
                    target.m_20254_(fireDuration);
                    if (((Boolean)EnchantmentConfig.LIGHTNING_STRIKE_AOE_ENABLED.get()).booleanValue()) {
                        LightningStrikeHandler.applyAOEDamage(target, player, lightningLevel);
                    }
                    weapon.m_41622_(((Integer)EnchantmentConfig.LIGHTNING_STRIKE_DURABILITY_DAMAGE.get()).intValue(), (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    lastLightningStrike.put(playerId, currentTime);
                }
            }
        }
    }

    private static void applyAOEDamage(LivingEntity target, Player player, int enchantmentLevel) {
        double radius = (Double)EnchantmentConfig.LIGHTNING_STRIKE_AOE_RADIUS.get();
        double baseDamage = (Double)EnchantmentConfig.LIGHTNING_STRIKE_AOE_DAMAGE.get();
        float damage = (float)(baseDamage * (1.0 + (double)(enchantmentLevel - 1) * 0.5));
        AABB area = new AABB(target.m_20185_() - radius, target.m_20186_() - radius, target.m_20189_() - radius, target.m_20185_() + radius, target.m_20186_() + radius, target.m_20189_() + radius);
        List entities = target.m_9236_().m_45976_(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            double distance;
            double damageMultiplier;
            if (entity == target || entity == player || !((damageMultiplier = Math.max(0.2, 1.0 - (distance = (double)entity.m_20270_((Entity)target)) / radius)) > 0.0)) continue;
            float finalDamage = damage * (float)damageMultiplier;
            entity.m_6469_(player.m_269291_().m_269548_(), finalDamage);
            int aoeFireDuration = (Integer)EnchantmentConfig.LIGHTNING_STRIKE_AOE_FIRE_DURATION.get();
            entity.m_20254_(aoeFireDuration);
        }
    }
}

