/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import roe.weapons.config.RoeWeaponsConfig;
import roe.weapons.init.RoeWeaponsModEntities;
import roe.weapons.init.RoeWeaponsModItems;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class KunaiProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)RoeWeaponsModItems.KUNAI_0.get());
    private double prevMotionX;
    private double prevMotionY;
    private double prevMotionZ;
    private float spinRotation = 0.0f;

    public KunaiProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)RoeWeaponsModEntities.KUNAI_PROJECTILE.get(), world);
    }

    public KunaiProjectileEntity(EntityType<? extends KunaiProjectileEntity> type, Level world) {
        super(type, world);
    }

    public KunaiProjectileEntity(EntityType<? extends KunaiProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public KunaiProjectileEntity(EntityType<? extends KunaiProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        this.prevMotionX = this.m_20184_().f_82479_;
        this.prevMotionY = this.m_20184_().f_82480_;
        this.prevMotionZ = this.m_20184_().f_82481_;
        super.m_8119_();
        if (this.f_36703_) {
            this.m_146870_();
        } else {
            this.updateCustomRotation();
        }
    }

    protected void updateCustomRotation() {
        Vec3 motion = this.m_20184_();
        double horizontalDistance = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
        this.m_146922_((float)(Math.atan2(motion.f_82479_, motion.f_82481_) * 180.0 / Math.PI));
        this.m_146926_((float)(Math.atan2(motion.f_82480_, horizontalDistance) * 180.0 / Math.PI));
        float spinSpeed = 20.0f;
        this.spinRotation += spinSpeed;
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public float getSpinRotation() {
        return this.spinRotation;
    }

    public static KunaiProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return KunaiProjectileEntity.shoot(world, entity, source, 1.0f, 3.0, 0);
    }

    public static KunaiProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return KunaiProjectileEntity.shoot(world, entity, source, pullingPower * 1.0f, 3.0, 0);
    }

    public static KunaiProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        int projectileCount = (Integer)RoeWeaponsConfig.KUNAI_PROJECTILE_COUNT.get();
        float spreadAngle = ((Double)RoeWeaponsConfig.KUNAI_SPREAD_ANGLE.get()).floatValue();
        KunaiProjectileEntity mainKunai = null;
        for (int i = 0; i < projectileCount; ++i) {
            KunaiProjectileEntity entityarrow = new KunaiProjectileEntity((EntityType<? extends KunaiProjectileEntity>)((EntityType)RoeWeaponsModEntities.KUNAI_PROJECTILE.get()), entity, world);
            float angleOffset = 0.0f;
            if (projectileCount > 1) {
                angleOffset = ((float)i - (float)(projectileCount - 1) / 2.0f) * spreadAngle;
            }
            Vec3 viewVector = entity.m_20252_(1.0f);
            double cosAngle = Math.cos(Math.toRadians(angleOffset));
            double sinAngle = Math.sin(Math.toRadians(angleOffset));
            double newX = viewVector.f_82479_ * cosAngle - viewVector.f_82481_ * sinAngle;
            double newZ = viewVector.f_82479_ * sinAngle + viewVector.f_82481_ * cosAngle;
            entityarrow.m_6686_(newX, viewVector.f_82480_, newZ, power * 2.0f, 0.0f);
            entityarrow.m_20225_(true);
            entityarrow.m_36762_(false);
            entityarrow.m_36781_(damage);
            entityarrow.m_36735_(knockback);
            world.m_7967_((Entity)entityarrow);
            if (i != projectileCount / 2) continue;
            mainKunai = entityarrow;
        }
        if (mainKunai == null) {
            mainKunai = new KunaiProjectileEntity((EntityType<? extends KunaiProjectileEntity>)((EntityType)RoeWeaponsModEntities.KUNAI_PROJECTILE.get()), entity, world);
            mainKunai.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
            mainKunai.m_20225_(true);
            mainKunai.m_36762_(false);
            mainKunai.m_36781_(damage);
            mainKunai.m_36735_(knockback);
            world.m_7967_((Entity)mainKunai);
        }
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return mainKunai;
    }

    public static KunaiProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        int projectileCount = (Integer)RoeWeaponsConfig.KUNAI_PROJECTILE_COUNT.get();
        float spreadAngle = ((Double)RoeWeaponsConfig.KUNAI_SPREAD_ANGLE.get()).floatValue();
        KunaiProjectileEntity mainKunai = null;
        for (int i = 0; i < projectileCount; ++i) {
            KunaiProjectileEntity entityarrow = new KunaiProjectileEntity((EntityType<? extends KunaiProjectileEntity>)((EntityType)RoeWeaponsModEntities.KUNAI_PROJECTILE.get()), entity, entity.m_9236_());
            double dx = target.m_20185_() - entity.m_20185_();
            double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
            double dz = target.m_20189_() - entity.m_20189_();
            float angleOffset = 0.0f;
            if (projectileCount > 1) {
                angleOffset = ((float)i - (float)(projectileCount - 1) / 2.0f) * spreadAngle;
            }
            double distance = Math.sqrt(dx * dx + dz * dz);
            double originalAngle = Math.atan2(dz, dx);
            double newAngle = originalAngle + Math.toRadians(angleOffset);
            double newDx = Math.cos(newAngle) * distance;
            double newDz = Math.sin(newAngle) * distance;
            entityarrow.m_6686_(newDx, dy - entityarrow.m_20186_() + Math.hypot(newDx, newDz) * (double)0.2f, newDz, 2.0f, 12.0f);
            entityarrow.m_20225_(true);
            entityarrow.m_36781_(3.0);
            entityarrow.m_36735_(0);
            entityarrow.m_36762_(false);
            entity.m_9236_().m_7967_((Entity)entityarrow);
            if (i != projectileCount / 2) continue;
            mainKunai = entityarrow;
        }
        if (mainKunai == null) {
            mainKunai = new KunaiProjectileEntity((EntityType<? extends KunaiProjectileEntity>)((EntityType)RoeWeaponsModEntities.KUNAI_PROJECTILE.get()), entity, entity.m_9236_());
            double dx = target.m_20185_() - entity.m_20185_();
            double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
            double dz = target.m_20189_() - entity.m_20189_();
            mainKunai.m_6686_(dx, dy - mainKunai.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
            mainKunai.m_20225_(true);
            mainKunai.m_36781_(3.0);
            mainKunai.m_36735_(0);
            mainKunai.m_36762_(false);
            entity.m_9236_().m_7967_((Entity)mainKunai);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return mainKunai;
    }
}

