/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class RoeWeaponsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue CROSSBOW_LAG_COMPENSATION;
    public static final ForgeConfigSpec.IntValue KUNAI_PROJECTILE_COUNT;
    public static final ForgeConfigSpec.DoubleValue KUNAI_SPREAD_ANGLE;
    public static final ForgeConfigSpec.IntValue KUNAI_COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue ALLOW_TIPPED_INFINITY;
    public static final ForgeConfigSpec.BooleanValue ALLOW_SPECTRAL_INFINITY;
    public static final ForgeConfigSpec.BooleanValue ALLOW_MODDED_INFINITY;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_POWER;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_PUNCH;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_FLAME;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_INFINITY;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_MULTISHOT;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_QUICK_CHARGE;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BOW_PIERCING;
    public static final ForgeConfigSpec.BooleanValue ALLOW_CROSSBOW_POWER;
    public static final ForgeConfigSpec.BooleanValue ALLOW_CROSSBOW_MULTISHOT;
    public static final ForgeConfigSpec.BooleanValue ALLOW_CROSSBOW_QUICK_CHARGE;
    public static final Map<String, WeaponSettings> WEAPON_SETTINGS;

    private static void configureBow(String weaponId, int defaultArrows, int defaultConsumption, int multishotArrows, int multishotConsumption, float velocityMultiplier, float spreadAngle) {
        BUILDER.push(weaponId);
        WeaponSettings settings = new WeaponSettings(BUILDER.comment("Number of arrows shot without multishot").defineInRange("baseArrowCount", defaultArrows, 1, 10), BUILDER.comment("Number of arrows consumed per shot without multishot").defineInRange("baseArrowConsumption", defaultConsumption, 0, 10), BUILDER.comment("Number of arrows shot with multishot").defineInRange("multishotArrowCount", multishotArrows, 1, 15), BUILDER.comment("Number of arrows consumed per shot with multishot").defineInRange("multishotArrowConsumption", multishotConsumption, 0, 10), BUILDER.comment("Velocity multiplier for arrows").defineInRange("velocityMultiplier", (double)velocityMultiplier, 0.5, 5.0), BUILDER.comment("Spread angle between multiple arrows in degrees").defineInRange("spreadAngle", (double)spreadAngle, 0.1, 10.0));
        WEAPON_SETTINGS.put(weaponId, settings);
        BUILDER.pop();
    }

    static {
        WEAPON_SETTINGS = new HashMap<String, WeaponSettings>();
        BUILDER.comment("RoeWeapons Configuration").push("general");
        BUILDER.push("Performance");
        CROSSBOW_LAG_COMPENSATION = BUILDER.comment("Lag compensation for crossbow firing (higher = more lenient)").defineInRange("crossbowLagCompensation", 3, 0, 10);
        BUILDER.pop();
        BUILDER.push("Kunai Settings");
        KUNAI_PROJECTILE_COUNT = BUILDER.comment("Number of kunai projectiles to shoot at once").defineInRange("kunaiProjectileCount", 3, 1, 10);
        KUNAI_SPREAD_ANGLE = BUILDER.comment("Spread angle between kunai projectiles in degrees").defineInRange("kunaiSpreadAngle", 5.0, 0.0, 45.0);
        KUNAI_COOLDOWN = BUILDER.comment("Cooldown in ticks between kunai throws (20 ticks = 1 second)").defineInRange("kunaiCooldown", 60, 0, 200);
        BUILDER.pop();
        BUILDER.push("Arrow Types");
        ALLOW_TIPPED_INFINITY = BUILDER.comment("Allow Infinity enchantment to work with tipped arrows").define("allowTippedInfinity", true);
        ALLOW_SPECTRAL_INFINITY = BUILDER.comment("Allow Infinity enchantment to work with spectral arrows").define("allowSpectralInfinity", true);
        ALLOW_MODDED_INFINITY = BUILDER.comment("Allow Infinity enchantment to work with modded arrows").define("allowModdedInfinity", true);
        BUILDER.pop();
        RoeWeaponsConfig.configureBow("bow_0", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_1", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_2", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_3", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_4", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_5", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_6", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("bow_7", 1, 1, 3, 1, 3.15f, 0.8f);
        RoeWeaponsConfig.configureBow("admin_bow", 8, 1, 12, 1, 4.0f, 0.8f);
        RoeWeaponsConfig.configureBow("cursed_bow", 1, 1, 4, 1, 3.5f, 0.7f);
        RoeWeaponsConfig.configureBow("featherdraw", 3, 3, 6, 3, 3.8f, 0.6f);
        RoeWeaponsConfig.configureBow("crossbow_0", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_1", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_2", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_3", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_4", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_5", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_6", 1, 1, 3, 1, 3.15f, 2.0f);
        RoeWeaponsConfig.configureBow("crossbow_7", 1, 1, 3, 1, 3.15f, 2.0f);
        BUILDER.push("Bow Enchantments");
        ALLOW_BOW_POWER = BUILDER.comment("Allow Power enchantment on bows").define("allowBowPower", true);
        ALLOW_BOW_PUNCH = BUILDER.comment("Allow Punch enchantment on bows").define("allowBowPunch", true);
        ALLOW_BOW_FLAME = BUILDER.comment("Allow Flame enchantment on bows").define("allowBowFlame", true);
        ALLOW_BOW_INFINITY = BUILDER.comment("Allow Infinity enchantment on bows").define("allowBowInfinity", true);
        ALLOW_BOW_MULTISHOT = BUILDER.comment("Allow Multishot enchantment on bows").define("allowBowMultishot", true);
        ALLOW_BOW_QUICK_CHARGE = BUILDER.comment("Allow Quick Charge enchantment on bows").define("allowBowQuickCharge", true);
        ALLOW_BOW_PIERCING = BUILDER.comment("Allow Piercing enchantment on bows").define("allowBowPiercing", true);
        BUILDER.pop();
        BUILDER.push("Crossbow Enchantments");
        ALLOW_CROSSBOW_POWER = BUILDER.comment("Allow Power enchantment on crossbows").define("allowCrossbowPower", true);
        ALLOW_CROSSBOW_MULTISHOT = BUILDER.comment("Allow Multishot enchantment on crossbows").define("allowCrossbowMultishot", true);
        ALLOW_CROSSBOW_QUICK_CHARGE = BUILDER.comment("Allow Quick Charge enchantment on crossbows").define("allowCrossbowQuickCharge", true);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class WeaponSettings {
        public final ForgeConfigSpec.IntValue baseArrowCount;
        public final ForgeConfigSpec.IntValue baseArrowConsumption;
        public final ForgeConfigSpec.IntValue multishotArrowCount;
        public final ForgeConfigSpec.IntValue multishotArrowConsumption;
        public final ForgeConfigSpec.DoubleValue velocityMultiplier;
        public final ForgeConfigSpec.DoubleValue spreadAngle;

        public WeaponSettings(ForgeConfigSpec.IntValue baseArrowCount, ForgeConfigSpec.IntValue baseArrowConsumption, ForgeConfigSpec.IntValue multishotArrowCount, ForgeConfigSpec.IntValue multishotArrowConsumption, ForgeConfigSpec.DoubleValue velocityMultiplier, ForgeConfigSpec.DoubleValue spreadAngle) {
            this.baseArrowCount = baseArrowCount;
            this.baseArrowConsumption = baseArrowConsumption;
            this.multishotArrowCount = multishotArrowCount;
            this.multishotArrowConsumption = multishotArrowConsumption;
            this.velocityMultiplier = velocityMultiplier;
            this.spreadAngle = spreadAngle;
        }
    }
}

