/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class EnchantmentConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue LIGHTNING_STRIKE_ENABLED;
    public static final ForgeConfigSpec.DoubleValue LIGHTNING_STRIKE_CHANCE_LEVEL_1;
    public static final ForgeConfigSpec.DoubleValue LIGHTNING_STRIKE_CHANCE_LEVEL_2;
    public static final ForgeConfigSpec.DoubleValue LIGHTNING_STRIKE_CHANCE_LEVEL_3;
    public static final ForgeConfigSpec.IntValue LIGHTNING_STRIKE_DURABILITY_DAMAGE;
    public static final ForgeConfigSpec.BooleanValue LIGHTNING_STRIKE_AOE_ENABLED;
    public static final ForgeConfigSpec.DoubleValue LIGHTNING_STRIKE_AOE_RADIUS;
    public static final ForgeConfigSpec.DoubleValue LIGHTNING_STRIKE_AOE_DAMAGE;
    public static final ForgeConfigSpec.IntValue LIGHTNING_STRIKE_FIRE_DURATION_BASE;
    public static final ForgeConfigSpec.IntValue LIGHTNING_STRIKE_FIRE_DURATION_PER_LEVEL;
    public static final ForgeConfigSpec.IntValue LIGHTNING_STRIKE_AOE_FIRE_DURATION;

    static {
        BUILDER.comment("Enchantment Configuration for RoeWeapons").push("enchantments");
        BUILDER.push("Lightning Strike");
        LIGHTNING_STRIKE_ENABLED = BUILDER.comment("Enable Lightning Strike enchantment").define("enabled", true);
        LIGHTNING_STRIKE_CHANCE_LEVEL_1 = BUILDER.comment("Chance for lightning strike at level 1 (0.0-1.0)").defineInRange("chanceLevelOne", 0.075, 0.0, 1.0);
        LIGHTNING_STRIKE_CHANCE_LEVEL_2 = BUILDER.comment("Chance for lightning strike at level 2 (0.0-1.0)").defineInRange("chanceLevelTwo", 0.1, 0.0, 1.0);
        LIGHTNING_STRIKE_CHANCE_LEVEL_3 = BUILDER.comment("Chance for lightning strike at level 3 (0.0-1.0)").defineInRange("chanceLevelThree", 0.125, 0.0, 1.0);
        LIGHTNING_STRIKE_DURABILITY_DAMAGE = BUILDER.comment("Durability damage dealt to weapon when lightning strikes").defineInRange("durabilityDamage", 2, 0, 10);
        BUILDER.push("AOE Settings");
        LIGHTNING_STRIKE_AOE_ENABLED = BUILDER.comment("Enable AOE damage from lightning strikes").define("aoeEnabled", true);
        LIGHTNING_STRIKE_AOE_RADIUS = BUILDER.comment("Area of effect radius for lightning strike damage").defineInRange("aoeRadius", 3.0, 0.0, 10.0);
        LIGHTNING_STRIKE_AOE_DAMAGE = BUILDER.comment("Base damage dealt to entities within AOE radius").defineInRange("aoeDamage", 6.0, 0.0, 20.0);
        BUILDER.pop();
        BUILDER.push("Fire Settings");
        LIGHTNING_STRIKE_FIRE_DURATION_BASE = BUILDER.comment("Base fire duration in seconds for target").defineInRange("fireDurationBase", 5, 0, 30);
        LIGHTNING_STRIKE_FIRE_DURATION_PER_LEVEL = BUILDER.comment("Additional fire duration per enchantment level").defineInRange("fireDurationPerLevel", 2, 0, 10);
        LIGHTNING_STRIKE_AOE_FIRE_DURATION = BUILDER.comment("Fire duration for AOE targets").defineInRange("aoeFireDuration", 3, 0, 15);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

