/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.client;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import roe.weapons.init.RoeWeaponsModItems;

@Mod.EventBusSubscriber(modid="roe_weapons", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_0.get(), "bow_0");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_1.get(), "bow_1");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_2.get(), "bow_2");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_3.get(), "bow_3");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_4.get(), "bow_4");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_5.get(), "bow_5");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_6.get(), "bow_6");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.BOW_7.get(), "bow_7");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.CURSED_BOW.get(), "cursed_bow");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.FEATHERDRAW.get(), "featherdraw");
        ClientSetup.registerBowProperties((Item)RoeWeaponsModItems.ADMIN_BOW.get(), "admin_bow");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_0.get(), "crossbow_0");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_1.get(), "crossbow_1");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_2.get(), "crossbow_2");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_3.get(), "crossbow_3");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_4.get(), "crossbow_4");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_5.get(), "crossbow_5");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_6.get(), "crossbow_6");
        ClientSetup.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_7.get(), "crossbow_7");
    }

    private static void registerBowProperties(Item bowItem, String bowName) {
        ItemProperties.register((Item)bowItem, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)bowItem, (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.m_6117_() && entity.m_21211_() == stack) {
                int baseDrawTime = 20;
                int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
                float drawTimeMultiplier = quickChargeLevel > 0 ? 1.0f - (float)quickChargeLevel * 0.15f : 1.0f;
                int useDuration = stack.m_41779_();
                int ticksInUse = useDuration - entity.m_21212_();
                float pullProgress = (float)ticksInUse / ((float)baseDrawTime * drawTimeMultiplier);
                return Math.min(pullProgress, 1.0f);
            }
            return 0.0f;
        });
    }

    private static void registerCrossbowProperties(Item crossbowItem, String crossbowName) {
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack)) {
                int baseChargeTime = 25;
                int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
                float quickChargeMultiplier = quickChargeLevel > 0 ? 1.0f - (float)quickChargeLevel * 0.25f : 1.0f;
                int timeLeft = entity.m_21212_();
                int useDuration = stack.m_41779_();
                int ticksInUse = useDuration - timeLeft;
                float pullProgress = (float)ticksInUse / ((float)baseChargeTime * quickChargeMultiplier);
                return Math.min(pullProgress, 1.0f);
            }
            return 0.0f;
        });
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity, seed) -> CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("firework"), (stack, world, entity, seed) -> CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }
}

