/*
 * Decompiled with CFR 0.152.
 */
package roe.weapons.client;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import roe.weapons.init.RoeWeaponsModItems;

@Mod.EventBusSubscriber(modid="roe_weapons", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_0.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_1.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_2.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_3.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_4.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_5.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_6.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.BOW_7.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.CURSED_BOW.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.FEATHERDRAW.get());
        ClientModEvents.registerBowProperties((Item)RoeWeaponsModItems.ADMIN_BOW.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_0.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_1.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_2.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_3.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_4.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_5.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_6.get());
        ClientModEvents.registerCrossbowProperties((Item)RoeWeaponsModItems.CROSSBOW_7.get());
    }

    private static void registerBowProperties(Item bowItem) {
        ItemProperties.register((Item)bowItem, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)bowItem, (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.m_6117_() && entity.m_21211_() == stack) {
                return (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
            }
            return 0.0f;
        });
    }

    private static void registerCrossbowProperties(Item crossbowItem) {
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            if (entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack)) {
                int baseChargeTime = 25;
                int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
                float quickChargeMultiplier = quickChargeLevel > 0 ? 1.0f + (float)quickChargeLevel * 0.5f : 1.0f;
                int timeLeft = entity.m_21212_();
                int chargeTime = baseChargeTime - timeLeft;
                float pullProgress = (float)chargeTime / (float)baseChargeTime * quickChargeMultiplier;
                return Math.min(pullProgress, 1.0f);
            }
            return 0.0f;
        });
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity, seed) -> CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)new ResourceLocation("firework"), (stack, world, entity, seed) -> CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }
}

