/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.surfacerules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.stateproviders.BetweenNoiseThresholdProvider;
import org.jetbrains.annotations.NotNull;

public class BetweenRepeatingNoiseRange
implements SurfaceRules.RuleSource {
    public static final KeyDispatchDataCodec<BetweenRepeatingNoiseRange> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256865_).fieldOf("noise").forGetter(betweenRepeatingNoiseRange -> betweenRepeatingNoiseRange.noiseParametersResourceKey), (App)Codec.FLOAT.fieldOf("size_per_repetition").forGetter(betweenRepeatingNoiseRange -> Float.valueOf(betweenRepeatingNoiseRange.size)), (App)Codec.FLOAT.fieldOf("repeat_from_noise").forGetter(betweenRepeatingNoiseRange -> Float.valueOf(betweenRepeatingNoiseRange.min)), (App)Codec.FLOAT.fieldOf("repeat_to_noise").forGetter(betweenRepeatingNoiseRange -> Float.valueOf(betweenRepeatingNoiseRange.max)), (App)SurfaceRules.RuleSource.f_189682_.listOf().fieldOf("rule_sources").forGetter(betweenRepeatingNoiseRange -> Arrays.asList(betweenRepeatingNoiseRange.ruleSources))).apply((Applicative)builder, BetweenRepeatingNoiseRange::new)));
    private final ResourceKey<NormalNoise.NoiseParameters> noiseParametersResourceKey;
    private final float size;
    private final float min;
    private final float max;
    private final SurfaceRules.RuleSource[] ruleSources;
    private final SurfaceRules.RuleSource rule;

    public BetweenRepeatingNoiseRange(ResourceKey<NormalNoise.NoiseParameters> noiseParametersResourceKey, float size, float min, float max, List<SurfaceRules.RuleSource> ruleSources) {
        this(noiseParametersResourceKey, size, min, max, (SurfaceRules.RuleSource[])ruleSources.toArray(SurfaceRules.RuleSource[]::new));
    }

    public BetweenRepeatingNoiseRange(ResourceKey<NormalNoise.NoiseParameters> noiseParametersResourceKey, float size, float min, float max, SurfaceRules.RuleSource ... ruleSources) {
        this.noiseParametersResourceKey = noiseParametersResourceKey;
        this.size = size;
        this.min = min;
        this.max = max;
        this.ruleSources = ruleSources;
        this.rule = BetweenRepeatingNoiseRange.createNoiseConditions(noiseParametersResourceKey, BetweenNoiseThresholdProvider.createThresholds(size, min, max), ruleSources);
    }

    private static SurfaceRules.RuleSource createNoiseConditions(ResourceKey<NormalNoise.NoiseParameters> parametersResourceKey, List<FloatProvider> ranges, SurfaceRules.RuleSource ... source) {
        ArrayList<SurfaceRules.RuleSource> sources = new ArrayList<SurfaceRules.RuleSource>();
        int index = 0;
        for (FloatProvider range : ranges) {
            SurfaceRules.RuleSource ruleSource = source[index % source.length];
            sources.add(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(parametersResourceKey, (double)range.m_142735_(), (double)range.m_142734_()), (SurfaceRules.RuleSource)ruleSource));
            ++index;
        }
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])sources.toArray(SurfaceRules.RuleSource[]::new)));
    }

    @NotNull
    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return (SurfaceRules.SurfaceRule)this.rule.apply((Object)context);
    }
}

