/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.processors;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGCustomStructureProcessors;
import org.jetbrains.annotations.NotNull;

public class FruitBlockProcessor
extends StructureProcessor {
    public static final Codec<FruitBlockProcessor> CODEC = BuiltInRegistries.f_256975_.m_194605_().fieldOf("fruit_block").xmap(FruitBlockProcessor::new, processor -> processor.fruitBlock).codec();
    private final BWGFruitBlock fruitBlock;

    public FruitBlockProcessor(BWGFruitBlock fruitBlock) {
        this.fruitBlock = fruitBlock;
    }

    private FruitBlockProcessor(Block fruitBlock) {
        this((BWGFruitBlock)fruitBlock);
    }

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> m_276976_(@NotNull ServerLevelAccessor serverLevel, @NotNull BlockPos offset, @NotNull BlockPos pos, @NotNull List<StructureTemplate.StructureBlockInfo> originalBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlockInfos, @NotNull StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> newInfo = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        processedBlockInfos.stream().filter(blockInfo -> blockInfo.f_74676_().m_60713_((Block)this.fruitBlock.getLeaves())).forEach(leavesBlockInfo -> {
            BlockPos fruitPos = leavesBlockInfo.f_74675_().m_7495_();
            if (serverLevel.m_8055_(fruitPos).m_60795_() && serverLevel.m_213780_().m_188499_()) {
                newInfo.stream().filter(blockInfo -> blockInfo.f_74675_().equals((Object)fruitPos)).findFirst().ifPresent(fruitSpot -> newInfo.set(newInfo.indexOf(fruitSpot), new StructureTemplate.StructureBlockInfo(fruitSpot.f_74675_(), (BlockState)this.fruitBlock.m_49966_().m_61124_((Property)BWGFruitBlock.AGE, (Comparable)Integer.valueOf(serverLevel.m_213780_().m_188503_(3))), fruitSpot.f_74677_())));
            }
        });
        return newInfo;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return BWGCustomStructureProcessors.FRUIT_BLOCK_PROCESSOR.get();
    }
}

