/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.client.particle.particles.FallingLeafParticle;
import net.potionstudios.biomeswevegone.client.particle.particles.FireFlyParticle;
import net.potionstudios.biomeswevegone.client.renderer.entity.boat.BWGBoatRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.manowar.ManOWarRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.oddion.OddionRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden.PumpkinWardenRenderer;
import net.potionstudios.biomeswevegone.client.renderer.entity.wreath.WreathRenderer;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.entity.decoration.Wreath;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntityType;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import org.apache.logging.log4j.util.TriConsumer;

public class BiomesWeveGoneClient {
    private static final ImprovedNoise NOISE = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(1L));

    public static void onInitialize() {
        BWGWoodSet.woodsets().forEach(set -> BiomesWeveGoneClient.registerWoodTypes(set.woodType()));
    }

    private static void registerWoodTypes(WoodType woodType) {
        Sheets.f_110743_.put(woodType, Sheets.m_173385_((WoodType)woodType));
        Sheets.f_244291_.put(woodType, Sheets.m_245275_((WoodType)woodType));
    }

    public static void registerEntityRenderers(BiConsumer<EntityType<? extends Entity>, EntityRendererProvider> consumer) {
        consumer.accept(BWGEntityType.MAN_O_WAR.get(), ManOWarRenderer::new);
        consumer.accept(BWGEntityType.PUMPKIN_WARDEN.get(), PumpkinWardenRenderer::new);
        consumer.accept(BWGEntityType.ODDION.get(), OddionRenderer::new);
        consumer.accept(BWGEntityType.BWG_BOAT.get(), context -> new BWGBoatRenderer(context, false));
        consumer.accept(BWGEntityType.BWG_CHEST_BOAT.get(), context -> new BWGBoatRenderer(context, true));
        consumer.accept(BWGEntityType.WREATH.get(), WreathRenderer::new);
    }

    public static void registerBlockEntityRenderers(BiConsumer<BlockEntityType<? extends BlockEntity>, BlockEntityRendererProvider> consumer) {
        consumer.accept(BWGBlockEntityType.SIGNS.get(), SignRenderer::new);
        consumer.accept(BWGBlockEntityType.HANGING_SIGNS.get(), HangingSignRenderer::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        for (BWGBoatEntity.Type type : BWGBoatEntity.Type.values()) {
            consumer.accept(BWGBoatRenderer.createBoatModelName(type), BoatModel::m_246613_);
            consumer.accept(BWGBoatRenderer.createChestBoatModelName(type), ChestBoatModel::m_247175_);
        }
    }

    public static void registerAdditionalModels(Consumer<ModelResourceLocation> consumer) {
        Arrays.stream(Wreath.Type.values()).forEach(type -> consumer.accept(new ModelResourceLocation("biomeswevegone", type.m_7912_() + "_wreath", "")));
    }

    public static void registerParticles(BiConsumer<SimpleParticleType, Function<SpriteSet, ParticleProvider<SimpleParticleType>>> consumer) {
        consumer.accept(BWGParticles.FIREFLY.get(), FireFlyParticle.Provider::new);
        consumer.accept(BWGParticles.BOREALIS_GLINT.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WITCH_HAZEL_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.WHITE_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.YELLOW_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.RED_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.SILVER_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        consumer.accept(BWGParticles.IRONWOOD_LEAVES.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerItemProperties(TriConsumer<Item, ResourceLocation, ClampedItemPropertyFunction> consumer) {
        consumer.accept((Object)BWGBlocks.PUMPKIN_BURROW.get().m_5456_(), (Object)BiomesWeveGone.id("occupied"), (itemStack, clientLevel, livingEntity, i) -> {
            if (livingEntity != null && itemStack.m_150930_(BWGBlocks.PUMPKIN_BURROW.get().m_5456_()) && itemStack.m_41783_() != null) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    public static void registerBlockColors(BiConsumer<BlockColor, Block[]> consumer) {
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)view, (BlockPos)pos) : GrassColor.m_276205_(), new Block[]{(Block)BWGBlocks.FLOWER_PATCH.get(), (Block)BWGBlocks.TINY_LILY_PADS.get(), (Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (Block)BWGBlocks.OVERGROWN_DACITE.get(), (Block)BWGBlocks.WHITE_OVERGROWN_DACITE.get(), (Block)BWGBlocks.OVERGROWN_STONE.get(), (Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), (Block)BWGBlocks.WHITE_SAKURA_PETALS.get(), (Block)BWGBlocks.YELLOW_SAKURA_PETALS.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos) : FoliageColor.m_46107_((double)0.5, (double)1.0), new Block[]{(Block)BWGBlocks.CLOVER_PATCH.get(), (Block)BWGBlocks.LEAF_PILE.get(), (Block)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (Block)BWGWood.YUCCA_LEAVES.get(), (Block)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (Block)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves()});
        consumer.accept((state, view, pos, tintIndex) -> BiomesWeveGoneClient.getBorealisIceColor(Objects.requireNonNullElse(pos, BlockPos.f_121853_)), new Block[]{(Block)BWGBlocks.BOREALIS_ICE.get(), (Block)BWGBlocks.PACKED_BOREALIS_ICE.get()});
        consumer.accept((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)view, (BlockPos)pos) : -1, new Block[]{BWGBlocks.CARVED_BARREL_CACTUS.get()});
    }

    public static void registerBlockItemColors(Consumer<Block[]> consumer) {
        consumer.accept(new Block[]{(Block)BWGBlocks.TINY_LILY_PADS.get(), (Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (Block)BWGBlocks.CLOVER_PATCH.get(), (Block)BWGBlocks.LEAF_PILE.get(), (Block)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (Block)BWGWood.YUCCA_LEAVES.get(), (Block)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (Block)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves(), (Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), (Block)BWGBlocks.OVERGROWN_DACITE.get(), (Block)BWGBlocks.OVERGROWN_STONE.get()});
    }

    private static int getBorealisIceColor(BlockPos pos) {
        float factor = (float)((NOISE.m_164308_((double)((float)pos.m_123341_() * 0.01f), (double)((float)pos.m_123342_() * 0.01f), (double)((float)pos.m_123343_() * 0.01f)) + 1.0) * 0.5);
        float hue = 320.0f - 200.0f * factor;
        return BiomesWeveGoneClient.HSBtoRGB(hue / 360.0f, 0.6f, 1.0f);
    }

    private static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

