/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.DieAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.HurtAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.LookAtTargetGoal;
import com.bobmowzie.mowziesmobs.server.ai.NearestAttackableTargetPredicateGoal;
import com.bobmowzie.mowziesmobs.server.ai.UmvuthanaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCrane;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerUmvuthiTrade;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.UmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityUmvuthi
extends MowzieGeckoEntity
implements LeaderSunstrikeImmune,
Enemy {
    public static final AbilityType<EntityUmvuthi, DieAbility<EntityUmvuthi>> DIE_ABILITY = new AbilityType<EntityUmvuthi, DieAbility>("umvuthi_die", (type, entity) -> new DieAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("death"), 115){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 1) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_HURT.get(), ((EntityUmvuthi)this.getUser()).m_6121_(), ((EntityUmvuthi)this.getUser()).m_6100_());
            }
            if (this.getTicksInUse() == 14) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_DIE.get(), ((EntityUmvuthi)this.getUser()).m_6121_(), 1.0f);
            }
            if (this.getTicksInUse() == 80) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.MISC_METAL_IMPACT.get(), ((EntityUmvuthi)this.getUser()).m_6121_(), 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, HurtAbility<EntityUmvuthi>> HURT_ABILITY = new AbilityType<EntityUmvuthi, HurtAbility>("umvuthi_hurt", (type, entity) -> new HurtAbility<EntityUmvuthi>(type, (EntityUmvuthi)entity, RawAnimation.begin().thenPlay("hurt"), 13, 10));
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> BELLY_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_belly", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("belly_drum"), 40, true){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 9 || this.getTicksInUse() == 29) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 3.0f, 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> TALK_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_talk", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, (EntityUmvuthi)entity, RawAnimation.begin().thenPlay("talk"), 23, true));
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> ROAR_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_roar", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("roar"), 70, false){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 2) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_ROAR.get(), 3.0f, 1.0f);
            }
        }
    });
    public static final AbilityType<EntityUmvuthi, SunstrikeAbility> SUNSTRIKE_ABILITY = new AbilityType<EntityUmvuthi, SunstrikeAbility>("umvuthi_sunstrike", SunstrikeAbility::new);
    public static final AbilityType<EntityUmvuthi, SolarFlareAbility> SOLAR_FLARE_ABILITY = new AbilityType<EntityUmvuthi, SolarFlareAbility>("umvuthi_flare", SolarFlareAbility::new);
    public static final AbilityType<EntityUmvuthi, SpawnFollowersAbility> SPAWN_ABILITY = new AbilityType<EntityUmvuthi, SpawnFollowersAbility>("umvuthi_spawn", (type, entity) -> new SpawnFollowersAbility(type, (EntityUmvuthi)entity, false));
    public static final AbilityType<EntityUmvuthi, SpawnFollowersAbility> SPAWN_SUNBLOCKERS_ABILITY = new AbilityType<EntityUmvuthi, SpawnFollowersAbility>("umvuthi_spawn_healers", (type, entity) -> new SpawnFollowersAbility(type, (EntityUmvuthi)entity, true));
    public static final AbilityType<EntityUmvuthi, SolarBeamAbility> SOLAR_BEAM_ABILITY = new AbilityType<EntityUmvuthi, SolarBeamAbility>("umvuthi_solar_beam", SolarBeamAbility::new);
    public static final AbilityType<EntityUmvuthi, SimpleAnimationAbility<EntityUmvuthi>> BLESS_ABILITY = new AbilityType<EntityUmvuthi, SimpleAnimationAbility>("umvuthi_bless", (type, entity) -> new SimpleAnimationAbility<EntityUmvuthi>(type, entity, RawAnimation.begin().thenPlay("bless"), 84){

        @Override
        public boolean canCancelActiveAbility() {
            return ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == ROAR_ABILITY || ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == TALK_ABILITY || ((EntityUmvuthi)this.getUser()).getActiveAbilityType() == BELLY_ABILITY;
        }
    });
    public static final AbilityType<EntityUmvuthi, SupernovaAbility> SUPERNOVA_ABILITY = new AbilityType<EntityUmvuthi, SupernovaAbility>("umvuthi_supernova", SupernovaAbility::new);
    protected AnimationController<MowzieGeckoEntity> maskController = new MowzieAnimationController<EntityUmvuthi>(this, "mask_controller", 1, this::predicateMask, 0.0);
    protected AnimationController<MowzieGeckoEntity> blinkController = new MowzieAnimationController<EntityUmvuthi>(this, "blink_controller", 1, this::predicateBlink, 0.0);
    private static final int MAX_HEALTH = 150;
    private static final int SUNSTRIKE_PAUSE_MAX = 50;
    private static final int SUNSTRIKE_PAUSE_MIN = 30;
    private static final int LASER_PAUSE = 230;
    private static final int SUPERNOVA_PAUSE = 230;
    private static final int UMVUTHANA_PAUSE = 200;
    private static final int ROAR_PAUSE = 300;
    private static final int HEAL_PAUSE = 75;
    private static final int HEALTH_LOST_BETWEEN_SUNBLOCKERS = 45;
    private static final EntityDataAccessor<Integer> DIRECTION = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DIALOGUE = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DESIRES = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<CompoundTag> TRADED_PLAYERS = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Float> HEALTH_LOST = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> MISBEHAVED_PLAYER = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> IS_TRADING = SynchedEntityData.m_135353_(EntityUmvuthi.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    private Player customer;
    public int umvuthanaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilUmvuthana = 0;
    private int timeUntilRoar = 0;
    private int timeUntilSupernova = 0;
    private int timeUntilHeal = 0;
    public Player blessingPlayer;
    private UmvuthanaHurtByTargetAI hurtByTargetAI;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] betweenHandPos;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] headPos;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] blessingPlayerPos;
    private static final TargetingConditions GIVE_ACHIEVEMENT_PRED = TargetingConditions.m_148352_().m_26893_();
    private float prevMaskRot = 0.0f;
    private boolean rattling = false;
    private static RawAnimation MASK_TWITCH_ANIM = RawAnimation.begin().thenLoop("mask_twitch");
    private static RawAnimation BLINK_ANIM = RawAnimation.begin().thenLoop("blink");

    public EntityUmvuthi(EntityType<? extends EntityUmvuthi> type, Level world) {
        super(type, world);
        if (this.getDirectionData() == 0) {
            this.setDirection(this.f_19796_.m_188503_(4) + 1);
        }
        this.f_21364_ = 45;
        if (world.f_46443_) {
            this.headPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.betweenHandPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.blessingPlayerPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
        this.active = true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.hurtByTargetAI = new UmvuthanaHurtByTargetAI(this, false, new Class[0]);
        this.f_21346_.m_25352_(3, (Goal)this.hurtByTargetAI);
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetPredicateGoal<Player>((Mob)this, Player.class, 0, false, true, TargetingConditions.m_148352_().m_26883_(this.m_21133_(Attributes.f_22277_)).m_26888_(target -> {
            if (target instanceof Player) {
                if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((Player)target).m_150109_().f_35975_.get(3);
                return !(headArmorStack.m_41720_() instanceof UmvuthanaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }).m_148355_()){

            public void m_8041_() {
                super.m_8041_();
                EntityUmvuthi.this.setMisbehavedPlayerId(null);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 0, false, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 0, false, false, e -> !(e instanceof ZombifiedPiglin)));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, 0, false, false, null));
        this.f_21345_.m_25352_(1, new UseAbilityAI<EntityUmvuthi>(this, DIE_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, HURT_ABILITY, false));
        this.f_21345_.m_25352_(6, new UseAbilityAI<EntityUmvuthi>(this, BELLY_ABILITY, false));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SUNSTRIKE_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SOLAR_FLARE_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SOLAR_BEAM_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SUPERNOVA_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SPAWN_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, SPAWN_SUNBLOCKERS_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, BLESS_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, TALK_ABILITY, false));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityUmvuthi>(this, ROAR_ABILITY, true));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTargetGoal((Mob)this, 24.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityUmvuthana.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return super.m_6431_(poseIn, sizeIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{this.maskController});
        controllers.add(new AnimationController[]{this.blinkController});
    }

    protected <E extends GeoEntity> PlayState predicateMask(AnimationState<E> state) {
        if (this.m_6084_() && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY && this.getActiveAbilityType() != SUPERNOVA_ABILITY && this.getActiveAbilityType() != SPAWN_ABILITY && this.getActiveAbilityType() != SPAWN_SUNBLOCKERS_ABILITY) {
            state.getController().setAnimation(MASK_TWITCH_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected <E extends GeoEntity> PlayState predicateBlink(AnimationState<E> event) {
        if (this.m_6084_() && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY) {
            event.getController().setAnimation(BLINK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        event.getController().transitionLength(4);
        super.loopingAnimations(event);
    }

    public boolean m_8023_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        if (this.getActiveAbility() == null) {
            this.sendAbilityMessage(TALK_ABILITY);
            return (SoundEvent)MMSounds.ENTITY_UMVUTHI_IDLE.get();
        }
        return null;
    }

    public void updateRattleSound(float maskRot) {
        if (!this.rattling) {
            if ((double)Math.abs(maskRot - this.prevMaskRot) > 0.05) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MMSounds.ENTITY_UMVUTHANA_RATTLE.get(), SoundSource.HOSTILE, 0.04f, this.m_6100_() * 0.75f, false);
            }
        } else if ((double)Math.abs(maskRot - this.prevMaskRot) < 1.0E-8) {
            this.rattling = false;
        }
        this.prevMaskRot = maskRot;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_UMVUTHI_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public boolean shouldRenderSun() {
        return this.f_20919_ < 85 && (this.getActiveAbilityType() != SUPERNOVA_ABILITY || this.getActiveAbility().getTicksInUse() <= 5 || this.getActiveAbility().getTicksInUse() > 90);
    }

    @Override
    public void m_8119_() {
        double oz;
        double oy;
        double ox;
        this.legsUp.updatePrevTimer();
        this.angryEyebrow.updatePrevTimer();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.direction = this.getDirectionData();
        }
        if (this.getActiveAbilityType() != SOLAR_FLARE_ABILITY || this.getActiveAbility().getTicksInUse() < 12 || this.getActiveAbility().getTicksInUse() > 14) {
            this.repelEntities(1.2f, 1.2f, 1.2f, 1.2f);
        }
        this.m_146922_((this.direction - 1) * 90);
        this.f_20883_ = this.m_146908_();
        if (this.m_9236_().m_5776_() && this.shouldRenderSun() && this.headPos != null && this.headPos.length > 0 && this.headPos[0] != null) {
            if (this.f_19797_ % 10 == 1) {
                AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.3, 0.4, 1.0, 9.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.headPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.oscillate(12.5f, 13.5f, 12), false)});
            }
            if (this.f_19796_.m_188501_() < 0.3f) {
                int amount = this.f_19796_.m_188503_(2) + 1;
                while (amount-- > 0) {
                    float theta = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float r = this.f_19796_.m_188501_() * 0.4f;
                    float x = r * Mth.m_14089_((float)theta);
                    float z = r * Mth.m_14031_((float)theta);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.headPos[0].m_7096_() + (double)x, this.headPos[0].m_7098_() + 0.1, this.headPos[0].m_7094_() + (double)z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.getHealthLost() >= 45.0f && this.getActiveAbility() == null && !this.m_21525_() && this.getEntitiesNearby(EntityUmvuthanaCrane.class, 40.0).size() < 3) {
            this.sendAbilityMessage(SPAWN_SUNBLOCKERS_ABILITY);
            this.setHealthLost(0.0f);
        }
        if (this.m_5448_() != null) {
            boolean targetComingCloser;
            LivingEntity target = this.m_5448_();
            this.setAngry(true);
            float entityHitAngle = (float)((Math.atan2(target.m_20189_() - this.m_20189_(), target.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.m_146908_() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            Vec3 betweenEntitiesVec = this.m_20182_().m_82546_(target.m_20182_());
            boolean bl = targetComingCloser = target.m_20184_().m_82526_(betweenEntitiesVec) > 0.0 && target.m_20184_().m_82556_() > 0.015;
            if (this.getActiveAbility() == null && !this.m_21525_() && this.f_19796_.m_188503_(80) == 0 && ((double)this.targetDistance > 5.5 || this.m_21023_((MobEffect)EffectHandler.SUNBLOCK.get())) && this.timeUntilUmvuthana <= 0 && this.getEntitiesNearby(EntityUmvuthana.class, 50.0).size() < 4) {
                this.sendAbilityMessage(SPAWN_ABILITY);
                this.timeUntilUmvuthana = 200;
            } else if (this.getActiveAbility() == null && !this.m_21525_() && (double)this.getHealthRatio() <= 0.6 && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f) && this.m_21574_().m_148306_((Entity)target) && (double)this.targetDistance < 30.0) {
                this.sendAbilityMessage(SOLAR_BEAM_ABILITY);
                this.timeUntilLaser = 230;
            } else if (this.getActiveAbility() == null && !this.m_21525_() && (double)this.getHealthRatio() <= 0.6 && !this.m_21023_((MobEffect)EffectHandler.SUNBLOCK.get()) && this.timeUntilSupernova <= 0 && (double)this.targetDistance <= 10.5) {
                this.sendAbilityMessage(SUPERNOVA_ABILITY);
                this.timeUntilSupernova = 230;
            } else if (this.getActiveAbility() == null && !this.m_21525_() && (this.targetDistance <= 6.0f && targetComingCloser || this.targetDistance < 4.0f)) {
                this.sendAbilityMessage(SOLAR_FLARE_ABILITY);
            } else if (this.getActiveAbility() == null && !this.m_21525_() && this.timeUntilSunstrike <= 0) {
                this.sendAbilityMessage(SUNSTRIKE_ABILITY);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
            if (this.hurtByTargetAI != null && !this.hurtByTargetAI.m_8045_()) {
                this.hurtByTargetAI.m_8041_();
            }
        } else if (!this.m_9236_().f_46443_) {
            this.setAngry(false);
        }
        if (this.f_19797_ % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry()) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getActiveAbility() == null && !this.m_21525_() && this.m_5448_() == null && this.f_19796_.m_188503_(200) == 0) {
            this.sendAbilityMessage(BELLY_ABILITY);
        }
        if (this.getActiveAbility() == null && !this.m_21525_() && this.m_5448_() == null && this.timeUntilRoar <= 0 && this.f_19796_.m_188503_(300) == 0) {
            this.sendAbilityMessage(ROAR_ABILITY);
            this.timeUntilRoar = 300;
        }
        if (this.getActiveAbilityType() == SOLAR_FLARE_ABILITY) {
            this.f_20885_ = this.m_146908_();
            if (this.getActiveAbility().getTicksInUse() == 10) {
                if (this.m_9236_().f_46443_) {
                    this.spawnExplosionParticles(30);
                }
                this.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_ATTACK.get(), 1.7f, 0.9f);
            }
            if (this.getActiveAbility().getTicksInUse() <= 6 && this.m_9236_().f_46443_) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                    double pitch = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    float offsetX = (float)(-0.3 * Math.sin((double)this.m_146908_() * Math.PI / 180.0));
                    float offsetZ = (float)(-0.3 * Math.cos((double)this.m_146908_() * Math.PI / 180.0));
                    float offsetY = 1.0f;
                    this.m_9236_().m_7106_((ParticleOptions)new ParticleOrb.OrbData((float)this.m_20185_() + offsetX, (float)this.m_20186_() + offsetY, (float)this.m_20189_() + offsetZ, 6.0f), this.m_20185_() + ox + (double)offsetX, this.m_20186_() + (double)offsetY + oy, this.m_20189_() + oz + (double)offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.getActiveAbilityType() == BLESS_ABILITY) {
            this.f_20885_ = this.m_146908_();
            if (this.getActiveAbility().getTicksInUse() == 1) {
                this.blessingPlayer = this.getCustomer();
            }
            if (this.m_9236_().f_46443_ && this.blessingPlayer != null) {
                this.blessingPlayerPos[0] = this.blessingPlayer.m_20182_().m_82549_(new Vec3(0.0, (double)(this.blessingPlayer.m_20206_() / 2.0f), 0.0));
                if (this.getActiveAbility().getTicksInUse() > 5 && this.getActiveAbility().getTicksInUse() < 40) {
                    int particleCount = 2;
                    while (--particleCount != 0) {
                        double radius = 0.7f;
                        double yaw = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                        double pitch = (double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI;
                        ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        oy = radius * Math.cos(pitch);
                        oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.ORB2.get()), this.m_20185_() + ox, this.m_20186_() + (double)0.8f + oy, this.m_20189_() + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.Attractor(this.blessingPlayerPos, 0.5f, 0.2f, ParticleComponent.Attractor.EnumAttractorBehavior.LINEAR), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, new ParticleComponent.Oscillator(0.0f, (float)ox, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, new ParticleComponent.Oscillator(0.0f, (float)oy, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, new ParticleComponent.Oscillator(0.0f, (float)oz, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f}, new float[]{0.0f, 0.8f}), false)});
                    }
                }
                if (this.getActiveAbility().getTicksInUse() % 15 == 0) {
                    AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), this.m_20185_(), this.m_20186_() + (double)0.8f, this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(5.0f, 35.0f), false)});
                }
            }
        }
        if (this.f_19797_ % 40 == 0) {
            for (Player player : this.getPlayersNearby(15.0, 15.0, 15.0, 15.0)) {
                ItemStack headArmorStack = (ItemStack)player.m_150109_().f_35975_.get(3);
                if (this.m_5448_() == player || !this.m_21040_((LivingEntity)player, GIVE_ACHIEVEMENT_PRED) || !(headArmorStack.m_41720_() instanceof UmvuthanaMask) || !(player instanceof ServerPlayer)) continue;
                AdvancementHandler.SNEAK_VILLAGE_TRIGGER.trigger((ServerPlayer)player);
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY && this.getActiveAbilityType() != SUPERNOVA_ABILITY) {
            --this.timeUntilHeal;
            if (((Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.healsOutOfBattle.get()).booleanValue() && this.timeUntilHeal <= 0) {
                this.m_5634_(0.3f);
            }
            if (this.m_21223_() == this.m_21233_()) {
                this.setHealthLost(0.0f);
            }
        } else {
            this.timeUntilHeal = 75;
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0 && this.getActiveAbilityType() != SUPERNOVA_ABILITY) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilUmvuthana > 0) {
            --this.timeUntilUmvuthana;
        }
        if (this.timeUntilSupernova > 0 && this.getActiveAbilityType() != SOLAR_BEAM_ABILITY) {
            --this.timeUntilSupernova;
        }
        if (this.timeUntilRoar > 0) {
            --this.timeUntilRoar;
        }
    }

    @Override
    public AbilityType getHurtAbility() {
        return HURT_ABILITY;
    }

    @Override
    public AbilityType getDeathAbility() {
        return DIE_ABILITY;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (source == this.m_9236_().m_269111_().m_269047_()) {
            return false;
        }
        if (this.m_21023_((MobEffect)EffectHandler.SUNBLOCK.get()) && !source.m_269533_(DamageTypeTags.f_268738_)) {
            if (source.m_7640_() != null) {
                this.m_5496_((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
            }
            return false;
        }
        this.timeUntilHeal = 75;
        float prevHealth = this.m_21223_();
        boolean superResult = super.m_6469_(source, damage);
        if (superResult) {
            float diffHealth = prevHealth - this.m_21223_();
            this.setHealthLost(this.getHealthLost() + diffHealth);
        }
        return superResult;
    }

    private boolean checkBlocksByFeet() {
        BlockState blockRight;
        BlockState blockLeft;
        if (this.direction == 1) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            blockLeft = this.m_9236_().m_8055_(posLeft);
            blockRight = this.m_9236_().m_8055_(posRight);
        } else if (this.direction == 2) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            blockLeft = this.m_9236_().m_8055_(posLeft);
            blockRight = this.m_9236_().m_8055_(posRight);
        } else if (this.direction == 3) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            blockLeft = this.m_9236_().m_8055_(posLeft);
            blockRight = this.m_9236_().m_8055_(posRight);
        } else if (this.direction == 4) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            blockLeft = this.m_9236_().m_8055_(posLeft);
            blockRight = this.m_9236_().m_8055_(posRight);
        } else {
            return false;
        }
        return blockLeft.m_280555_() || blockRight.m_280555_();
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.f_19796_.m_188501_() * 0.1f - 0.05f;
            float vx = 0.25f * Mth.m_14089_((float)yaw);
            float vz = 0.25f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (double)vx, (double)vy, (double)vz);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DIRECTION, (Object)0);
        this.m_20088_().m_135372_(DIALOGUE, (Object)0);
        this.m_20088_().m_135372_(ANGRY, (Object)false);
        Item tradeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)ConfigHandler.COMMON.MOBS.UMVUTHI.whichItem.get()));
        this.m_20088_().m_135372_(DESIRES, (Object)new ItemStack((ItemLike)tradeItem, ((Integer)ConfigHandler.COMMON.MOBS.UMVUTHI.howMany.get()).intValue()));
        this.m_20088_().m_135372_(TRADED_PLAYERS, (Object)new CompoundTag());
        this.m_20088_().m_135372_(HEALTH_LOST, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(MISBEHAVED_PLAYER, Optional.empty());
        this.m_20088_().m_135372_(IS_TRADING, (Object)false);
    }

    public int getDirectionData() {
        return (Integer)this.m_20088_().m_135370_(DIRECTION);
    }

    public void setDirection(int direction) {
        this.m_20088_().m_135381_(DIRECTION, (Object)direction);
    }

    public int getWhichDialogue() {
        return (Integer)this.m_20088_().m_135370_(DIALOGUE);
    }

    public void setWhichDialogue(int dialogue) {
        this.m_20088_().m_135381_(DIALOGUE, (Object)dialogue);
    }

    public boolean getAngry() {
        return (Boolean)this.m_20088_().m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.m_20088_().m_135381_(ANGRY, (Object)angry);
    }

    public void setDesires(ItemStack stack) {
        this.m_20088_().m_135381_(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.m_20088_().m_135370_(DESIRES);
    }

    public void setTradedPlayersCompound(ListTag players) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("players", (Tag)players);
        this.m_20088_().m_135381_(TRADED_PLAYERS, (Object)compound);
    }

    public Set<UUID> getTradedPlayers() {
        HashSet<UUID> tradedPlayers = new HashSet<UUID>();
        CompoundTag compound = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compound.m_128437_("players", 11);
        for (Tag player : players) {
            tradedPlayers.add(NbtUtils.m_129233_((Tag)player));
        }
        return tradedPlayers;
    }

    public float getHealthLost() {
        return ((Float)this.m_20088_().m_135370_(HEALTH_LOST)).floatValue();
    }

    public void setHealthLost(float amount) {
        this.m_20088_().m_135381_(HEALTH_LOST, (Object)Float.valueOf(amount));
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntityUmvuthi.canPayFor(stack, this.getDesires());
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntityUmvuthi.canPayFor(input.m_7993_(), desires)) {
            input.m_6201_(desires.m_41613_());
            return true;
        }
        return false;
    }

    public boolean hasTradedWith(Player player) {
        return this.getTradedPlayers().contains(UUIDUtil.m_235875_((GameProfile)player.m_36316_()));
    }

    public void rememberTrade(Player player) {
        UUID uuid = UUIDUtil.m_235875_((GameProfile)player.m_36316_());
        CompoundTag compound = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compound.m_128437_("players", 11);
        players.add((Object)NbtUtils.m_129226_((UUID)uuid));
        compound.m_128365_("players", (Tag)players);
        this.m_20088_().m_135381_(TRADED_PLAYERS, (Object)compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("direction", this.getDirectionData());
        CompoundTag compoundTradedPlayers = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compoundTradedPlayers.m_128437_("players", 11);
        compound.m_128365_("players", (Tag)players);
        compound.m_128405_("HomePosX", this.m_21534_().m_123341_());
        compound.m_128405_("HomePosY", this.m_21534_().m_123342_());
        compound.m_128405_("HomePosZ", this.m_21534_().m_123343_());
        compound.m_128350_("healthLost", this.getHealthLost());
        if (this.getMisbehavedPlayerId() != null) {
            compound.m_128362_("MisbehavedPlayer", this.getMisbehavedPlayerId());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.setDirection(compound.m_128451_("direction"));
        ListTag players = compound.m_128437_("players", 11);
        this.setTradedPlayersCompound(players);
        int i = compound.m_128451_("HomePosX");
        int j = compound.m_128451_("HomePosY");
        int k = compound.m_128451_("HomePosZ");
        this.m_21446_(new BlockPos(i, j, k), -1);
        this.setHealthLost(compound.m_128451_("healthLost"));
        if (compound.m_128403_("MisbehavedPlayer")) {
            uuid = compound.m_128342_("MisbehavedPlayer");
        } else {
            String s = compound.m_128461_("MisbehavedPlayer");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setMisbehavedPlayerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getMisbehavedPlayerId() {
        return ((Optional)this.f_19804_.m_135370_(MISBEHAVED_PLAYER)).orElse(null);
    }

    public void setMisbehavedPlayerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(MISBEHAVED_PLAYER, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getMisbehavedPlayer() {
        try {
            UUID uuid = this.getMisbehavedPlayerId();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
    }

    private int getTimeUntilSunstrike() {
        float damageRatio = 1.0f - this.getHealthRatio();
        if ((double)damageRatio > 0.6) {
            damageRatio = 0.6f;
        }
        return (int)(50.0f - damageRatio / 0.6f * 20.0f);
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{DIE_ABILITY, HURT_ABILITY, BELLY_ABILITY, TALK_ABILITY, SUNSTRIKE_ABILITY, SOLAR_FLARE_ABILITY, SPAWN_ABILITY, SPAWN_SUNBLOCKERS_ABILITY, SOLAR_BEAM_ABILITY, BLESS_ABILITY, SUPERNOVA_ABILITY, ROAR_ABILITY};
    }

    @Override
    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        List<EntityUmvuthana> umvuthana = this.getEntitiesNearby(EntityUmvuthana.class, 30.0, 20.0, 30.0, 30.0);
        for (EntityUmvuthana entityUmvuthana : umvuthana) {
            if (!entityUmvuthana.isUmvuthiDevoted()) continue;
            if (entityUmvuthana instanceof EntityUmvuthanaCrane) {
                ((EntityUmvuthanaCrane)entityUmvuthana).hasTriedOrSucceededTeleport = true;
            }
            entityUmvuthana.timeUntilDeath = this.f_19796_.m_188503_(20);
        }
        super.m_6667_(cause);
    }

    public void setTrading(boolean trading) {
        this.f_19804_.m_135381_(IS_TRADING, (Object)trading);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADING);
    }

    public Player getCustomer() {
        return this.customer;
    }

    public void setCustomer(Player customer) {
        this.setTrading(customer != null);
        this.customer = customer;
    }

    public void openGUI(Player playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null && this.m_6084_()) {
            playerEntity.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new ContainerUmvuthiTrade(id, EntityUmvuthi.this, playerInventory);
                }

                public Component m_5446_() {
                    return EntityUmvuthi.this.m_5446_();
                }
            });
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.canTradeWith(player) && this.m_5448_() == null && this.m_6084_()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canTradeWith(Player player) {
        if (this.isTrading() || this.m_21223_() <= 0.0f) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        return headStack.m_41720_() instanceof UmvuthanaMask;
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.m_41720_() == worth.m_41720_() && stack.m_41613_() >= worth.m_41613_();
    }

    @Override
    public boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.hasBossBar.get();
    }

    @Override
    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.YELLOW;
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.UMVUTHI;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.UMVUTHI.combatConfig;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingData, CompoundTag compound) {
        List<Player> players;
        if (reason == MobSpawnType.SPAWN_EGG && !(players = this.getPlayersNearby(5.0, 5.0, 5.0, 5.0)).isEmpty()) {
            Player closestPlayer = players.get(0);
            float closestPlayerDist = 6.0f;
            for (Player player : players) {
                float thisDist;
                if (player.m_21205_().m_41720_() != ItemHandler.UMVUTHI_SPAWN_EGG.get() && player.m_21205_().m_41720_() != ItemHandler.UMVUTHI_SPAWN_EGG.get() || !((thisDist = this.m_20270_((Entity)player)) < closestPlayerDist)) continue;
                closestPlayer = player;
                closestPlayerDist = thisDist;
            }
            float angle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)closestPlayer) + 225.0f;
            int direction = (int)(angle / 90.0f) % 4 + 1;
            this.setDirection(direction);
        }
        if (reason != MobSpawnType.STRUCTURE) {
            this.m_21446_(this.m_20183_(), -1);
        }
        return super.m_6518_(world, difficulty, reason, livingData, compound);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
        super.m_5997_(0.0, y, 0.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BossMusic getBossMusic() {
        return BossMusicPlayer.UMVUTHI_MUSIC;
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    public boolean resetHealthOnPlayerRespawn() {
        return (Boolean)ConfigHandler.COMMON.MOBS.UMVUTHI.resetHealthWhenRespawn.get();
    }

    public static class SpawnFollowersAbility
    extends Ability<EntityUmvuthi> {
        private boolean spawnSunblockers;
        private static final RawAnimation SPAWN_STRIX_ANIM = RawAnimation.begin().then("spawn_strix", Animation.LoopType.PLAY_ONCE);

        public SpawnFollowersAbility(AbilityType abilityType, EntityUmvuthi user, boolean spawnSunblockers) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11)});
            this.spawnSunblockers = spawnSunblockers;
        }

        @Override
        public void start() {
            super.start();
            ++((EntityUmvuthi)this.getUser()).umvuthanaSpawnCount;
            ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHANA_INHALE.get(), 1.2f, 0.5f);
            this.playAnimation(SPAWN_STRIX_ANIM);
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
            if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHANA_INHALE.get(), 1.2f, 0.5f);
                this.playAnimation(SPAWN_STRIX_ANIM);
            }
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !((EntityUmvuthi)this.getUser()).m_9236_().m_5776_()) {
                EntityUmvuthanaMinion umvuthana;
                entity.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 1.5f, 1.0f);
                entity.m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHANA_BLOWDART.get(), 1.5f, 0.5f);
                double angle = entity.f_20885_;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if (angle - (double)entity.m_146908_() > 70.0) {
                    angle = 70.0f + entity.m_146908_();
                } else if (angle - (double)entity.m_146908_() < -70.0) {
                    angle = -70.0f + entity.m_146908_();
                }
                if (this.spawnSunblockers) {
                    umvuthana = new EntityUmvuthanaCrane((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_CRANE.get()), entity.m_9236_());
                    ((EntityUmvuthanaCrane)umvuthana).hasTriedOrSucceededTeleport = false;
                } else {
                    umvuthana = new EntityUmvuthanaMinion((EntityType<? extends EntityUmvuthanaMinion>)((EntityType)EntityHandler.UMVUTHANA_MINION.get()), entity.m_9236_());
                }
                umvuthana.m_19890_(entity.m_20185_() + 2.0 * Math.sin(-angle * (Math.PI / 180)), entity.m_20186_() + 2.5, entity.m_20189_() + 2.0 * Math.cos(-angle * (Math.PI / 180)), entity.f_20885_, 0.0f);
                umvuthana.setActive(false);
                umvuthana.active = false;
                umvuthana.m_6518_((ServerLevelAccessor)entity.m_20193_(), entity.m_9236_().m_6436_(umvuthana.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                umvuthana.m_21446_(entity.m_21534_(), 25);
                if (entity.m_5647_() instanceof PlayerTeam) {
                    umvuthana.m_9236_().m_6188_().m_6546_(umvuthana.m_6302_(), (PlayerTeam)entity.m_5647_());
                }
                entity.m_9236_().m_7967_((Entity)umvuthana);
                umvuthana.m_20334_(0.7 * Math.sin(-angle * (Math.PI / 180)), 0.5, 0.7 * Math.cos(-angle * (Math.PI / 180)));
                if (!this.spawnSunblockers) {
                    umvuthana.m_6710_(entity.m_5448_());
                    if (entity.m_5448_() instanceof Player) {
                        umvuthana.setMisbehavedPlayerId(entity.m_5448_().m_20148_());
                    }
                }
            }
        }

        @Override
        protected void endSection(AbilitySection section) {
            super.endSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY && ((EntityUmvuthi)this.getUser()).targetDistance <= 6.0f && ((EntityUmvuthi)this.getUser()).m_5448_() != null && !this.spawnSunblockers) {
                this.interrupt();
            }
        }
    }

    public static class SupernovaAbility
    extends Ability<EntityUmvuthi> {
        public static AbilitySection[] SECTION_TRACK = new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 44), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 40), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 16)};
        private static final RawAnimation SUPERNOVA_ANIM = RawAnimation.begin().then("supernova", Animation.LoopType.PLAY_ONCE);
        private static final ParticleComponent.KeyTrack superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 25.0f, 32.0f, 0.0f}, new float[]{0.0f, 0.6f, 0.85f, 1.0f});
        private static final ParticleComponent.KeyTrack superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 7.0f, 24);

        public SupernovaAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, SECTION_TRACK);
        }

        @Override
        public void start() {
            super.start();
            ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_START.get(), 3.0f, 1.0f);
            this.playAnimation(SUPERNOVA_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 30) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_BLACKHOLE.get(), 2.0f, 1.2f);
            }
            if (this.getTicksInUse() < 30) {
                List<LivingEntity> entities = ((EntityUmvuthi)this.getUser()).getEntityLivingBaseNearby(16.0, 16.0, 16.0, 16.0);
                for (LivingEntity inRange : entities) {
                    if (inRange instanceof LeaderSunstrikeImmune || inRange instanceof Player && ((Player)inRange).m_150110_().f_35934_) continue;
                    Vec3 diff = inRange.m_20182_().m_82546_(((EntityUmvuthi)this.getUser()).m_20182_().m_82520_(0.0, 3.0, 0.0));
                    diff = diff.m_82541_().m_82490_(0.03);
                    inRange.m_20256_(inRange.m_20184_().m_82546_(diff));
                    if (!(inRange.m_20186_() < ((EntityUmvuthi)this.getUser()).m_20186_() + 3.0)) continue;
                    inRange.m_20256_(inRange.m_20184_().m_82520_(0.0, 0.075, 0.0));
                }
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntityUmvuthi)this.getUser()).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2, 1, false, false));
            }
            if (this.getTicksInUse() == 40) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_ROAR.get(), 3.0f, 1.0f);
            }
            if (this.getLevel().f_46443_) {
                SupernovaAbility.superNovaEffects(this, ((EntityUmvuthi)this.getUser()).betweenHandPos, this.getLevel());
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && !((EntityUmvuthi)this.getUser()).m_9236_().f_46443_) {
                Vec3 offset = new Vec3((double)1.1f, 0.0, 0.0);
                offset = offset.m_82524_((float)Math.toRadians(-((EntityUmvuthi)this.getUser()).m_146908_() - 90.0f));
                EntitySuperNova superNova = new EntitySuperNova((EntityType<? extends EntitySuperNova>)((EntityType)EntityHandler.SUPER_NOVA.get()), ((EntityUmvuthi)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), ((EntityUmvuthi)this.getUser()).m_20185_() + offset.f_82479_, ((EntityUmvuthi)this.getUser()).m_20186_() + 0.05, ((EntityUmvuthi)this.getUser()).m_20189_() + offset.f_82481_);
                ((EntityUmvuthi)this.getUser()).m_9236_().m_7967_((Entity)superNova);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void superNovaEffects(Ability activeAbility, Vec3[] pinLocation, Level level) {
            double value;
            int i;
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            if (clientPlayer == null) {
                return;
            }
            double distToCaster = activeAbility.getUser().m_20182_().m_82557_(clientPlayer.m_20182_());
            if (distToCaster < 1000.0) {
                Minecraft.m_91087_().f_91063_.f_109068_ += 0.06f;
                if (Minecraft.m_91087_().f_91063_.f_109068_ > 1.0f) {
                    Minecraft.m_91087_().f_91063_.f_109068_ = 1.0f;
                }
            }
            if (pinLocation == null || pinLocation.length == 0 || pinLocation[0] == null) {
                return;
            }
            int ticksInUse = activeAbility.getTicksInUse();
            Object user = activeAbility.getUser();
            RandomSource random = user.m_217043_();
            if (ticksInUse == 1) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 33.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack1, false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack2, true)});
            }
            if (ticksInUse == 33) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN_NOVA.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 1.0, 1.0, 1.0, 0.0, 1.0, 13.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{11.0f, 7.0f, 5.5f, 1.0f, 30.0f}, new float[]{0.0f, 0.15f, 0.8f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.15f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.PARTICLE_ANGLE, ParticleComponent.KeyTrack.startAndEnd(0.0f, -6.0f), false)});
            }
            if (ticksInUse == 32) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 0.7, 1.0, 3.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.15f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 22.0f, 0.0f}, new float[]{0.0f, 0.2f, 1.0f}), false)});
            }
            if (ticksInUse > 30 && ticksInUse < 41) {
                for (i = 0; i < 6; ++i) {
                    float phaseOffset = random.m_188501_();
                    value = random.m_188500_() * 0.3 + 0.05;
                    AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), pinLocation[0].f_82479_, pinLocation[0].f_82480_, pinLocation[0].f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 6.0, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.0f}, new float[]{0.0f, 0.2f}), false), new ParticleComponent.Orbit(pinLocation, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, -0.4f + phaseOffset), ParticleComponent.KeyTrack.startAndEnd(0.5f + random.m_188501_(), 0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), true)});
                }
            }
            if (ticksInUse > 1 && ticksInUse < 27) {
                for (i = 0; i < 6; ++i) {
                    Vec3 particlePos = new Vec3((double)(random.m_188501_() * 5.0f), 0.0, 0.0);
                    particlePos = particlePos.m_82524_((float)((double)(random.m_188501_() * 2.0f) * Math.PI));
                    particlePos = particlePos.m_82496_((float)((double)(random.m_188501_() * 2.0f) * Math.PI));
                    particlePos = particlePos.m_82549_(pinLocation[0]);
                    value = random.m_188500_() * 0.5 + 0.1;
                    AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 7.0, false, true, new ParticleComponent[]{new ParticleComponent.Attractor(pinLocation, 1.1f, 1.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.5f}, new float[]{0.0f, 0.2f}), false)});
                }
            }
            float timeFrac = Math.min((float)ticksInUse / 20.0f, 1.0f);
            if (ticksInUse > 1 && ticksInUse < 25 && ticksInUse % (int)(4.0f * (1.0f - timeFrac) + 1.0f) == 0) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_SPARKS.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, random.m_188501_() * (float)Math.PI * 2.0f, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 6.0f + random.m_188501_() * 3.0f, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f + 20.0f * timeFrac * timeFrac + 10.0f * random.m_188501_() * timeFrac, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false)});
            }
            if (ticksInUse == 14) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 18.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.1f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 35.0f, 0.0f}, new float[]{0.0f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-5.0f, 5.0f, 42.0f, 0.0f), true)});
            }
            if (ticksInUse == 32) {
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BURST_IN.get()), user.m_20185_(), user.m_20186_(), user.m_20189_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(pinLocation), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(25.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-2.0f, 2.0f, 42.0f, 0.0f), true)});
            }
            if (ticksInUse == 44) {
                float scale = 85.0f;
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_BIG.get()), pinLocation[0].f_82479_, pinLocation[0].f_82480_, pinLocation[0].f_82481_, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
                scale = 120.0f;
                AdvancedParticleBase.spawnParticle(level, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), pinLocation[0].f_82479_, pinLocation[0].f_82480_, pinLocation[0].f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 0.95, 0.9, 0.35, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
            }
        }
    }

    public static class SolarFlareAbility
    extends Ability<EntityUmvuthi> {
        public static AbilitySection[] SECTION_TRACK = new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 12), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 18)};
        private static final RawAnimation FLARE_ANIM = RawAnimation.begin().then("flare", Animation.LoopType.PLAY_ONCE);

        public SolarFlareAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, SECTION_TRACK);
        }

        @Override
        public void start() {
            super.start();
            ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_BURST.get(), 1.7f, 1.5f);
            this.playAnimation(FLARE_ANIM);
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
                float radius = 4.0f;
                List<LivingEntity> hit = entity.getEntityLivingBaseNearby(radius, 2.0f * radius, radius, radius);
                for (LivingEntity aHit : hit) {
                    if (aHit instanceof LeaderSunstrikeImmune) continue;
                    entity.doHurtTarget((Entity)aHit, 1.0f, 3.0f);
                    if (aHit.m_20147_() || aHit instanceof Player && ((Player)aHit).m_150110_().f_35934_) continue;
                    double knockback = 3.0;
                    double angle = entity.getAngleBetweenEntities((Entity)entity, (Entity)aHit);
                    double x = knockback * Math.cos(Math.toRadians(angle - 90.0));
                    double z = knockback * Math.sin(Math.toRadians(angle - 90.0));
                    aHit.m_20334_(x, 0.3, z);
                    if (!(aHit instanceof ServerPlayer)) continue;
                    ((ServerPlayer)aHit).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)aHit));
                }
            }
        }
    }

    public static class SolarBeamAbility
    extends Ability<EntityUmvuthi> {
        protected LivingEntity entityTarget;
        private EntitySolarBeam solarBeam;
        private static final RawAnimation SOLAR_BEAM_ANIM = RawAnimation.begin().then("solar_beam", Animation.LoopType.PLAY_ONCE);

        public SolarBeamAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 22), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 68), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 10)});
        }

        @Override
        public void start() {
            super.start();
            this.entityTarget = ((EntityUmvuthi)this.getUser()).m_5448_();
            this.playAnimation(SOLAR_BEAM_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            float radius1 = 0.8f;
            EntityUmvuthi entity = (EntityUmvuthi)this.getUser();
            if (this.getTicksInUse() == 4 && !entity.m_9236_().f_46443_) {
                this.solarBeam = new EntitySolarBeam((EntityType<? extends EntitySolarBeam>)((EntityType)EntityHandler.SOLAR_BEAM.get()), ((EntityUmvuthi)this.getUser()).m_9236_(), (LivingEntity)entity, entity.m_20185_() + (double)radius1 * Math.sin((double)(-entity.m_146908_()) * Math.PI / 180.0), entity.m_20186_() + 1.4, entity.m_20189_() + (double)radius1 * Math.cos((double)(-entity.m_146908_()) * Math.PI / 180.0), (float)((double)(entity.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-entity.m_146909_()) * Math.PI / 180.0), 55);
                entity.m_9236_().m_7967_((Entity)this.solarBeam);
            }
            if (this.getTicksInUse() >= 22 && this.entityTarget != null) {
                entity.m_21563_().m_24950_(this.entityTarget.m_20185_(), this.entityTarget.m_20186_() + (double)(this.entityTarget.m_20206_() / 2.0f), this.entityTarget.m_20189_(), 2.0f, 90.0f);
            }
        }
    }

    public static class SunstrikeAbility
    extends Ability<EntityUmvuthi> {
        private static int STARTUP_DURATION = 9;
        protected LivingEntity entityTarget;
        public double prevX;
        public double prevZ;
        private int newX;
        private int newZ;
        private int y;
        private static final RawAnimation SUN_STRIKE_ANIM = RawAnimation.begin().then("sun_strike", Animation.LoopType.PLAY_ONCE);

        public SunstrikeAbility(AbilityType abilityType, EntityUmvuthi user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, STARTUP_DURATION), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 12)});
        }

        @Override
        public void start() {
            super.start();
            this.entityTarget = ((EntityUmvuthi)this.getUser()).m_5448_();
            if (this.entityTarget != null) {
                this.prevX = this.entityTarget.m_20185_();
                this.prevZ = this.entityTarget.m_20189_();
            }
            this.playAnimation(SUN_STRIKE_ANIM);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (!((EntityUmvuthi)this.getUser()).m_9236_().m_5776_()) {
                if (this.entityTarget == null) {
                    return;
                }
                if (this.getTicksInUse() == STARTUP_DURATION - 2) {
                    double dz;
                    double x = this.entityTarget.m_20185_();
                    this.y = Mth.m_14107_((double)(this.entityTarget.m_20186_() - 1.0));
                    double z = this.entityTarget.m_20189_();
                    double vx = (x - this.prevX) / (double)STARTUP_DURATION;
                    double vz = (z - this.prevZ) / (double)STARTUP_DURATION;
                    int t = 38;
                    this.newX = Mth.m_14107_((double)(x + vx * (double)t));
                    this.newZ = Mth.m_14107_((double)(z + vz * (double)t));
                    double dx = (double)this.newX - ((EntityUmvuthi)this.getUser()).m_20185_();
                    double dist2ToUmvuthi = dx * dx + (dz = (double)this.newZ - ((EntityUmvuthi)this.getUser()).m_20189_()) * dz;
                    if (dist2ToUmvuthi < 3.0) {
                        this.newX = Mth.m_14107_((double)this.entityTarget.m_20185_());
                        this.newZ = Mth.m_14107_((double)this.entityTarget.m_20189_());
                    }
                    for (int i = 0; i < 5 && !((EntityUmvuthi)this.getUser()).m_9236_().m_46861_(new BlockPos(this.newX, this.y, this.newZ)); ++i) {
                        ++this.y;
                    }
                }
                if (this.getTicksInUse() < STARTUP_DURATION - 2) {
                    ((EntityUmvuthi)this.getUser()).m_21563_().m_24960_((Entity)this.entityTarget, 30.0f, 30.0f);
                }
                if (this.getTicksInUse() >= STARTUP_DURATION - 2) {
                    ((EntityUmvuthi)this.getUser()).m_21563_().m_24950_((double)this.newX, (double)((float)this.y + this.entityTarget.m_20192_()), (double)this.newZ, 50.0f, 50.0f);
                }
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (!((EntityUmvuthi)this.getUser()).m_9236_().m_5776_() && section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                ((EntityUmvuthi)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_UMVUTHI_ATTACK.get(), 1.4f, 1.0f);
                EntitySunstrike sunstrike = new EntitySunstrike((EntityType<? extends EntitySunstrike>)((EntityType)EntityHandler.SUNSTRIKE.get()), ((EntityUmvuthi)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), this.newX, this.y, this.newZ);
                sunstrike.onSummon();
                ((EntityUmvuthi)this.getUser()).m_9236_().m_7967_((Entity)sunstrike);
            }
        }
    }
}

