/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissure;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissurePiece;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderFissurePiece
extends EntityRenderer<EntityFissurePiece> {
    private static final ResourceLocation TEXTURE0 = new ResourceLocation("mowziesmobs", "textures/particle/crack_0.png");
    private static final ResourceLocation TEXTURE1 = new ResourceLocation("mowziesmobs", "textures/particle/crack_1.png");
    private static final ResourceLocation TEXTURE2 = new ResourceLocation("mowziesmobs", "textures/particle/crack_2.png");
    private static final ResourceLocation TEXTURE3 = new ResourceLocation("mowziesmobs", "textures/particle/crack_3.png");
    private static final ResourceLocation TEXTURE4 = new ResourceLocation("mowziesmobs", "textures/particle/crack_4.png");
    private static final ResourceLocation TEXTURE5 = new ResourceLocation("mowziesmobs", "textures/particle/crack_5.png");
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{TEXTURE0, TEXTURE1, TEXTURE2, TEXTURE3, TEXTURE4, TEXTURE5};
    private static final float SPRITE_SCALE = 2.0f;
    private static final double DISTANCE_THRESHOLD = 1.0E-4;

    public RenderFissurePiece(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(EntityFissurePiece entity) {
        int fullGrownTick = EntityFissure.TICKS_PER_PIECE;
        if (entity.getGrowTick() < fullGrownTick) {
            int whichTex = (int)(5.0 * (double)entity.getGrowTick() / (double)fullGrownTick);
            return TEXTURES[whichTex];
        }
        return TEXTURE5;
    }

    private static OptionalDouble max(double ... v) {
        return Arrays.stream(v).max();
    }

    public void render(EntityFissurePiece entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Vec3 corner0 = new Vec3(-1.0, 0.0, -1.0).m_82524_(entityYaw);
        Vec3 corner1 = new Vec3(1.0, 0.0, 1.0).m_82524_(entityYaw);
        double extent = RenderFissurePiece.max(corner0.m_7096_(), corner1.m_7096_(), corner0.m_7094_(), corner1.m_7094_()).orElse(1.0);
        Vec3 minCorner = new Vec3(-extent, -1.0, -extent).m_82520_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_());
        Vec3 maxCorner = new Vec3(extent, 1.0, extent).m_82520_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_());
        matrixStackIn.m_85836_();
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entityIn)));
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)minCorner), (BlockPos)BlockPos.m_274446_((Position)maxCorner))) {
            BlockState block = entityIn.m_9236_().m_8055_(blockpos.m_7495_());
            RenderFissurePiece.renderBlockDecal(entityIn, entityIn.m_9236_(), block, blockpos, entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), matrixStackIn, ivertexbuilder, packedLightIn);
        }
        matrixStackIn.m_85849_();
    }

    private static Vec2 rotateVec2(Vec2 v, float angle) {
        return new Vec2(v.f_82470_ * (float)Math.cos(angle) - v.f_82471_ * (float)Math.sin(angle), v.f_82470_ * (float)Math.sin(angle) + v.f_82471_ * (float)Math.cos(angle));
    }

    public static Vec3 Vec3WithAxis(double axis1, double axis2, Direction.Axis axis1Dir) {
        Vec3 v = new Vec3(0.0, 0.0, 0.0);
        if (axis1Dir == Direction.Axis.X) {
            v.m_82520_(axis1, 0.0, axis2);
        } else {
            v.m_82520_(axis2, 0.0, axis1);
        }
        return v;
    }

    public static Optional<Vec2> getLineSegmentIntersection(BlockPos pos, Direction whichBorder, Vec3 segmentP, Vec3 segmentQ) {
        Vec3 intersect;
        Direction.Axis perp;
        if (whichBorder.m_122434_().m_122478_()) {
            return Optional.empty();
        }
        Direction.Axis axis = whichBorder.m_122427_().m_122434_();
        Vec3 segmentVec = segmentQ.m_82546_(segmentP);
        if (segmentVec.m_82507_(perp = whichBorder.m_122434_()) == 0.0) {
            return Optional.empty();
        }
        whichBorder.m_253071_();
        Vec3 colliderCenter = pos.m_252807_().m_82520_((double)whichBorder.m_122429_() / 2.0, (double)whichBorder.m_122430_() / 2.0, (double)whichBorder.m_122431_() / 2.0);
        double segmentPos = colliderCenter.m_82507_(perp);
        if (segmentVec.m_82507_(axis) == 0.0) {
            intersect = RenderFissurePiece.Vec3WithAxis(segmentP.m_82507_(axis), segmentPos, axis);
        } else {
            double slope = segmentVec.m_82507_(perp) / segmentVec.m_82507_(axis);
            double intercept = segmentP.m_82507_(perp) - slope * segmentP.m_82507_(axis);
            double intersectAxis = (segmentPos - intercept) / slope;
            intersect = RenderFissurePiece.Vec3WithAxis(intersectAxis, segmentPos, axis);
        }
        double distanceFromBall = intersect.m_82546_(segmentP).m_82553_();
        if (distanceFromBall <= 1.0E-4) {
            return Optional.empty();
        }
        if (Math.abs(intersect.m_82507_(axis) - colliderCenter.m_82507_(axis)) > 0.5) {
            return Optional.empty();
        }
        double dot = intersect.m_82546_(segmentP).m_82526_(segmentVec);
        if (dot < 0.0 || dot > segmentVec.m_82526_(segmentVec)) {
            return Optional.empty();
        }
        return Optional.of(new Vec2((float)intersect.f_82479_, (float)intersect.f_82481_));
    }

    public static Vec2 getRelativeCornerPos(Vec2 corner, float rotation) {
        return RenderFissurePiece.rotateVec2(corner, (float)(-Math.toRadians(rotation + 180.0f)));
    }

    public static Vec2 getRelativeUVs(Vec2 corner, float rotation) {
        Vec2 relativeCorner = RenderFissurePiece.rotateVec2(corner, (float)(-Math.toRadians(rotation + 180.0f)));
        return new Vec2(relativeCorner.f_82470_ / 4.0f + 0.5f, relativeCorner.f_82471_ / 4.0f + 0.5f);
    }

    private static void renderBlockDecal(EntityFissurePiece entity, Level level, BlockState blockstate, BlockPos blockpos, double x, double y, double z, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        float alpha;
        VoxelShape voxelshape;
        PoseStack.Pose matrixstack$entry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        Vec2 center = new Vec2((float)x, (float)z);
        double ex = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_);
        double ey = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_);
        double ez = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE && blockstate.m_60838_((BlockGetter)level, blockpos) && !level.m_8055_(blockpos).m_60838_((BlockGetter)level, blockpos) && !(voxelshape = blockstate.m_60808_((BlockGetter)level, blockpos)).m_83281_() && (alpha = 1.0f) >= 0.0f) {
            Vec2[] corners;
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            double rad2 = Math.sqrt(1.0);
            double minX = -2.0 * rad2;
            double minZ = -2.0 * rad2;
            double maxX = 2.0 * rad2;
            double maxZ = 2.0 * rad2;
            AABB aabb = voxelshape.m_83215_();
            float d0 = (float)blockpos.m_123341_() + (float)(aabb.f_82288_ - ex);
            float d1 = (float)blockpos.m_123341_() + (float)(aabb.f_82291_ - ex);
            float d2 = (float)blockpos.m_123342_() + (float)(aabb.f_82289_ - ey) + 0.0015625f;
            float d3 = (float)blockpos.m_123343_() + (float)(aabb.f_82290_ - ez);
            float d4 = (float)blockpos.m_123343_() + (float)(aabb.f_82293_ - ez);
            if ((double)d0 < minX) {
                d0 = (float)minX;
            }
            if ((double)d1 > maxX) {
                d1 = (float)maxX;
            }
            if ((double)d3 < minZ) {
                d3 = (float)minZ;
            }
            if ((double)d4 > maxZ) {
                d4 = (float)maxZ;
            }
            for (Vec2 corner : corners = new Vec2[]{new Vec2(d0, d3), new Vec2(d1, d3), new Vec2(d1, d4), new Vec2(d0, d4)}) {
                Vec2 uv = RenderFissurePiece.getRelativeUVs(corner, entity.m_146908_());
                RenderFissurePiece.drawVertex(matrix4f, matrix3f, builder, corner.f_82470_, d2, corner.f_82471_, uv.f_82470_, uv.f_82471_, 0.65f, packedLightIn);
            }
            Direction[] directions = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH};
            for (int i = 0; i < corners.length; ++i) {
                Direction direction = directions[i];
                BlockPos overAndDown = blockpos.m_121945_(direction).m_6625_(2);
                if (!level.m_8055_(overAndDown).m_60838_((BlockGetter)level, overAndDown)) continue;
                Vec2 corner = corners[i];
                Vec2 uv = RenderFissurePiece.getRelativeUVs(corner, entity.m_146908_());
                int prevIndex = i == 0 ? 3 : i - 1;
                Vec2 prevCorner = corners[prevIndex];
                Vec2 prevUv = RenderFissurePiece.getRelativeUVs(prevCorner, entity.m_146908_());
                Vector3f offset = direction.m_253071_().mul(0.0015625f);
                RenderFissurePiece.drawVertex(matrix4f, matrix3f, builder, prevCorner.f_82470_ + offset.x(), d2, prevCorner.f_82471_ + offset.z(), prevUv.f_82470_, prevUv.f_82471_, 0.65f, packedLightIn);
                RenderFissurePiece.drawVertex(matrix4f, matrix3f, builder, corner.f_82470_ + offset.x(), d2, corner.f_82471_ + offset.z(), uv.f_82470_, uv.f_82471_, 0.65f, packedLightIn);
                RenderFissurePiece.drawVertex(matrix4f, matrix3f, builder, corner.f_82470_ + offset.x(), d2 - 1.0f, corner.f_82471_ + offset.z(), uv.f_82470_, uv.f_82471_, 0.65f, packedLightIn);
                RenderFissurePiece.drawVertex(matrix4f, matrix3f, builder, prevCorner.f_82470_ + offset.x(), d2 - 1.0f, prevCorner.f_82471_ + offset.z(), prevUv.f_82470_, prevUv.f_82471_, 0.65f, packedLightIn);
            }
        }
    }

    public static void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(0.0f, 0.0f, 0.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

