/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TerrainParticleData
extends AdvancedParticleData {
    public static final ParticleOptions.Deserializer<TerrainParticleData> DESERIALIZER = new ParticleOptions.Deserializer<TerrainParticleData>(){

        public TerrainParticleData fromCommand(ParticleType<TerrainParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double airDrag = reader.readDouble();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            double angle = reader.readDouble();
            reader.expect(' ');
            double duration = reader.readDouble();
            reader.expect(' ');
            BlockState blockState = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)reader, (boolean)false).f_234748_();
            reader.expect(' ');
            return new TerrainParticleData(particleTypeIn, angle, scale, airDrag, duration, blockState);
        }

        public TerrainParticleData fromNetwork(ParticleType<TerrainParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            double airDrag = buffer.readFloat();
            double scale = buffer.readFloat();
            double angle = buffer.readFloat();
            double duration = buffer.readFloat();
            BlockState state = (BlockState)buffer.m_236816_((IdMap)Block.f_49791_);
            return new TerrainParticleData(particleTypeIn, angle, scale, airDrag, duration, state);
        }
    };
    private final BlockState state;
    private BlockPos pos;

    public TerrainParticleData(ParticleType<? extends TerrainParticleData> type, double rotation, double scale, double drag, double duration, BlockState state) {
        this(type, rotation, scale, drag, duration, state, new ParticleComponent[0]);
    }

    public TerrainParticleData(ParticleType<? extends TerrainParticleData> type, double angle, double scale, double drag, double duration, BlockState state, ParticleComponent[] components) {
        super(type, new ParticleRotation.EulerAngles((float)angle, 0.0f, 0.0f), scale, 1.0, 1.0, 1.0, 1.0, drag, duration, false, true, components);
        this.state = state;
    }

    @Override
    public void m_7711_(FriendlyByteBuf buffer) {
        super.m_7711_(buffer);
        buffer.m_236818_((IdMap)Block.f_49791_, (Object)this.state);
    }

    @Override
    public String m_5942_() {
        return super.m_5942_() + " " + BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()) + " " + BlockStateParser.m_116769_((BlockState)this.state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getAngle() {
        if (this.getRotation() instanceof ParticleRotation.EulerAngles) {
            return ((ParticleRotation.EulerAngles)this.getRotation()).yaw;
        }
        return 0.0;
    }

    public BlockState getState() {
        return this.state;
    }

    public static Codec<TerrainParticleData> CODEC_TERRAIN(ParticleType<TerrainParticleData> particleType) {
        return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(AdvancedParticleData::getScale), (App)Codec.DOUBLE.fieldOf("drag").forGetter(AdvancedParticleData::getAirDrag), (App)Codec.DOUBLE.fieldOf("duration").forGetter(AdvancedParticleData::getDuration), (App)Codec.DOUBLE.fieldOf("angle").forGetter(TerrainParticleData::getAngle), (App)BlockState.f_61039_.fieldOf("state").forGetter(TerrainParticleData::getState)).apply((Applicative)codecBuilder, (scale, drag, duration, angle, state) -> new TerrainParticleData((ParticleType<? extends TerrainParticleData>)particleType, (double)angle, (double)scale, (double)drag, (double)duration, (BlockState)state, new ParticleComponent[0])));
    }

    public TerrainParticleData setPos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

