/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.chillout.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.chillout.ChilloutMod;
import net.mcreator.chillout.procedures.CrisscrossProcedure;
import net.mcreator.chillout.procedures.LegstosideProcedure;
import net.mcreator.chillout.procedures.SitCurledProcedure;
import net.mcreator.chillout.procedures.SitOnkneesProcedure;
import net.mcreator.chillout.procedures.SitProcedure;
import net.mcreator.chillout.procedures.SitrelaxedProcedure;
import net.mcreator.chillout.world.inventory.SittingMenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SittingMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SittingMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SittingMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SittingMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SittingMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SittingMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SittingMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SitProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            SitrelaxedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            SitCurledProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            SitOnkneesProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            LegstosideProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            CrisscrossProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ChilloutMod.addNetworkMessage(SittingMenuButtonMessage.class, SittingMenuButtonMessage::buffer, SittingMenuButtonMessage::new, SittingMenuButtonMessage::handler);
    }
}

