/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.block.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.Pandarix.betterarcheology.block.custom.ArchelogyTable;
import net.Pandarix.betterarcheology.block.entity.ModBlockEntities;
import net.Pandarix.betterarcheology.item.ModItems;
import net.Pandarix.betterarcheology.networking.ModMessages;
import net.Pandarix.betterarcheology.networking.packet.ItemStackSyncS2CPacket;
import net.Pandarix.betterarcheology.screen.IdentifyingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcheologyTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int INV_SIZE = 3;
    public static final int PROPERTY_DELEGATES = 2;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ArcheologyTableBlockEntity.this.m_6596_();
            if (ArcheologyTableBlockEntity.this.f_58857_ != null && !ArcheologyTableBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new ItemStackSyncS2CPacket(this, ArcheologyTableBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final String translationKey = "archeology_table";
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ArcheologyTableBlockEntity.this.progress;
                case 1 -> ArcheologyTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ArcheologyTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ArcheologyTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private static final ResourceLocation CRAFTING_LOOT = new ResourceLocation("betterarcheology", "identifying_loot");

    public ArcheologyTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ARCHEOLOGY_TABLE.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)new ResourceLocation("block.betterarcheology", "archeology_table").m_214298_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    @ParametersAreNonnullByDefault
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void drops() {
        if (this.f_58857_ != null) {
            SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
            }
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new IdentifyingMenu(id, inventory, this, this.data);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, ArcheologyTableBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (ArcheologyTableBlockEntity.hasRecipe(entity)) {
            if (entity.progress % 10 == 0) {
                world.m_5594_(null, entity.f_58858_, SoundEvents.f_276624_, SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ArchelogyTable.DUSTING, (Comparable)Boolean.valueOf(true)), 3);
            ++entity.progress;
            ArcheologyTableBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)blockState);
            if (entity.progress >= entity.maxProgress) {
                entity.craftItem();
            }
        } else {
            world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ArchelogyTable.DUSTING, (Comparable)Boolean.valueOf(false)), 3);
            entity.resetProgress();
            ArcheologyTableBlockEntity.m_155232_((Level)world, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    private void craftItem() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (ArcheologyTableBlockEntity.hasRecipe(this) && this.itemHandler.getStackInSlot(2).m_41619_()) {
            ItemStack stack = this.itemHandler.getStackInSlot(1);
            stack.m_41774_(1);
            this.itemHandler.setStackInSlot(1, stack);
            ItemStack brush = this.itemHandler.getStackInSlot(0);
            int newDamage = brush.m_41773_() + 1;
            if (newDamage > brush.m_41776_()) {
                ItemStack brushStack = this.itemHandler.getStackInSlot(0);
                brushStack.m_41774_(1);
                this.itemHandler.setStackInSlot(0, brushStack);
                assert (this.f_58857_ != null);
                if (!this.f_58857_.m_5776_()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.25f, 1.0f);
                }
            } else {
                brush.m_41721_(newDamage);
            }
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_271452_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            this.itemHandler.setStackInSlot(2, this.generateCraftingLoot(this, this.f_58857_));
            this.resetProgress();
            this.m_6596_();
        }
    }

    private ItemStack generateCraftingLoot(BlockEntity entity, Level level) {
        if (level != null && !level.m_5776_() && level.m_7654_() != null) {
            LootParams lootparams;
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(CRAFTING_LOOT);
            ObjectArrayList objectArrayList = lootTable.m_287214_(lootparams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)entity.m_58899_())).m_287239_(0.0f).m_287235_(LootContextParamSets.f_81411_), level.f_46441_.m_188505_());
            if (objectArrayList.isEmpty()) {
                return ItemStack.f_41583_;
            }
            if (objectArrayList.size() == 1) {
                return (ItemStack)objectArrayList.get(0);
            }
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasRecipe(ArcheologyTableBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasShardInFirstSlot = entity.itemHandler.getStackInSlot(1).m_150930_((Item)ModItems.UNIDENTIFIED_ARTIFACT.get());
        Item itemInSlot0 = entity.itemHandler.getStackInSlot(0).m_41720_();
        boolean hasBrushInSlot = itemInSlot0 instanceof BrushItem;
        return hasShardInFirstSlot && hasBrushInSlot && ArcheologyTableBlockEntity.canInsertAmountIntoOutputSlot(entity.itemHandler) && ArcheologyTableBlockEntity.canInsertItemIntoOutputSlot(entity.itemHandler, entity.itemHandler.getStackInSlot(2).m_41720_());
    }

    public boolean canExtract(int slot, ItemStack stack, Direction side) {
        return side == Direction.DOWN && slot == 2;
    }

    public boolean canInsert(int slot, ItemStack stack, @Nullable Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        if (side == Direction.UP) {
            return slot == 0 && stack.m_41720_() instanceof BrushItem;
        }
        return slot == 1 && stack.m_150930_((Item)ModItems.UNIDENTIFIED_ARTIFACT.get());
    }

    private static boolean canInsertItemIntoOutputSlot(ItemStackHandler handler, Item output) {
        return handler.getStackInSlot(2).m_41720_() == output || handler.getStackInSlot(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(ItemStackHandler handler) {
        return handler.getStackInSlot(2).m_41741_() > handler.getStackInSlot(2).m_41613_();
    }

    public List<ItemStack> getInventoryContents() {
        return Arrays.asList(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

