/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import dev.shadowsoffire.gateways.GatewayEvents;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import dev.shadowsoffire.gateways.net.ParticleMessage;
import dev.shadowsoffire.placebo.network.MessageHelper;
import dev.shadowsoffire.placebo.network.MessageProvider;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gateways")
public class Gateways {
    public static final String MODID = "gateways";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gateways to Eternity");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gateways", "channel")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();

    public Gateways() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)0, (MessageProvider)new ParticleMessage.Provider());
        MinecraftForge.EVENT_BUS.register((Object)new GatewayEvents());
        GatewayObjects.bootstrap();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        GatewayRegistry.INSTANCE.registerToBus();
        e.enqueueWork(() -> {
            WaveModifier.initSerializers();
            Reward.initSerializers();
            WaveEntity.initSerializers();
            Failure.initSerializers();
            ApplicationMode.initSerializers();
            TabFillingRegistry.register(GatewayObjects.TAB_KEY, (Supplier[])new Supplier[]{GatewayObjects.GATE_PEARL});
            Stats.f_12988_.m_12899_((Object)((ResourceLocation)GatewayObjects.GATES_DEFEATED.get()), StatFormatter.f_12873_);
        });
    }

    public static ResourceLocation loc(String s) {
        return new ResourceLocation(MODID, s);
    }
}

