/*
 * Decompiled with CFR 0.152.
 */
package tfar.quickstack.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import tfar.quickstack.client.RendererCubeTarget;
import tfar.quickstack.config.DropOffConfig;
import tfar.quickstack.networking.PacketBufferExt;
import tfar.quickstack.networking.PacketHandler;
import tfar.quickstack.networking.S2CReportPacket;
import tfar.quickstack.util.ItemStackUtils;
import tfar.quickstack.util.SuccedableInventoryData;

public class C2SPacketRequestDropoff {
    private boolean ignoreHotbar;
    private boolean dump;
    private List<BlockEntityType<?>> teTypes = new ArrayList();
    private int minSlotCount;
    private int itemsCounter;

    public C2SPacketRequestDropoff() {
    }

    public C2SPacketRequestDropoff(FriendlyByteBuf buf) {
        buf = new PacketBufferExt(buf);
        this.ignoreHotbar = buf.readBoolean();
        this.dump = buf.readBoolean();
        this.teTypes = ((PacketBufferExt)buf).readRegistryIdArray();
        this.minSlotCount = buf.readInt();
    }

    public C2SPacketRequestDropoff(boolean ignoreHotbar, boolean dump, List<BlockEntityType<?>> teTypes, int minSlotCount) {
        this.ignoreHotbar = ignoreHotbar;
        this.dump = dump;
        this.teTypes = teTypes;
        this.minSlotCount = minSlotCount;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Set<SuccedableInventoryData> nearbyInventories = this.getNearbyInventories(player);
            nearbyInventories.forEach(inventoryData -> inventoryData.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(target -> {
                if (this.dump) {
                    this.dropOff((Player)player, (IItemHandler)target, (SuccedableInventoryData)inventoryData);
                } else {
                    this.dropOffExisting((Player)player, (IItemHandler)target, (SuccedableInventoryData)inventoryData);
                }
            }));
            ArrayList<RendererCubeTarget> rendererCubeTargets = new ArrayList<RendererCubeTarget>();
            int affectedContainers = 0;
            player.f_36096_.m_38946_();
            for (SuccedableInventoryData inventoryData2 : nearbyInventories) {
                int color;
                if (inventoryData2.success) {
                    ++affectedContainers;
                    color = 65280;
                } else {
                    color = 0xFF0000;
                }
                RendererCubeTarget rendererCubeTarget = new RendererCubeTarget(inventoryData2.blockEntity.m_58899_(), color);
                rendererCubeTargets.add(rendererCubeTarget);
            }
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CReportPacket(this.itemsCounter, affectedContainers, nearbyInventories.size(), rendererCubeTargets));
        });
        ctx.get().setPacketHandled(true);
    }

    public void dropOff(Player player, IItemHandler target, SuccedableInventoryData data) {
        InvWrapper playerstacks = new InvWrapper((Container)player.m_150109_());
        for (int i = 0; i < 36; ++i) {
            ItemStack playerstack;
            if (this.ignoreHotbar && i < 9 || (playerstack = playerstacks.getStackInSlot(i)).m_41619_() || ItemStackUtils.isFavorited(playerstack)) continue;
            data.setSuccessful();
            this.itemsCounter += playerstack.m_41613_();
            ItemStack rem = playerstacks.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 0; j < target.getSlots() && !(rem = target.insertItem(j, rem, false)).m_41619_(); ++j) {
            }
            if (rem.m_41619_()) continue;
            this.itemsCounter -= rem.m_41613_();
            playerstacks.insertItem(i, rem, false);
        }
    }

    public void dropOffExisting(Player player, IItemHandler target, SuccedableInventoryData data) {
        InvWrapper playerstacks = new InvWrapper((Container)player.m_150109_());
        for (int i = 0; i < 36; ++i) {
            int j;
            boolean hasExistingStack;
            ItemStack playerstack;
            if (this.ignoreHotbar && i < 9 || (playerstack = playerstacks.getStackInSlot(i)).m_41619_() || ItemStackUtils.isFavorited(playerstack) || !(hasExistingStack = IntStream.range(0, target.getSlots()).mapToObj(arg_0 -> ((IItemHandler)target).getStackInSlot(arg_0)).filter(existing -> !existing.m_41619_()).anyMatch(existing -> existing.m_41720_() == playerstack.m_41720_()))) continue;
            data.setSuccessful();
            this.itemsCounter += playerstack.m_41613_();
            ItemStack rem = playerstacks.extractItem(i, Integer.MAX_VALUE, false);
            int[] emptySlots = new int[target.getSlots()];
            int numEmptySlots = 0;
            for (j = 0; j < target.getSlots(); ++j) {
                if (target.getStackInSlot(j).m_41619_()) {
                    emptySlots[numEmptySlots] = j;
                    ++numEmptySlots;
                }
                if (rem.m_41720_() == target.getStackInSlot(j).m_41720_() && (rem = target.insertItem(j, rem, false)).m_41619_()) break;
            }
            for (j = 0; j < numEmptySlots && !(rem = target.insertItem(emptySlots[j], rem, false)).m_41619_(); ++j) {
            }
            if (rem.m_41619_()) continue;
            this.itemsCounter -= rem.m_41613_();
            playerstacks.insertItem(i, rem, false);
        }
    }

    public Set<SuccedableInventoryData> getNearbyInventories(ServerPlayer player) {
        double playerX = player.m_20182_().f_82479_;
        double playerY = player.m_20182_().f_82480_;
        double playerZ = player.m_20182_().f_82481_;
        int minX = (int)(playerX - (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        int maxX = (int)(playerX + (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        int minY = (int)(playerY - (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        int maxY = (int)(playerY + (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        int minZ = (int)(playerZ - (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        int maxZ = (int)(playerZ + (double)((Integer)DropOffConfig.scanRadius.get()).intValue());
        Level world = player.m_9236_();
        return BlockPos.m_121886_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).map(arg_0 -> ((Level)world).m_7702_(arg_0)).filter(Objects::nonNull).filter(tileEntity -> tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(iItemHandler -> iItemHandler.getSlots() >= this.minSlotCount).isPresent()).filter(tileEntity -> !this.teTypes.contains(tileEntity.m_58903_())).map(SuccedableInventoryData::new).collect(Collectors.toSet());
    }

    public void encode(FriendlyByteBuf buf) {
        buf = new PacketBufferExt(buf);
        buf.writeBoolean(this.ignoreHotbar);
        buf.writeBoolean(this.dump);
        ((PacketBufferExt)buf).writeRegistryIdArray(this.teTypes);
        buf.writeInt(this.minSlotCount);
    }
}

