/*
 * Decompiled with CFR 0.152.
 */
package tfar.quickstack.client.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tfar.quickstack.client.ClientUtils;
import tfar.quickstack.client.RendererCubeTarget;
import tfar.quickstack.config.DropOffConfig;

@Mod.EventBusSubscriber(modid="quickstack", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderWorldLastEventHandler {
    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderLevelStageEvent event) {
        RendererCube.INSTANCE.tryToRender(event);
    }

    public static class RendererCube {
        public static final RendererCube INSTANCE = new RendererCube();
        private List<RendererCubeTarget> rendererCubeTargets = new ArrayList<RendererCubeTarget>();
        private long lastDrawTime;

        public void draw(List<RendererCubeTarget> rendererCubeTargets) {
            this.rendererCubeTargets = rendererCubeTargets;
            this.lastDrawTime = System.currentTimeMillis();
        }

        void tryToRender(RenderLevelStageEvent event) {
            long timeWhenDissapear = this.lastDrawTime + (long)((Integer)DropOffConfig.Client.highlightDelay.get()).intValue();
            if (System.currentTimeMillis() >= timeWhenDissapear && (long)((Integer)DropOffConfig.Client.highlightDelay.get()).intValue() >= 0L) {
                return;
            }
            ClientUtils.renderBlocks(event, this.rendererCubeTargets);
        }
    }
}

