/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.shoot;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.shoot.EARangedBowAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

@LoadFeature(module="enhancedai:skeleton", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from up to 64 blocks and try to stay away from the target. Use the enhancedai:better_skeleton_shoot entity type tag to add more skeletons that are affected by this feature")
public class SkeletonShoot
extends Feature {
    public static final TagKey<EntityType<?>> BETTER_SKELETON_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("better_skeleton_shoot"));
    public static final String STRAFE = "enhancedai:strafe";
    public static final String SHOOTING_RANGE = "enhancedai:shooting_range";
    public static final String SHOOTING_COOLDOWN = "enhancedai:shooting_cooldown";
    public static final String BOW_CHARGE_TICKS = "enhancedai:bow_charge_ticks";
    public static final String INACCURACY = "enhancedai:inaccuracy";
    private static final String SPAMMER = "enhancedai:spammer";
    @Config(min=1.0, max=64.0, description="The range from where a skeleton will shoot a player")
    public static MinMax shootingRange = new MinMax(24.0, 32.0);
    @Config(min=0.0, description="The ticks cooldown after shooting")
    public static MinMax shootingCooldown = new MinMax(35.0, 40.0);
    @Config(min=0.0, description="The ticks the skeleton charges the bow. at least 20 ticks for a full charge.")
    public static MinMax bowChargeTicks = new MinMax(15.0, 30.0);
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to spawn with the ability to strafe (like vanilla)")
    public static Double strafeChance = 0.333;
    @Config(min=0.0, max=30.0, description="How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.")
    public static Difficulty arrowInaccuracy = new Difficulty(6.0, 5.0, 3.0);
    @Config(min=0.0, max=1.0, description="Chance for a Skeleton to spawn as a spammer, which spams arrows instead of fully charging the bow")
    public static Double spammerChance = 0.07;

    public SkeletonShoot(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!SkeletonShoot.isEnabled(SkeletonShoot.class) || !skeleton.m_6095_().m_204039_(BETTER_SKELETON_SHOOT)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean strafe = NBTUtils.getBooleanOrPutDefault(persistentData, STRAFE, skeleton.m_217043_().m_188500_() < strafeChance);
        int shootingRange1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_RANGE, shootingRange.getIntRandBetween(skeleton.m_217043_()));
        double inaccuracy = NBTUtils.getDoubleOrPutDefault(persistentData, INACCURACY, arrowInaccuracy.getByDifficulty(skeleton.m_9236_()));
        boolean spammer = NBTUtils.getBooleanOrPutDefault(persistentData, SPAMMER, skeleton.m_217043_().m_188500_() < spammerChance);
        int shootingCooldown1 = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_COOLDOWN, shootingCooldown.getIntRandBetween(skeleton.m_217043_()));
        int bowChargeTicks1 = NBTUtils.getIntOrPutDefault(persistentData, BOW_CHARGE_TICKS, bowChargeTicks.getIntRandBetween(skeleton.m_217043_()));
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
            break;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (hasAIArrowAttack) {
            if (spammer) {
                shootingCooldown1 = 30;
                bowChargeTicks1 = 1;
                inaccuracy *= 2.5;
            }
            EARangedBowAttackGoal rangedBowAttackGoal = (EARangedBowAttackGoal)new EARangedBowAttackGoal(skeleton, 1.0, (float)shootingRange1, strafe).setBowChargeTicks(bowChargeTicks1).setAttackCooldown(shootingCooldown1).setInaccuracy((float)inaccuracy);
            skeleton.f_21345_.m_25352_(2, (Goal)rangedBowAttackGoal);
        }
    }
}

