/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.targeting;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAHurtByTargetGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.CustomHostileConfig;
import insane96mcp.enhancedai.modules.mobs.targeting.EANearestAttackableTarget;
import insane96mcp.enhancedai.modules.mobs.targeting.EASpiderTargetGoal;
import insane96mcp.enhancedai.setup.EAAttributes;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Change how mobs target players. Use the enhancedai:use_target_changes and enhancedai:use_follow_range_changes entity type tag to whitelist mobs. Add mobs to enhancedai:allow_target_switch entity type tag to allow these mobs to be able to switch targets when hit (e.g. Creepers can't normally do that).")
public class Targeting
extends JsonFeature {
    public static final TagKey<EntityType<?>> USE_TARGET_CHANGES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("use_target_changes"));
    public static final TagKey<EntityType<?>> CHANGE_FOLLOW_RANGE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("change_follow_range"));
    public static final TagKey<EntityType<?>> APPLY_XRAY = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("apply_xray"));
    public static final TagKey<EntityType<?>> ALLOW_TARGET_SWITCH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("allow_target_switch"));
    public static final String SPRINT = "enhancedai:sprint";
    public static final String IS_NEUTRAL = "enhancedai:is_neutral";
    public static final String CAN_FORGET_TARGET = "enhancedai:can_forget_target";
    public static final String FOLLOW_RANGES_PROCESSED = "enhancedai:follow_ranges_processed";
    public static final List<CustomHostileConfig> CUSTOM_HOSTILE_DEFAULT_LIST = List.of(new CustomHostileConfig(2, IdTagMatcher.newTag((String)"enhancedai:config/can_attack_villagers"), IdTagMatcher.newId((String)"minecraft:villager"), 0.5), new CustomHostileConfig(2, IdTagMatcher.newTag((String)"enhancedai:config/can_attack_iron_golem"), IdTagMatcher.newId((String)"minecraft:iron_golem"), 0.5));
    public static final List<CustomHostileConfig> customHostile = new ArrayList<CustomHostileConfig>();
    @Config(min=0.0, max=128.0, description="How far away can the mobs see the player. This overrides the vanilla value (16 for most mobs). Setting 'Max' to 0 will leave the follow range as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute. Only mobs in the entity type tag `enhancedai:change_follow_range` will be affected by this override")
    public static MinMax followRangeOverride = new MinMax(24.0, 48.0);
    @Config(min=0.0, max=128.0, description="How far away can the mobs see the player even through walls. Setting 'Max' to 0 will make mobs not able to see through walls. I recommend using mods like Mobs Properties Randomness to have more control over the attribute; the attribute name is 'enhancedai:generic.xray_follow_range'. Only mobs in the entity type tag `enhancedai:apply_xray` will be affected by this override.")
    public static MinMax xrayRangeOverride = new MinMax(12.0, 24.0);
    @Config(description="By default, the new targeting AI only changes for targeting players. Setting this to true allows overriding target AI for entities other than players. Please note this might break specific AIs")
    public static Boolean targetingOverrideForNonPlayers = false;
    @Config(description="Mobs will no longer take random time to target a player.")
    public static Boolean instantTarget = false;
    @Config(description="Chance for a mob to be able to forget about it's target. If the mob can forget the target it will forget about it after 'Unseen forgot ticks' have passed.")
    public static Double forgetTargetChance = 0.1;
    @Config(description="If the mob can forget the target it will forget about it after this amount of ticks have passed while not seeing the target.")
    public static Integer unseenForgotTicks = 400;
    @Config(description="Mobs will be able to find better paths to the target. Note that this might hit performance a bit.")
    public static Boolean betterPathfinding = true;
    @Config(description="Mobs will actually switch target when attacked unless it's the same or if the current one it's closer.")
    public static Boolean betterHurtByTarget$enable = true;
    @Config(description="Mobs will prefer to attack players instead of other mobs (Note that 'Prevent infighting' should be disabled).")
    public static Boolean betterHurtByTarget$preferPlayers = true;
    @Config(min=0.0, max=1.0, description="Change for a mob to not attack other mobs when hit.")
    public static Double betterHurtByTarget$preventInfighting = 0.9;
    @Config(min=0.0, max=1.0, description="Chances for a mob to spawn neutral")
    public static Difficulty neutralChances = new Difficulty(0.25, 0.1, 0.04);
    @Config(min=0.0, max=1.0, description="If the mobs' affected by blindness effect the target range is multiplied by this value")
    public static Double blindnessRangeMultiplier = 0.1;

    public Targeting(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("custom_hostile.json", customHostile, CUSTOM_HOSTILE_DEFAULT_LIST, CustomHostileConfig.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/enhancedai";
    }

    public static void xrayRangeAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get())) continue;
            event.add(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get(), 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        this.processFollowRanges(mob);
        this.processTargetGoal(mob);
        this.processCustomTargetGoal(mob);
        this.processHurtByGoal(mob);
        boolean sprint = NBTUtils.getBooleanOrPutDefault(mob.getPersistentData(), SPRINT, false);
        if (sprint) {
            mob.m_6858_(true);
        }
    }

    private void processHurtByGoal(Mob mob) {
        PathfinderMob pathfinderMob;
        if (!(betterHurtByTarget$enable.booleanValue() && mob instanceof PathfinderMob && (pathfinderMob = (PathfinderMob)mob).m_6095_().m_204039_(USE_TARGET_CHANGES))) {
            return;
        }
        ArrayList<HurtByTargetGoal> toRemove = new ArrayList<HurtByTargetGoal>();
        ArrayList<WrappedGoal> toAdd = new ArrayList<WrappedGoal>();
        for (WrappedGoal prioritizedGoal : pathfinderMob.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof HurtByTargetGoal)) continue;
            HurtByTargetGoal goal2 = (HurtByTargetGoal)goal;
            toRemove.add(goal2);
            ArrayList<Class> toIgnoreDamage = new ArrayList<Class>(Arrays.asList(goal2.f_26035_));
            if (betterHurtByTarget$preventInfighting > 0.0 && (double)mob.m_217043_().m_188501_() < betterHurtByTarget$preventInfighting && mob instanceof Enemy) {
                toIgnoreDamage.add(Enemy.class);
            }
            EAHurtByTargetGoal newGoal = new EAHurtByTargetGoal(pathfinderMob, (Class[])toIgnoreDamage.toArray(Class[]::new));
            if (goal2.f_26036_ != null) {
                newGoal.setAlertOthers(goal2.f_26036_);
            }
            toAdd.add(new WrappedGoal(prioritizedGoal.m_26012_(), (Goal)newGoal));
        }
        toAdd.forEach(wrappedGoal -> pathfinderMob.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_()));
        if (!toRemove.isEmpty()) {
            toRemove.forEach(arg_0 -> ((GoalSelector)pathfinderMob.f_21346_).m_25363_(arg_0));
        } else if (mob.m_6095_().m_204039_(ALLOW_TARGET_SWITCH)) {
            ArrayList<Class<Enemy>> toIgnoreDamage = new ArrayList<Class<Enemy>>();
            if (betterHurtByTarget$preventInfighting > 0.0 && (double)mob.m_217043_().m_188501_() < betterHurtByTarget$preventInfighting) {
                toIgnoreDamage.add(Enemy.class);
            }
            EAHurtByTargetGoal newGoal = new EAHurtByTargetGoal(pathfinderMob, (Class[])toIgnoreDamage.toArray(Class[]::new));
            pathfinderMob.f_21346_.m_25352_(1, (Goal)newGoal);
        }
    }

    private void processTargetGoal(Mob mob) {
        if (!mob.m_6095_().m_204039_(USE_TARGET_CHANGES)) {
            return;
        }
        ArrayList<WrappedGoal> goalsToAdd = new ArrayList<WrappedGoal>();
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : mob.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal goal2 = (NearestAttackableTargetGoal)goal;
            if (goal2.f_26048_ != Player.class && !targetingOverrideForNonPlayers.booleanValue()) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
            boolean isNeutral = NBTUtils.getBooleanOrPutDefault(mob.getPersistentData(), IS_NEUTRAL, mob.m_217043_().m_188500_() < neutralChances.getByDifficulty(mob.m_9236_()));
            if (isNeutral) continue;
            boolean canForgetUnseen = NBTUtils.getBooleanOrPutDefault(mob.getPersistentData(), CAN_FORGET_TARGET, mob.m_217043_().m_188500_() < forgetTargetChance);
            int unseenTargetTicks = NBTUtils.getIntOrPutDefault(mob.getPersistentData(), CAN_FORGET_TARGET, unseenForgotTicks);
            EANearestAttackableTarget newTargetGoal = mob instanceof Spider ? new EASpiderTargetGoal((Spider)mob, goal2.f_26048_, canForgetUnseen, true, goal2.f_26051_, unseenTargetTicks) : new EANearestAttackableTarget(mob, goal2.f_26048_, canForgetUnseen, true, goal2.f_26051_, unseenTargetTicks);
            if (instantTarget.booleanValue()) {
                newTargetGoal.setInstaTarget();
            }
            goalsToAdd.add(new WrappedGoal(prioritizedGoal.m_26012_(), newTargetGoal));
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21346_).m_25363_(arg_0));
        goalsToAdd.forEach(wrappedGoal -> mob.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_()));
        if (betterPathfinding.booleanValue()) {
            mob.m_21573_().m_26529_(4.0f);
        }
    }

    private void processCustomTargetGoal(Mob mob) {
        if (customHostile.isEmpty()) {
            return;
        }
        for (CustomHostileConfig chc : customHostile) {
            if (!chc.attacker.matchesEntity((Entity)mob) || (double)mob.m_217043_().m_188501_() > chc.chance) continue;
            EANearestAttackableTarget<LivingEntity> targetGoal = new EANearestAttackableTarget<LivingEntity>(mob, LivingEntity.class, chc.victim, chc.mustSee, false, TargetingConditions.m_148352_());
            if (instantTarget.booleanValue()) {
                targetGoal.setInstaTarget();
            }
            mob.f_21346_.m_25352_(chc.priority, targetGoal);
        }
    }

    private void processFollowRanges(Mob mob) {
        CompoundTag persistentData = mob.getPersistentData();
        if (!persistentData.m_128471_(FOLLOW_RANGES_PROCESSED)) {
            if (mob.m_6095_().m_204039_(CHANGE_FOLLOW_RANGE) && Targeting.followRangeOverride.min != 0.0 && mob.m_21051_(Attributes.f_22277_) != null && mob.m_21051_(Attributes.f_22277_).m_22115_() < Targeting.followRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mob, (Attribute)Attributes.f_22277_, (double)followRangeOverride.getIntRandBetween(mob.m_217043_()));
            }
            if (mob.m_6095_().m_204039_(APPLY_XRAY) && Targeting.xrayRangeOverride.min != 0.0 && mob.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()) != null && mob.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()).m_22115_() < Targeting.xrayRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mob, (Attribute)((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()), (double)xrayRangeOverride.getIntRandBetween(mob.m_217043_()));
            }
            persistentData.m_128379_(FOLLOW_RANGES_PROCESSED, true);
        }
    }

    @SubscribeEvent
    public void onTargetDistanceMultiplier(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || blindnessRangeMultiplier == 1.0) {
            return;
        }
        Entity entity = event.getLookingEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_)) {
            event.modifyVisibility(blindnessRangeMultiplier.doubleValue());
        }
    }
}

