/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.movement;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.movement.ClimbLaddersGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Makes mobs be able to move in more ways, like climbing or swim. Only mobs in the enhancedai:allow_climbing entity type tag are allowed to climb.")
public class Movement
extends Feature {
    public static final TagKey<EntityType<?>> ALLOW_CLIMBING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("allow_climbing"));
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("6d2cb27e-e5e3-41b9-8108-f74131a90cce");
    final UUID UUID_MOV_SPEED_MULTIPLIER = UUID.fromString("8230810c-c178-4c01-b066-95e831b6defe");
    @Config(description="If true, mobs will be able to climb (up and down)")
    public static Boolean allowClimbing = true;
    @Config(min=0.0, max=8.0, description="Use Mobs Properties Randomness to have more control over this.")
    public static Double bonusMovementSpeed = 0.15;
    @Config(min=0.0, max=4.0, description="How faster mobs can swim. Setting to 0 will leave the swim speed as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute.")
    public static Double swimSpeedAdditionMultiplier = 2.5;

    public Movement(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Mob && (mob = (Mob)entity).m_6095_().m_204039_(ALLOW_CLIMBING))) {
            return;
        }
        if (allowClimbing.booleanValue()) {
            mob.f_21345_.m_25352_(3, (Goal)new ClimbLaddersGoal(mob));
        }
        if (bonusMovementSpeed > 0.0) {
            MCUtils.applyModifier((LivingEntity)mob, (Attribute)Attributes.f_22279_, (UUID)this.UUID_MOV_SPEED_MULTIPLIER, (String)"Enhanced AI Mov Speed Bonus", (double)bonusMovementSpeed, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)true);
        }
        if (swimSpeedAdditionMultiplier != 0.0) {
            MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Swim Speed Multiplier", (double)swimSpeedAdditionMultiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
    }
}

