/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.EANearestAttackableTarget;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", description="Mobs can flee or attack Wardens. Use the entity type tag enhancedai:ignore_warden_interaction to blacklist mobs.")
public class WardenInteractions
extends Feature {
    public static final TagKey<EntityType<?>> IGNORE_WARDEN_INTERACTION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("ignore_warden_interaction"));
    @Config(description="If true, mobs will flee from the Warden")
    public static Boolean flee = true;
    @Config(min=0.0, max=10.0, description="Speed multiplier when the mob runs from explosions and it's within 7 blocks from him.")
    public static Double runSpeedNear = 1.25;
    @Config(min=0.0, max=10.0, description="Speed multiplier when the mob runs from explosions and it's farther than 7 blocks from him.")
    public static Double runSpeedFar = 1.1;
    @Config(description="If true, mobs will attack the Warden. This has priority over fleeing.")
    public static Boolean target = false;

    public WardenInteractions(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        PathfinderMob entity;
        Entity entity2;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity2 = event.getEntity()) instanceof PathfinderMob) || (entity = (PathfinderMob)entity2).m_6095_().m_204039_(IGNORE_WARDEN_INTERACTION)) {
            return;
        }
        if (target.booleanValue()) {
            entity.f_21346_.m_25352_(2, new EANearestAttackableTarget<Warden>((Mob)entity, Warden.class, false, false, TargetingConditions.m_148352_()));
        } else if (flee.booleanValue()) {
            EAAvoidEntityGoal<Warden> avoidEntityGoal = new EAAvoidEntityGoal<Warden>(entity, Warden.class, 12.0f, 7.0f, runSpeedNear, runSpeedFar);
            entity.f_21345_.m_25352_(1, avoidEntityGoal);
        }
    }
}

