/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.util;

import io.github.tofodroid.mods.mimi.common.midi.DrumKitName;
import io.github.tofodroid.mods.mimi.common.midi.MidiPatchName;
import java.util.HashMap;
import java.util.Map;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public abstract class MidiFileUtils {
    public static byte[] getChannelMapping(Sequence sequence) {
        byte[] result = new byte[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = -1;
        }
        for (Track track : sequence.getTracks()) {
            if (track == null || track.size() <= 0) continue;
            for (int i = 0; i < track.size(); ++i) {
                if (!(track.get(i).getMessage() instanceof ShortMessage)) continue;
                ShortMessage message = (ShortMessage)track.get(i).getMessage();
                if (message.getChannel() != 9 && 192 == message.getCommand() && result[message.getChannel()] == -1) {
                    result[message.getChannel()] = Integer.valueOf(message.getData1()).byteValue();
                    continue;
                }
                if (message.getChannel() == 9 && 192 == message.getCommand()) {
                    result[message.getChannel()] = Integer.valueOf(message.getData1()).byteValue();
                    continue;
                }
                if (message.getChannel() != 9 || 144 != message.getCommand()) continue;
                result[message.getChannel()] = 0;
            }
        }
        return result;
    }

    public static Map<Integer, String> getInstrumentMapping(byte[] channelMap) {
        int i;
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        for (i = 0; i < 16; ++i) {
            mapping.put(i, null);
        }
        for (i = 0; i < 16; ++i) {
            if (channelMap[i] < 0) continue;
            if (i != 9) {
                mapping.put(i, MidiPatchName.getForPatch((Integer)Integer.valueOf((int)Byte.valueOf((byte)channelMap[i]).intValue())).name);
                continue;
            }
            mapping.put(i, DrumKitName.getForPatch((Integer)Integer.valueOf((int)Byte.valueOf((byte)channelMap[i]).intValue())).name);
        }
        return mapping;
    }

    public static Integer getSongLenghtSeconds(Sequence sequence) {
        return Integer.parseInt(Long.valueOf(sequence.getMicrosecondLength() / 1000000L).toString());
    }

    public static Integer getTempoBPM(Sequence sequence, Long tickPos) {
        Integer lastBpm = 120;
        for (Track track : sequence.getTracks()) {
            if (track == null || track.size() <= 0) continue;
            for (int i = 0; i < track.size(); ++i) {
                MetaMessage message;
                if (!(track.get(i).getMessage() instanceof MetaMessage) || (message = (MetaMessage)track.get(i).getMessage()).getType() != 81 || message.getData().length != 3) continue;
                byte[] data = message.getData();
                int mspq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                Integer newBpm = Math.round(6.0E7f / (float)mspq);
                if (track.get(i).getTick() > tickPos && lastBpm != null) continue;
                lastBpm = newBpm;
            }
        }
        return lastBpm;
    }

    public static Integer getTempoBPM(Sequence sequence) {
        return MidiFileUtils.getTempoBPM(sequence, 0L);
    }
}

