/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.playlist;

import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class PlaylistData
extends SavedData {
    public ArrayList<UUID> favoriteSongs = new ArrayList();
    public APlaylistHandler.LoopMode loopMode = APlaylistHandler.LoopMode.NONE;
    public APlaylistHandler.FavoriteMode favoriteMode = APlaylistHandler.FavoriteMode.ALL;
    public APlaylistHandler.SourceMode sourceMode = APlaylistHandler.SourceMode.ALL;
    public Boolean isShuffled = false;
    public Integer shuffleSeed = 0;

    public CompoundTag m_7176_(CompoundTag tag) {
        return PlaylistData.writeToTag(this, tag);
    }

    public static PlaylistData loadFromTag(CompoundTag tag) {
        PlaylistData data = new PlaylistData();
        if (tag.m_128441_("FAVORITE_SONGS")) {
            CompoundTag favoriteSongTag = tag.m_128469_("FAVORITE_SONGS");
            data.favoriteSongs = new ArrayList(favoriteSongTag.m_128431_().stream().map(key -> UUID.fromString(key)).collect(Collectors.toList()));
        }
        if (tag.m_128441_("LOOP_MODE")) {
            APlaylistHandler.LoopMode loopMode = data.loopMode = tag.m_128471_("LOOP_MODE") ? APlaylistHandler.LoopMode.ALL : APlaylistHandler.LoopMode.SINGLE;
        }
        if (tag.m_128441_("FAVORITE_MODE")) {
            APlaylistHandler.FavoriteMode favoriteMode = data.favoriteMode = tag.m_128471_("FAVORITE_MODE") ? APlaylistHandler.FavoriteMode.FAVORITE : APlaylistHandler.FavoriteMode.NOT_FAVORITE;
        }
        if (tag.m_128441_("SOURCE_MODE")) {
            APlaylistHandler.SourceMode sourceMode = data.sourceMode = tag.m_128471_("SOURCE_MODE") ? APlaylistHandler.SourceMode.CLIENT : APlaylistHandler.SourceMode.SERVER;
        }
        if (tag.m_128441_("shuffled")) {
            data.isShuffled = true;
            data.shuffleSeed = tag.m_128451_("shuffled");
        }
        return data;
    }

    public static CompoundTag writeToTag(PlaylistData data, CompoundTag resultTag) {
        CompoundTag favoriteSongTag = new CompoundTag();
        if (!data.favoriteSongs.isEmpty()) {
            Integer i = 0;
            while (i < data.favoriteSongs.size()) {
                favoriteSongTag.m_128379_(data.favoriteSongs.get(i).toString(), true);
                Integer n = i;
                i = i + 1;
            }
            resultTag.m_128365_("FAVORITE_SONGS", (Tag)favoriteSongTag);
        } else {
            resultTag.m_128473_("FAVORITE_SONGS");
        }
        if (data.loopMode != APlaylistHandler.LoopMode.NONE) {
            resultTag.m_128379_("LOOP_MODE", data.loopMode == APlaylistHandler.LoopMode.ALL);
        } else {
            resultTag.m_128473_("LOOP_MODE");
        }
        if (data.favoriteMode != APlaylistHandler.FavoriteMode.ALL) {
            resultTag.m_128379_("FAVORITE_MODE", data.favoriteMode == APlaylistHandler.FavoriteMode.FAVORITE);
        } else {
            resultTag.m_128473_("FAVORITE_MODE");
        }
        if (data.sourceMode != APlaylistHandler.SourceMode.ALL) {
            resultTag.m_128379_("SOURCE_MODE", data.sourceMode == APlaylistHandler.SourceMode.CLIENT);
        } else {
            resultTag.m_128473_("SOURCE_MODE");
        }
        if (data.isShuffled.booleanValue()) {
            resultTag.m_128405_("shuffled", data.shuffleSeed.intValue());
        } else {
            resultTag.m_128473_("shuffled");
        }
        return resultTag;
    }
}

