/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.note.consumer;

import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.note.NoteEvent;
import io.github.tofodroid.mods.mimi.server.ServerExecutorProxy;
import it.unimi.dsi.fastutil.longs.Long2BooleanArrayMap;
import java.util.LinkedHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ServerNoteConsumer {
    private static final Integer CLEAR_EVENT_CACHE_EVERY_TICKS = 10;
    private static Integer eventCacheClearTickCounter = 0;
    private static final LinkedHashMap<ResourceKey<Level>, Long2BooleanArrayMap> EVENT_CACHE_MAP = new LinkedHashMap();

    public static void onServerTick() {
        if (eventCacheClearTickCounter >= CLEAR_EVENT_CACHE_EVERY_TICKS) {
            eventCacheClearTickCounter = 0;
            EVENT_CACHE_MAP.clear();
        } else {
            Integer n = eventCacheClearTickCounter;
            eventCacheClearTickCounter = eventCacheClearTickCounter + 1;
        }
    }

    public static void handleEvent(NoteEvent message) {
        ServerLevel worldIn = ServerExecutorProxy.getLevel((ResourceKey<Level>)message.dimension);
        Long2BooleanArrayMap eventMap = EVENT_CACHE_MAP.computeIfAbsent((ResourceKey<Level>)worldIn.m_46472_(), d -> new Long2BooleanArrayMap());
        if (message.type == MidiEventType.NOTE_ON) {
            eventMap.computeIfAbsent(message.pos.m_121878_(), key -> {
                if (worldIn.m_46749_(message.pos)) {
                    worldIn.m_220407_(GameEvent.f_223696_, message.pos, GameEvent.Context.m_223722_((BlockState)worldIn.m_8055_(message.pos)));
                    worldIn.m_220407_(GameEvent.f_238690_, message.pos, GameEvent.Context.m_223722_((BlockState)worldIn.m_8055_(message.pos)));
                    worldIn.m_5898_(null, NoteEvent.MIMI_NOTE_PLAYING_LEVEL_EVENT_ID.intValue(), message.pos, (int)message.note.byteValue());
                }
                return true;
            });
        }
    }
}

