/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.common;

import io.github.tofodroid.mods.mimi.common.network.BroadcastEventPacket;
import io.github.tofodroid.mods.mimi.common.network.BroadcastEventPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ClientMidiListPacket;
import io.github.tofodroid.mods.mimi.common.network.ClientMidiListPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.ConfigurableMidiTileSyncPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacket;
import io.github.tofodroid.mods.mimi.common.network.EffectEmitterUpdatePacketHandler;
import io.github.tofodroid.mods.mimi.common.network.MIMIConfigPacket;
import io.github.tofodroid.mods.mimi.common.network.MIMIConfigPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.MultiNoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.MultiNoteEventPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMidiUploadPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerSongListPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerMusicPlayerStatusPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.SyncInstrumentPacket;
import io.github.tofodroid.mods.mimi.common.network.SyncInstrumentPacketHandler;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacket;
import io.github.tofodroid.mods.mimi.common.network.TransmitterControlPacketHandler;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkManager {
    private static final String NET_PROTOCOL = "2";
    private static final SimpleChannel MOD_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("mimi", "mod_channel")).networkProtocolVersion(() -> "2").clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).simpleChannel();

    public static void sendToServer(Object message) {
        MOD_CHANNEL.sendToServer(message);
    }

    public static void sendToPlayer(Object message, ServerPlayer player) {
        MOD_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static void sendToPlayersInRange(Object message, BlockPos sourcePos, ServerLevel worldIn, ServerPlayer excludePlayer, Double range) {
        MOD_CHANNEL.send(NetworkManager.getPlayersInRangeTarget(sourcePos, worldIn, excludePlayer, range), message);
    }

    protected static PacketDistributor.PacketTarget getPlayersInRangeTarget(BlockPos targetPos, ServerLevel worldIn, ServerPlayer excludePlayer, Double range) {
        return PacketDistributor.NEAR.with(() -> {
            if (excludePlayer == null) {
                return new PacketDistributor.TargetPoint((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), range.doubleValue(), worldIn.m_46472_());
            }
            return new PacketDistributor.TargetPoint(excludePlayer, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), range.doubleValue(), worldIn.m_46472_());
        });
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkManager.registerMessage(0, NoteEventPacket.class, NoteEventPacket::encodePacket, NoteEventPacket::decodePacket, NetworkManager.createHandler(NoteEventPacketHandler::handlePacketClient, NoteEventPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(1, SyncInstrumentPacket.class, SyncInstrumentPacket::encodePacket, SyncInstrumentPacket::decodePacket, NetworkManager.createHandler(SyncInstrumentPacketHandler::handlePacketClient, SyncInstrumentPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(2, ClientMidiListPacket.class, ClientMidiListPacket::encodePacket, ClientMidiListPacket::decodePacket, NetworkManager.createHandler(ClientMidiListPacketHandler::handlePacketClient, ClientMidiListPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(3, ServerMusicPlayerStatusPacket.class, ServerMusicPlayerStatusPacket::encodePacket, ServerMusicPlayerStatusPacket::decodePacket, NetworkManager.createHandler(ServerMusicPlayerStatusPacketHandler::handlePacketClient, ServerMusicPlayerStatusPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(4, ServerMusicPlayerSongListPacket.class, ServerMusicPlayerSongListPacket::encodePacket, ServerMusicPlayerSongListPacket::decodePacket, NetworkManager.createHandler(ServerMusicPlayerSongListPacketHandler::handlePacketClient, ServerMusicPlayerSongListPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(5, ServerTimeSyncPacket.class, ServerTimeSyncPacket::encodePacket, ServerTimeSyncPacket::decodePacket, NetworkManager.createHandler(ServerTimeSyncPacketHandler::handlePacketClient, ServerTimeSyncPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(6, ConfigurableMidiTileSyncPacket.class, ConfigurableMidiTileSyncPacket::encodePacket, ConfigurableMidiTileSyncPacket::decodePacket, NetworkManager.createHandler(ConfigurableMidiTileSyncPacketHandler::handlePacketClient, ConfigurableMidiTileSyncPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(7, TransmitterControlPacket.class, TransmitterControlPacket::encodePacket, TransmitterControlPacket::decodePacket, NetworkManager.createHandler(TransmitterControlPacketHandler::handlePacketClient, TransmitterControlPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(8, ServerMidiUploadPacket.class, ServerMidiUploadPacket::encodePacket, ServerMidiUploadPacket::decodePacket, NetworkManager.createHandler(ServerMidiUploadPacketHandler::handlePacketClient, ServerMidiUploadPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(9, EffectEmitterUpdatePacket.class, EffectEmitterUpdatePacket::encodePacket, EffectEmitterUpdatePacket::decodePacket, NetworkManager.createHandler(EffectEmitterUpdatePacketHandler::handlePacketClient, EffectEmitterUpdatePacketHandler::handlePacketServer));
        NetworkManager.registerMessage(10, MultiNoteEventPacket.class, MultiNoteEventPacket::encodePacket, MultiNoteEventPacket::decodePacket, NetworkManager.createHandler(MultiNoteEventPacketHandler::handlePacketClient, MultiNoteEventPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(11, BroadcastEventPacket.class, BroadcastEventPacket::encodePacket, BroadcastEventPacket::decodePacket, NetworkManager.createHandler(BroadcastEventPacketHandler::handlePacketClient, BroadcastEventPacketHandler::handlePacketServer));
        NetworkManager.registerMessage(12, MIMIConfigPacket.class, MIMIConfigPacket::encodePacket, MIMIConfigPacket::decodePacket, NetworkManager.createHandler(MIMIConfigPacketHandler::handlePacketClient, MIMIConfigPacketHandler::handlePacketServer));
    }

    public static <T> void registerMessage(Integer index, Class<T> messageClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> handler) {
        MOD_CHANNEL.messageBuilder(messageClass, index.intValue()).encoder(encoder).decoder(decoder).consumerNetworkThread(handler).add();
    }

    public static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> createHandler(Consumer<T> handleClient, BiConsumer<T, ServerPlayer> handleServer) {
        return (message, ctx) -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> NetworkManager.lambda$createHandler$3(handleServer, message, (Supplier)ctx));
            } else {
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> handleClient.accept(message));
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static /* synthetic */ void lambda$createHandler$3(BiConsumer handleServer, Object message, Supplier ctx) {
        handleServer.accept(message, ((NetworkEvent.Context)ctx.get()).getSender());
    }
}

