/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.client;

import io.github.tofodroid.mods.mimi.client.gui.GuiMechanicalMaestroContainerScreen;
import io.github.tofodroid.mods.mimi.client.gui.GuiTuningTableContainerScreen;
import io.github.tofodroid.mods.mimi.client.renderer.EntityNoteResponseTileRenderer;
import io.github.tofodroid.mods.mimi.client.renderer.EntitySeatRenderer;
import io.github.tofodroid.mods.mimi.common.block.AColoredBlock;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.container.ModContainers;
import io.github.tofodroid.mods.mimi.common.entity.ModEntities;
import io.github.tofodroid.mods.mimi.common.item.IColorableItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.keybind.ModBindings;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="mimi", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistrationHandler {
    @SubscribeEvent
    public static void register(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ModContainers.TUNINGTABLE, GuiTuningTableContainerScreen::new);
        MenuScreens.m_96206_(ModContainers.MECHANICALMAESTRO, GuiMechanicalMaestroContainerScreen::new);
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (KeyMapping bind : ModBindings.REGISTRANTS) {
            event.register(bind);
        }
    }

    @SubscribeEvent
    public static void register(RegisterColorHandlersEvent.Item event) {
        ClientRegistrationHandler.registerIColorableItemColors(event, ModItems.INSTRUMENT_ITEMS.stream().filter(i -> i.isColorable()).collect(Collectors.toList()));
        ClientRegistrationHandler.registerIColorableItemColors(event, ModItems.BLOCK_INSTRUMENT_ITEMS.stream().filter(i -> i.isColorable()).collect(Collectors.toList()));
        ClientRegistrationHandler.registerIDyeableItemColors(event, Arrays.asList(ModItems.LEDCUBE_A, ModItems.LEDCUBE_B, ModItems.LEDCUBE_C, ModItems.LEDCUBE_D, ModItems.LEDCUBE_E, ModItems.LEDCUBE_F, ModItems.LEDCUBE_G, ModItems.LEDCUBE_H));
    }

    @SubscribeEvent
    public static void register(RegisterColorHandlersEvent.Block event) {
        ClientRegistrationHandler.registerInstrumentBlockColors(event);
        ClientRegistrationHandler.registerAColoredBlockColors(event, Arrays.asList(ModBlocks.LEDCUBE_A, ModBlocks.LEDCUBE_B, ModBlocks.LEDCUBE_C, ModBlocks.LEDCUBE_D, ModBlocks.LEDCUBE_E, ModBlocks.LEDCUBE_F, ModBlocks.LEDCUBE_G, ModBlocks.LEDCUBE_H));
    }

    @SubscribeEvent
    public static void register(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntities.SEAT, EntitySeatRenderer::new);
        event.registerEntityRenderer(ModEntities.NOTERESPONSIVETILE, EntityNoteResponseTileRenderer::new);
    }

    protected static void registerIColorableItemColors(RegisterColorHandlersEvent.Item event, List<? extends IColorableItem> items) {
        event.getItemColors().m_92689_((stack, color) -> color > 0 ? -1 : ((IColorableItem)stack.m_41720_()).m_41121_(stack), (ItemLike[])items.toArray(new Item[items.size()]));
    }

    protected static void registerInstrumentBlockColors(RegisterColorHandlersEvent.Block event) {
        List<Block> blocks = ModBlocks.INSTRUMENTS.stream().filter(i -> i.isColorable()).collect(Collectors.toList());
        event.getBlockColors().m_92589_((state, reader, pos, color) -> reader != null && pos != null && reader.m_7702_(pos) != null && reader.m_7702_(pos) instanceof TileInstrument ? ((TileInstrument)reader.m_7702_(pos)).getColor() : -1, blocks.toArray(new Block[blocks.size()]));
    }

    protected static void registerIDyeableItemColors(RegisterColorHandlersEvent.Item event, List<? extends BlockItem> items) {
        event.getItemColors().m_92689_((stack, color) -> color > 0 ? -1 : DyeColor.m_41053_((int)TagUtils.getIntOrDefault(stack, AColoredBlock.DYE_ID.m_61708_(), 0)).m_41070_(), (ItemLike[])items.toArray(new Item[items.size()]));
    }

    protected static void registerAColoredBlockColors(RegisterColorHandlersEvent.Block event, List<? extends AColoredBlock> blocks) {
        event.getBlockColors().m_92589_((state, reader, pos, color) -> reader != null && pos != null && state.m_60734_() instanceof AColoredBlock ? AColoredBlock.getDecimalColorFromState(state) : -1, blocks.toArray(new Block[blocks.size()]));
    }
}

