/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.world;

import com.mojang.datafixers.util.Pair;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ModStructures {
    private static final ResourceLocation desertHouse = new ResourceLocation("mimi", "village/desert/houses/instrumentalist_house");
    private static final ResourceLocation plainsHouse = new ResourceLocation("mimi", "village/plains/houses/instrumentalist_house");
    private static final ResourceLocation savannaHouse = new ResourceLocation("mimi", "village/savanna/houses/instrumentalist_house");
    private static final ResourceLocation snowyHouse = new ResourceLocation("mimi", "village/snowy/houses/instrumentalist_house");
    private static final ResourceLocation taigaHouse = new ResourceLocation("mimi", "village/taiga/houses/instrumentalist_house");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public static void registerVillageStructures(Registry<StructureProcessorList> structureProcessorList, Registry<StructureTemplatePool> structureTemplatePool) {
        if (ConfigProxy.isInstrumentalistShopEnabled().booleanValue()) {
            ModStructures.addBuildingToPool(structureTemplatePool, structureProcessorList, new ResourceLocation("minecraft:village/desert/houses"), desertHouse.toString(), 2);
            ModStructures.addBuildingToPool(structureTemplatePool, structureProcessorList, new ResourceLocation("minecraft:village/plains/houses"), plainsHouse.toString(), 2);
            ModStructures.addBuildingToPool(structureTemplatePool, structureProcessorList, new ResourceLocation("minecraft:village/savanna/houses"), savannaHouse.toString(), 2);
            ModStructures.addBuildingToPool(structureTemplatePool, structureProcessorList, new ResourceLocation("minecraft:village/snowy/houses"), snowyHouse.toString(), 2);
            ModStructures.addBuildingToPool(structureTemplatePool, structureProcessorList, new ResourceLocation("minecraft:village/taiga/houses"), taigaHouse.toString(), 2);
        }
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool != null) {
            Holder.Reference processorHolder = processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
            SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
            for (int i = 0; i < weight; ++i) {
                pool.f_210560_.add((Object)piece);
            }
            ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
            listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
            pool.f_210559_ = listOfPieceEntries;
        }
    }
}

