/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableMidiPowerSourceBlock;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiNoteResponsiveTile;
import io.github.tofodroid.mods.mimi.util.ByteUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import it.unimi.dsi.fastutil.ints.Int2ByteArrayMap;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AConfigurableMidiPowerSourceTile
extends AConfigurableMidiNoteResponsiveTile {
    public static final Integer MAX_NOTE_ON_SECONDS = 10;
    protected Map<Integer, Long> heldNotes = new Int2LongArrayMap();
    protected Map<Integer, Byte> heldVelocities = new Int2ByteArrayMap();
    protected List<Integer> notesToTurnOff = new ArrayList<Integer>();
    protected Byte heldVelocity = 0;
    protected Boolean noteHeld = false;
    protected Integer offCounter = 0;
    protected Boolean analogMode = false;
    protected Boolean triggerHeld = false;
    protected Byte holdTicks = 0;

    public AConfigurableMidiPowerSourceTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    protected AConfigurableMidiPowerSourceTile(BlockEntityType<?> type, BlockPos pos, BlockState state, Integer inventorySize) {
        super(type, pos, state, inventorySize);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.m_58904_().m_5776_()) {
            this.offCounter = 0;
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.m_58904_().m_5776_()) {
            this.offCounter = 0;
        }
    }

    @Override
    protected void cacheMidiSettings() {
        super.cacheMidiSettings();
        this.setInverted(MidiNbtDataUtils.getInvertSignal(this.getSourceStack()));
        this.analogMode = MidiNbtDataUtils.getAnalogMode(this.getSourceStack());
        this.triggerHeld = MidiNbtDataUtils.getTriggerNoteStart(this.getSourceStack()) == false;
        this.holdTicks = MidiNbtDataUtils.getHoldTicks(this.getSourceStack());
        this.noteHeld = false;
        this.clearNotes();
    }

    @Override
    public void execServerTick(ServerLevel world, BlockPos pos, BlockState state) {
        if (this.isBlockValid().booleanValue()) {
            Boolean shouldBePowered = this.noteHeld;
            if (shouldBePowered.booleanValue()) {
                this.setPower(this.velocityToPower(this.heldVelocity));
                this.offCounter = 0;
            } else if ((Integer)state.m_61143_((Property)AConfigurableMidiPowerSourceBlock.POWER) > 0) {
                if (this.offCounter >= this.holdTicks - 1) {
                    this.offCounter = 0;
                    this.setPower(0);
                } else {
                    Integer n = this.offCounter;
                    this.offCounter = this.offCounter + 1;
                }
            }
            this.noteHeld = this.tickNotes();
        }
    }

    public Boolean isHeld() {
        return this.triggerHeld != false && this.noteHeld != false;
    }

    public Byte getHeldVelocity() {
        return this.heldVelocity;
    }

    public Integer velocityToPower(Byte velocity) {
        int stepAmount = 8;
        int powerLevel = 15;
        if (velocity <= 0) {
            return 0;
        }
        for (int i = 120; i >= 1; i -= stepAmount) {
            if (velocity >= i) {
                return powerLevel;
            }
            --powerLevel;
            stepAmount = stepAmount == 8 ? 9 : 8;
        }
        return 0;
    }

    public Boolean isBlockValid() {
        return this.m_58900_().m_60734_() instanceof AConfigurableMidiPowerSourceBlock;
    }

    public Boolean isPowered() {
        return (Integer)this.m_58900_().m_61143_((Property)AConfigurableMidiPowerSourceBlock.POWER) > 0;
    }

    public Boolean isInverted() {
        return (Boolean)this.m_58900_().m_61143_((Property)AConfigurableMidiPowerSourceBlock.INVERTED);
    }

    public Boolean stackIsInverted() {
        return MidiNbtDataUtils.getInvertSignal(this.getSourceStack());
    }

    public void setInverted(Boolean inverted) {
        if (this.m_58900_().m_61143_((Property)AConfigurableMidiPowerSourceBlock.INVERTED) != inverted) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AConfigurableMidiPowerSourceBlock.INVERTED, (Comparable)inverted));
            this.m_58904_().m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public void setPower(Integer power) {
        if (this.m_58900_().m_61143_((Property)AConfigurableMidiPowerSourceBlock.POWER) != power) {
            if (!this.isValid().booleanValue()) {
                return;
            }
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AConfigurableMidiPowerSourceBlock.POWER, (Comparable)power));
            this.m_58904_().m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    protected Byte calcHeldVelocity() {
        return this.analogMode != false ? this.heldVelocities.values().stream().max(Byte::compareTo).orElse(ByteUtils.ZERO) : (byte)127;
    }

    protected Integer getUniqueNoteInt(Byte group, Byte note) {
        return group * 128 + note;
    }

    protected Boolean tickNotes() {
        if (this.triggerHeld.booleanValue()) {
            ArrayList<Integer> notesToRemove = new ArrayList<Integer>();
            Long nowTime = Instant.now().toEpochMilli();
            for (Integer noteId : this.heldNotes.keySet()) {
                if (!this.notesToTurnOff.contains(noteId) && nowTime - this.heldNotes.get(noteId) < (long)(MAX_NOTE_ON_SECONDS * 1000)) continue;
                notesToRemove.add(noteId);
            }
            if (!this.notesToTurnOff.isEmpty()) {
                for (Integer noteId : notesToRemove) {
                    this.heldNotes.remove(noteId);
                    this.heldVelocities.remove(noteId);
                }
                this.heldVelocity = this.calcHeldVelocity();
            }
            this.notesToTurnOff.clear();
            return !this.heldNotes.isEmpty();
        }
        this.clearNotes();
        return false;
    }

    protected void clearNotes() {
        this.heldNotes.clear();
        this.heldVelocities.clear();
        this.heldVelocity = 0;
        this.notesToTurnOff.clear();
    }

    protected Boolean hasNotesOn() {
        return !this.heldNotes.isEmpty();
    }

    @Override
    public void onNoteOn(@Nullable Byte channel, @Nonnull Byte note, @Nonnull Byte velocity, @Nullable Byte instrumentId, Long noteTime) {
        Integer noteId = this.getUniqueNoteInt(this.getNoteGroupKey(channel, instrumentId), note);
        this.heldNotes.put(noteId, Instant.now().toEpochMilli());
        this.heldVelocities.put(noteId, velocity);
        this.heldVelocity = velocity > this.heldVelocity ? velocity : this.heldVelocity;
        this.notesToTurnOff.remove(noteId);
        this.noteHeld = true;
    }

    @Override
    public void onNoteOff(@Nullable Byte channel, @Nonnull Byte note, @Nonnull Byte velocity, @Nullable Byte instrumentId, Long noteTime) {
        if (this.triggerHeld.booleanValue() && this.noteHeld.booleanValue()) {
            Integer noteId = this.getUniqueNoteInt(this.getNoteGroupKey(channel, instrumentId), note);
            this.notesToTurnOff.add(noteId);
        }
    }

    @Override
    public void onReset(@Nullable Byte channel, @Nullable Byte instrumentId, Long noteTime) {
        if (this.triggerHeld.booleanValue()) {
            Byte groupKey = this.getNoteGroupKey(channel, instrumentId);
            if (groupKey == null || channel != null && channel == BroadcastEvent.ALL_CHANNELS) {
                this.clearNotes();
            } else if (groupKey != null) {
                for (Integer noteId : this.heldNotes.keySet()) {
                    if (noteId / 128 != groupKey) continue;
                    this.notesToTurnOff.add(noteId);
                }
            }
        }
    }

    public abstract Byte getNoteGroupKey(@Nullable Byte var1, @Nullable Byte var2);
}

